/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryTableId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tJ\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryNameGenerator;", "", "()V", "UNIQUE_INDEX_LIBRARY_NAME_SUFFIX", "", "UNNAMED_LIBRARY_NAME_PREFIX", "generateLibraryEntityName", "legacyLibraryName", "exists", "Lkotlin/Function1;", "", "generateUniqueLibraryName", "name", "getLegacyLibraryName", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryId;", "getLibraryTableId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryTableId;", "level", "intellij.platform.projectModel.impl"})
public final class LibraryNameGenerator {
    private static final String UNIQUE_INDEX_LIBRARY_NAME_SUFFIX = "-d1a6f608-UNIQUE-INDEX-f29c-4df6-";
    @NotNull
    public static final String UNNAMED_LIBRARY_NAME_PREFIX = "#";
    @NotNull
    public static final LibraryNameGenerator INSTANCE;

    @Nullable
    public final String getLegacyLibraryName(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        if (StringsKt.startsWith$default((String)libraryId.getName(), (String)UNNAMED_LIBRARY_NAME_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)libraryId.getName(), (CharSequence)UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, (boolean)false, (int)2, null)) {
            return StringsKt.substringBefore$default((String)libraryId.getName(), (String)UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, null, (int)2, null);
        }
        return libraryId.getName();
    }

    @NotNull
    public final String generateLibraryEntityName(@Nullable String legacyLibraryName, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter(exists, (String)"exists");
        if (legacyLibraryName == null) {
            int index = 1;
            while (true) {
                String candidate;
                if (!((Boolean)exists.invoke((Object)(candidate = UNNAMED_LIBRARY_NAME_PREFIX + index))).booleanValue()) {
                    return candidate;
                }
                ++index;
            }
        }
        return this.generateUniqueLibraryName(legacyLibraryName, exists);
    }

    @NotNull
    public final String generateUniqueLibraryName(@NotNull String name2, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(exists, (String)"exists");
        if (!((Boolean)exists.invoke((Object)name2)).booleanValue()) {
            return name2;
        }
        int index = 1;
        String candidate;
        while (((Boolean)exists.invoke((Object)(candidate = name2 + UNIQUE_INDEX_LIBRARY_NAME_SUFFIX + index))).booleanValue()) {
            ++index;
        }
        return candidate;
    }

    @NotNull
    public final LibraryTableId getLibraryTableId(@NotNull String level) {
        LibraryTableId libraryTableId;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        switch (level) {
            case "module": {
                String string2 = "this method isn't supposed to be used for module-level libraries";
                throw new IllegalStateException(string2.toString());
            }
            case "project": {
                libraryTableId = (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE;
                break;
            }
            default: {
                libraryTableId = (LibraryTableId)new LibraryTableId.GlobalLibraryTableId(level);
            }
        }
        return libraryTableId;
    }

    private LibraryNameGenerator() {
    }

    static {
        LibraryNameGenerator libraryNameGenerator;
        INSTANCE = libraryNameGenerator = new LibraryNameGenerator();
    }
}

