/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import gnu.trove.TLongFloatIterator;
import gnu.trove.TLongFloatProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TLongFloatHashMap
extends TLongHash {
    protected transient float[] _values;

    public TLongFloatHashMap() {
    }

    public TLongFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TLongFloatHashMap(TLongHashingStrategy strategy) {
        super(strategy);
    }

    public TLongFloatHashMap(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TLongFloatHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TLongFloatHashMap m = (TLongFloatHashMap)super.clone();
        m._values = this._values == null ? null : (float[])this._values.clone();
        return m;
    }

    public TLongFloatIterator iterator() {
        return new TLongFloatIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public float put(long key, float value) {
        float previous = 0.0f;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        long[] oldKeys = this._set;
        float[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public float get(long key) {
        int index = this.index(key);
        return index < 0 ? 0.0f : this._values[index];
    }

    public void clear() {
        super.clear();
        long[] keys2 = this._set;
        float[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0L;
            vals[i] = 0.0f;
            states[i] = 0;
        }
    }

    public float remove(long key) {
        float prev = 0.0f;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongFloatHashMap)) {
            return false;
        }
        TLongFloatHashMap that = (TLongFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0.0f;
        super.removeAt(index);
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public long[] keys() {
        long[] keys2 = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(float val) {
        byte[] states = this._states;
        float[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TLongFloatProcedure procedure) {
        byte[] states = this._states;
        long[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TLongFloatProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        long[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TFloatFunction function) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function.execute(values2[i]);
            }
        }
    }

    public boolean increment(long key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(long key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            float val = stream.readFloat();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TLongFloatProcedure(){

            public boolean execute(long key, float value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TLongFloatProcedure {
        private final TLongFloatHashMap _otherMap;

        EqProcedure(TLongFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(long key, float value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TLongFloatProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long key, float value) {
            this.h += TLongFloatHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

