/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldParsingBehavior;
import org.apache.commons.compress.archivers.zip.JarMarker;
import org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldBehavior;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.X000A_NTFS;
import org.apache.commons.compress.archivers.zip.X0014_X509Certificates;
import org.apache.commons.compress.archivers.zip.X0015_CertificateIdForFile;
import org.apache.commons.compress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import org.apache.commons.compress.archivers.zip.X0017_StrongEncryptionHeader;
import org.apache.commons.compress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final Map<ZipShort, Class<?>> implementations = new ConcurrentHashMap();
    static final ZipExtraField[] EMPTY_ZIP_EXTRA_FIELD_ARRAY;

    public static void register(Class<?> c) {
        try {
            ZipExtraField ze = (ZipExtraField)c.newInstance();
            implementations.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(c + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(c + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(c + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        ZipExtraField field = ExtraFieldUtils.createExtraFieldNoDefault(headerId);
        if (field != null) {
            return field;
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField createExtraFieldNoDefault(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class<?> c = implementations.get(headerId);
        if (c != null) {
            return (ZipExtraField)c.newInstance();
        }
        return null;
    }

    public static ZipExtraField[] parse(byte[] data2) throws ZipException {
        return ExtraFieldUtils.parse(data2, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data2, boolean local) throws ZipException {
        return ExtraFieldUtils.parse(data2, local, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data2, boolean local, final UnparseableExtraField onUnparseableData) throws ZipException {
        return ExtraFieldUtils.parse(data2, local, new ExtraFieldParsingBehavior(){

            @Override
            public ZipExtraField onUnparseableExtraField(byte[] data2, int off, int len, boolean local, int claimedLength) throws ZipException {
                return onUnparseableData.onUnparseableExtraField(data2, off, len, local, claimedLength);
            }

            @Override
            public ZipExtraField createExtraField(ZipShort headerId) throws ZipException, InstantiationException, IllegalAccessException {
                return ExtraFieldUtils.createExtraField(headerId);
            }

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data2, int off, int len, boolean local) throws ZipException {
                return ExtraFieldUtils.fillExtraField(field, data2, off, len, local);
            }
        });
    }

    public static ZipExtraField[] parse(byte[] data2, boolean local, ExtraFieldParsingBehavior parsingBehavior) throws ZipException {
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        int dataLength = data2.length;
        for (int start2 = 0; start2 <= dataLength - 4; start2 += length + 4) {
            ZipShort headerId = new ZipShort(data2, start2);
            length = new ZipShort(data2, start2 + 2).getValue();
            if (start2 + 4 + length > dataLength) {
                ZipExtraField field = parsingBehavior.onUnparseableExtraField(data2, start2, dataLength - start2, local, length);
                if (field == null) break;
                v.add(field);
                break;
            }
            try {
                ZipExtraField ze = Objects.requireNonNull(parsingBehavior.createExtraField(headerId), "createExtraField must not return null");
                v.add(Objects.requireNonNull(parsingBehavior.fill(ze, data2, start2 + 4, length, local), "fill must not return null"));
                continue;
            }
            catch (IllegalAccessException | InstantiationException ie) {
                throw (ZipException)new ZipException(ie.getMessage()).initCause(ie);
            }
        }
        return v.toArray(EMPTY_ZIP_EXTRA_FIELD_ARRAY);
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data2) {
        byte[] local;
        int dataLength = data2.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data2[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element2 : data2) {
            sum += element2.getLocalFileDataLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data2[i].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data2[i].getLocalFileDataLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] local2 = data2[i].getLocalFileDataData();
            if (local2 == null) continue;
            System.arraycopy(local2, 0, result2, start2, local2.length);
            start2 += local2.length;
        }
        if (lastIsUnparseableHolder && (local = data2[dataLength - 1].getLocalFileDataData()) != null) {
            System.arraycopy(local, 0, result2, start2, local.length);
        }
        return result2;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data2) {
        byte[] central;
        int dataLength = data2.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data2[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element2 : data2) {
            sum += element2.getCentralDirectoryLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data2[i].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data2[i].getCentralDirectoryLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] central2 = data2[i].getCentralDirectoryData();
            if (central2 == null) continue;
            System.arraycopy(central2, 0, result2, start2, central2.length);
            start2 += central2.length;
        }
        if (lastIsUnparseableHolder && (central = data2[dataLength - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(central, 0, result2, start2, central.length);
        }
        return result2;
    }

    public static ZipExtraField fillExtraField(ZipExtraField ze, byte[] data2, int off, int len, boolean local) throws ZipException {
        try {
            if (local) {
                ze.parseFromLocalFileData(data2, off, len);
            } else {
                ze.parseFromCentralDirectoryData(data2, off, len);
            }
            return ze;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(ze.getHeaderId().getValue())).initCause(aiobe);
        }
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(X5455_ExtendedTimestamp.class);
        ExtraFieldUtils.register(X7875_NewUnix.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
        ExtraFieldUtils.register(Zip64ExtendedInformationExtraField.class);
        ExtraFieldUtils.register(X000A_NTFS.class);
        ExtraFieldUtils.register(X0014_X509Certificates.class);
        ExtraFieldUtils.register(X0015_CertificateIdForFile.class);
        ExtraFieldUtils.register(X0016_CertificateIdForCentralDirectory.class);
        ExtraFieldUtils.register(X0017_StrongEncryptionHeader.class);
        ExtraFieldUtils.register(X0019_EncryptionRecipientCertificateList.class);
        ExtraFieldUtils.register(ResourceAlignmentExtraField.class);
        EMPTY_ZIP_EXTRA_FIELD_ARRAY = new ZipExtraField[0];
    }

    public static final class UnparseableExtraField
    implements UnparseableExtraFieldBehavior {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int k) {
            this.key = k;
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data2, int off, int len, boolean local, int claimedLength) throws ZipException {
            switch (this.key) {
                case 0: {
                    throw new ZipException("Bad extra field starting at " + off + ".  Block length of " + claimedLength + " bytes exceeds remaining data of " + (len - 4) + " bytes.");
                }
                case 2: {
                    UnparseableExtraFieldData field = new UnparseableExtraFieldData();
                    if (local) {
                        field.parseFromLocalFileData(data2, off, len);
                    } else {
                        field.parseFromCentralDirectoryData(data2, off, len);
                    }
                    return field;
                }
                case 1: {
                    return null;
                }
            }
            throw new ZipException("Unknown UnparseableExtraField key: " + this.key);
        }
    }
}

