/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.oro.text.DefaultMatchAction;
import org.apache.oro.text.MatchAction;
import org.apache.oro.text.MatchActionInfo;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public final class MatchActionProcessor {
    private Pattern __fieldSeparator = null;
    private PatternCompiler __compiler;
    private PatternMatcher __matcher;
    private Vector __patterns = new Vector();
    private Vector __actions = new Vector();
    private MatchAction __defaultAction = new DefaultMatchAction();

    public MatchActionProcessor(PatternCompiler patternCompiler, PatternMatcher patternMatcher) {
        this.__compiler = patternCompiler;
        this.__matcher = patternMatcher;
    }

    public MatchActionProcessor() {
        this(new Perl5Compiler(), new Perl5Matcher());
    }

    public void addAction(String string2, int n, MatchAction matchAction2) throws MalformedPatternException {
        if (string2 != null) {
            this.__patterns.addElement(this.__compiler.compile(string2, n));
        } else {
            this.__patterns.addElement(null);
        }
        this.__actions.addElement(matchAction2);
    }

    public void addAction(String string2, int n) throws MalformedPatternException {
        this.addAction(string2, n, this.__defaultAction);
    }

    public void addAction(String string2) throws MalformedPatternException {
        this.addAction(string2, 0);
    }

    public void addAction(String string2, MatchAction matchAction2) throws MalformedPatternException {
        this.addAction(string2, 0, matchAction2);
    }

    public void setFieldSeparator(String string2, int n) throws MalformedPatternException {
        if (string2 == null) {
            this.__fieldSeparator = null;
            return;
        }
        this.__fieldSeparator = this.__compiler.compile(string2, n);
    }

    public void setFieldSeparator(String string2) throws MalformedPatternException {
        this.setFieldSeparator(string2, 0);
    }

    public void processMatches(InputStream inputStream, OutputStream outputStream, String string2) throws IOException {
        this.processMatches(new InputStreamReader(inputStream, string2), new OutputStreamWriter(outputStream));
    }

    public void processMatches(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.processMatches(new InputStreamReader(inputStream), new OutputStreamWriter(outputStream));
    }

    public void processMatches(Reader reader, Writer writer) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        PrintWriter printWriter = new PrintWriter(writer);
        MatchActionInfo matchActionInfo = new MatchActionInfo();
        ArrayList arrayList = new ArrayList();
        matchActionInfo.matcher = this.__matcher;
        matchActionInfo.fieldSeparator = this.__fieldSeparator;
        matchActionInfo.input = lineNumberReader;
        matchActionInfo.output = printWriter;
        matchActionInfo.fields = null;
        int n = this.__patterns.size();
        matchActionInfo.lineNumber = 0;
        while ((matchActionInfo.line = lineNumberReader.readLine()) != null) {
            matchActionInfo.charLine = matchActionInfo.line.toCharArray();
            for (int i = 0; i < n; ++i) {
                MatchAction matchAction2;
                Object e = this.__patterns.elementAt(i);
                if (e != null) {
                    Pattern pattern = (Pattern)this.__patterns.elementAt(i);
                    if (!this.__matcher.contains(matchActionInfo.charLine, pattern)) continue;
                    matchActionInfo.match = this.__matcher.getMatch();
                    matchActionInfo.lineNumber = lineNumberReader.getLineNumber();
                    matchActionInfo.pattern = pattern;
                    if (this.__fieldSeparator != null) {
                        arrayList.clear();
                        Util.split(arrayList, this.__matcher, this.__fieldSeparator, matchActionInfo.line);
                        matchActionInfo.fields = arrayList;
                    } else {
                        matchActionInfo.fields = null;
                    }
                    matchAction2 = (MatchAction)this.__actions.elementAt(i);
                    matchAction2.processMatch(matchActionInfo);
                    continue;
                }
                matchActionInfo.match = null;
                matchActionInfo.lineNumber = lineNumberReader.getLineNumber();
                if (this.__fieldSeparator != null) {
                    arrayList.clear();
                    Util.split(arrayList, this.__matcher, this.__fieldSeparator, matchActionInfo.line);
                    matchActionInfo.fields = arrayList;
                } else {
                    matchActionInfo.fields = null;
                }
                matchAction2 = (MatchAction)this.__actions.elementAt(i);
                matchAction2.processMatch(matchActionInfo);
            }
        }
        printWriter.flush();
        lineNumberReader.close();
    }
}

