/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input.sax;

import java.util.Arrays;
import org.jdom.Verifier;

final class TextBuffer {
    private char[] array = new char[1024];
    private int arraySize = 0;

    TextBuffer() {
    }

    void append(char[] source, int start2, int count2) {
        if (count2 + this.arraySize > this.array.length) {
            this.array = Arrays.copyOf(this.array, count2 + this.arraySize + (this.array.length >> 2));
        }
        System.arraycopy(source, start2, this.array, this.arraySize, count2);
        this.arraySize += count2;
    }

    void clear() {
        this.arraySize = 0;
    }

    boolean isAllWhitespace() {
        int i = this.arraySize;
        while (--i >= 0) {
            if (Verifier.isXMLWhitespace(this.array[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.arraySize == 0) {
            return "";
        }
        return String.valueOf(this.array, 0, this.arraySize);
    }
}

