/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public final class NamespaceStack
implements Iterable<Namespace> {
    private static final Namespace[] EMPTY = new Namespace[0];
    private static final Iterable<Namespace> EMPTYITER = new EmptyIterable();
    private static final Comparator<Namespace> NSCOMP = Comparator.comparing(Namespace::getPrefix);
    private static final Namespace[] DEFAULTSEED = new Namespace[]{Namespace.NO_NAMESPACE, Namespace.XML_NAMESPACE};
    private Namespace[][] added = new Namespace[10][];
    private Namespace[][] scope = new Namespace[10][];
    private int depth = -1;

    private static int binarySearch(Namespace[] data2, int left, int right, Namespace key) {
        --right;
        while (left <= right) {
            int mid = left + right >>> 1;
            if (data2[mid] == key) {
                return mid;
            }
            int cmp = NSCOMP.compare(data2[mid], key);
            if (cmp < 0) {
                left = mid + 1;
                continue;
            }
            if (cmp > 0) {
                right = mid - 1;
                continue;
            }
            return mid;
        }
        return -left - 1;
    }

    public NamespaceStack() {
        this(DEFAULTSEED);
    }

    public NamespaceStack(Namespace[] seed) {
        ++this.depth;
        this.added[this.depth] = seed;
        this.scope[this.depth] = this.added[this.depth];
    }

    private static Namespace[] checkNamespace(List<Namespace> store, Namespace namespace, Namespace[] scope) {
        if (namespace == scope[0]) {
            return scope;
        }
        if (namespace.getPrefix().equals(scope[0].getPrefix())) {
            store.add(namespace);
            Namespace[] nscope = (Namespace[])scope.clone();
            nscope[0] = namespace;
            return nscope;
        }
        int ip = NamespaceStack.binarySearch(scope, 1, scope.length, namespace);
        if (ip >= 0 && namespace == scope[ip]) {
            return scope;
        }
        store.add(namespace);
        if (ip >= 0) {
            Namespace[] nscope = (Namespace[])scope.clone();
            nscope[ip] = namespace;
            return nscope;
        }
        Namespace[] nscope = Arrays.copyOf(scope, scope.length + 1);
        ip = -ip - 1;
        System.arraycopy(nscope, ip, nscope, ip + 1, nscope.length - ip - 1);
        nscope[ip] = namespace;
        return nscope;
    }

    public void push(Element element2) {
        ArrayList<Namespace> toadd = new ArrayList<Namespace>(8);
        Namespace mns = element2.getNamespace();
        Namespace[] newscope = NamespaceStack.checkNamespace(toadd, mns, this.scope[this.depth]);
        if (element2.hasAdditionalNamespaces()) {
            for (Namespace ns : element2.getAdditionalNamespaces()) {
                if (ns == mns) continue;
                newscope = NamespaceStack.checkNamespace(toadd, ns, newscope);
            }
        }
        if (element2.hasAttributes()) {
            for (Attribute a : element2.getAttributes()) {
                Namespace ns = a.getNamespace();
                if (ns == Namespace.NO_NAMESPACE || ns == mns) continue;
                newscope = NamespaceStack.checkNamespace(toadd, ns, newscope);
            }
        }
        this.pushStack(mns, newscope, toadd);
    }

    public void push(Attribute att) {
        ArrayList<Namespace> toadd = new ArrayList<Namespace>(1);
        Namespace mns = att.getNamespace();
        Namespace[] newscope = NamespaceStack.checkNamespace(toadd, mns, this.scope[this.depth]);
        this.pushStack(mns, newscope, toadd);
    }

    private void pushStack(Namespace mns, Namespace[] newscope, List<Namespace> toadd) {
        ++this.depth;
        if (this.depth >= this.scope.length) {
            this.scope = (Namespace[][])Arrays.copyOf(this.scope, this.scope.length * 2);
            this.added = (Namespace[][])Arrays.copyOf(this.added, this.scope.length);
        }
        if (toadd.isEmpty()) {
            this.added[this.depth] = EMPTY;
        } else {
            this.added[this.depth] = toadd.toArray(new Namespace[0]);
            if (this.added[this.depth][0] == mns) {
                Arrays.sort(this.added[this.depth], 1, this.added[this.depth].length, NSCOMP);
            } else {
                Arrays.sort(this.added[this.depth], NSCOMP);
            }
        }
        if (mns != newscope[0]) {
            if (toadd.isEmpty()) {
                newscope = (Namespace[])newscope.clone();
            }
            Namespace tmp = newscope[0];
            int ip = -NamespaceStack.binarySearch(newscope, 1, newscope.length, tmp) - 1;
            System.arraycopy(newscope, 1, newscope, 0, --ip);
            newscope[ip] = tmp;
            ip = NamespaceStack.binarySearch(newscope, 0, newscope.length, mns);
            System.arraycopy(newscope, 0, newscope, 1, ip);
            newscope[0] = mns;
        }
        this.scope[this.depth] = newscope;
    }

    public void pop() {
        if (this.depth <= 0) {
            throw new IllegalStateException("Cannot over-pop the stack.");
        }
        this.scope[this.depth] = null;
        this.added[this.depth] = null;
        --this.depth;
    }

    public Iterable<Namespace> addedForward() {
        if (this.added[this.depth].length == 0) {
            return EMPTYITER;
        }
        return new NamespaceIterable(this.added[this.depth], true);
    }

    @Override
    public Iterator<Namespace> iterator() {
        return new ForwardWalker(this.scope[this.depth]);
    }

    public Namespace[] getScope() {
        return (Namespace[])this.scope[this.depth].clone();
    }

    public boolean isInScope(Namespace ns) {
        if (ns == this.scope[this.depth][0]) {
            return true;
        }
        int ip = NamespaceStack.binarySearch(this.scope[this.depth], 1, this.scope[this.depth].length, ns);
        if (ip >= 0) {
            return ns == this.scope[this.depth][ip];
        }
        return false;
    }

    private static final class EmptyIterable
    implements Iterable<Namespace>,
    Iterator<Namespace> {
        private EmptyIterable() {
        }

        @Override
        public Iterator<Namespace> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Namespace next() {
            throw new NoSuchElementException("Can not call next() on an empty Iterator.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove Namespaces from iterator");
        }
    }

    private static final class NamespaceIterable
    implements Iterable<Namespace> {
        private final boolean forward;
        private final Namespace[] namespaces;

        private NamespaceIterable(Namespace[] data2, boolean forward) {
            this.forward = forward;
            this.namespaces = data2;
        }

        @Override
        public Iterator<Namespace> iterator() {
            return this.forward ? new ForwardWalker(this.namespaces) : new BackwardWalker(this.namespaces);
        }
    }

    private static final class BackwardWalker
    implements Iterator<Namespace> {
        private final Namespace[] namespaces;
        private int cursor;

        BackwardWalker(Namespace[] namespaces) {
            this.namespaces = namespaces;
            this.cursor = namespaces.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= 0;
        }

        @Override
        public Namespace next() {
            if (this.cursor < 0) {
                throw new NoSuchElementException("Cannot over-iterate...");
            }
            return this.namespaces[this.cursor--];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove Namespaces from iterator");
        }
    }

    private static final class ForwardWalker
    implements Iterator<Namespace> {
        private final Namespace[] namespaces;
        private int cursor = 0;

        private ForwardWalker(Namespace[] namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.namespaces.length;
        }

        @Override
        public Namespace next() {
            if (this.cursor >= this.namespaces.length) {
                throw new NoSuchElementException("Cannot over-iterate...");
            }
            return this.namespaces[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove Namespaces from iterator");
        }
    }
}

