/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.integratedBinaryPacking;

public final class IntegratedBinaryPacking {
    public static final int INT_BLOCK_SIZE = 32;
    public static final int LONG_BLOCK_SIZE = 64;

    public static int estimateCompressedArrayLength(int[] in, int startIndex, int endIndex, int initValue) {
        int count2 = endIndex - startIndex;
        if (count2 <= 32) {
            return IntegratedBinaryPacking.getSizeInIntegers(in[startIndex] - initValue | in[endIndex - 1] - in[startIndex], count2);
        }
        int firstBlockSize = IntegratedBinaryPacking.getSizeInIntegers(in[startIndex] - initValue | in[startIndex + 31] - in[startIndex], 32);
        int delta = in[endIndex - 1] - in[startIndex + 31];
        return firstBlockSize + IntegratedBinaryPacking.getSizeInIntegers(delta, count2 - 32);
    }

    public static int estimateCompressedArrayLength(long[] in, int startIndex, int endIndex, long initValue) {
        int count2 = endIndex - startIndex;
        if (count2 <= 64) {
            return IntegratedBinaryPacking.getSizeInLongs(in[startIndex] - initValue | in[endIndex - 1] - in[startIndex], count2);
        }
        int firstBlockSize = IntegratedBinaryPacking.getSizeInLongs(in[startIndex] - initValue | in[startIndex + 63] - in[startIndex], 64);
        long delta = in[endIndex - 1] - in[startIndex + 63];
        return firstBlockSize + IntegratedBinaryPacking.getSizeInLongs(delta, count2 - 64);
    }

    private static int getSizeInIntegers(int value, int count2) {
        return IntegratedBinaryPacking.bits(value) * count2 / 32 + 1;
    }

    private static int getSizeInLongs(long value, int count2) {
        return (64 - Long.numberOfLeadingZeros(value)) * count2 / 64 + 1;
    }

    private static int bits(int i) {
        return 32 - Integer.numberOfLeadingZeros(i);
    }
}

