/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.integratedBinaryPacking.IntegratedBinaryPacking;
import org.jetbrains.mvstore.MVStoreException;

public final class DataUtil {
    public static final int VAR_INT_MAX_SIZE = 5;
    public static final int VAR_LONG_MAX_SIZE = 9;
    static final int PAGE_TYPE_LEAF = 0;
    static final int PAGE_LARGE = 0x200000;

    public static void writeString(ByteBuf buf, String s) {
        assert (s.length() <= 0x7FFFFF);
        int lengthIndex = buf.writerIndex();
        buf.ensureWritable(4 + ByteBufUtil.utf8MaxBytes((int)s.length()));
        buf.writerIndex(lengthIndex + 3);
        buf.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
        buf.setMedium(lengthIndex, buf.writerIndex() - lengthIndex - 3);
    }

    public static String readString(ByteBuf buf) {
        int length = buf.readUnsignedMedium();
        int readerIndex = buf.readerIndex();
        String result2 = buf.toString(readerIndex, length, StandardCharsets.UTF_8);
        buf.readerIndex(readerIndex + length);
        return result2;
    }

    public static void copyWithGap(Object src, Object dst, int oldSize, int gapIndex) {
        if (gapIndex > 0) {
            System.arraycopy(src, 0, dst, 0, gapIndex);
        }
        if (gapIndex < oldSize) {
            System.arraycopy(src, gapIndex, dst, gapIndex + 1, oldSize - gapIndex);
        }
    }

    public static void copyExcept(Object src, Object dst, int oldSize, int removeIndex) {
        if (removeIndex > 0 && oldSize > 0) {
            System.arraycopy(src, 0, dst, 0, removeIndex);
        }
        if (removeIndex < oldSize) {
            System.arraycopy(src, removeIndex + 1, dst, removeIndex, oldSize - removeIndex - 1);
        }
    }

    static void readFully(FileChannel file2, long position, int length, ByteBuf out, Path filePath) {
        try {
            int n;
            do {
                if ((n = out.writeBytes(file2, position, length)) < 0) {
                    throw new MVStoreException(1, "End of file " + filePath + " (position=" + position + ", length " + DataUtil.getFileSizeOrErrorMessage(file2) + ", read=" + out.writerIndex() + ", remaining=" + out.writableBytes() + ")");
                }
                position += (long)n;
            } while ((length -= n) > 0);
        }
        catch (IOException e) {
            throw new MVStoreException(1, "Reading from file " + filePath + " failed at " + position + " (length " + DataUtil.getFileSizeOrErrorMessage(file2) + "), read " + out.writerIndex() + ", remaining " + out.writableBytes(), e);
        }
    }

    private static String getFileSizeOrErrorMessage(FileChannel file2) {
        String size;
        try {
            size = Long.toString(file2.size());
        }
        catch (IOException e2) {
            size = e2.getMessage();
        }
        return size;
    }

    static void writeFully(FileChannel file2, long position, ByteBuf in) {
        try {
            int n;
            int length = in.readableBytes();
            do {
                n = in.readBytes(file2, position, length);
                position += (long)n;
            } while ((length -= n) > 0);
        }
        catch (IOException e) {
            throw new MVStoreException(2, "Writing to " + file2 + " failed; length " + in.readableBytes() + " at " + position, e);
        }
    }

    private static int encodeLength(int len) {
        if (len <= 32) {
            return 0;
        }
        int code = Integer.numberOfLeadingZeros(len);
        int remaining = len << code + 1;
        code += code;
        if ((remaining & Integer.MIN_VALUE) != 0) {
            --code;
        }
        if (remaining << 1 != 0) {
            --code;
        }
        code = Math.min(31, 52 - code);
        return code;
    }

    static int getPageChunkId(long pos) {
        return (int)(pos >>> 38);
    }

    static int getPageMapId(long tocElement) {
        return (int)(tocElement >>> 38);
    }

    public static int getPageMaxLength(long pos) {
        int code = (int)(pos >> 1 & 0x1FL);
        if (code == 31) {
            return 0x200000;
        }
        return 2 + (code & 1) << (code >> 1) + 4;
    }

    public static int getPageOffset(long tocElement) {
        return (int)(tocElement >> 6);
    }

    static int getPageType(long info) {
        return (int)info & 1;
    }

    static boolean isLeafPage(long info) {
        return DataUtil.getPageType(info) == 0;
    }

    static boolean isPageSaved(long pos) {
        return (pos & 0xFFFFFFFFFFFFFFFEL) != 0L;
    }

    static boolean isPageRemoved(long pos) {
        return pos == 1L;
    }

    public static long getPageInfo(int chunkId, int offset, int length, int type) {
        long pos = (long)chunkId << 38;
        pos |= (long)offset << 6;
        pos |= (long)DataUtil.encodeLength(length) << 1;
        return pos |= (long)type;
    }

    static long getPageInfo(int chunkId, long tocElement) {
        return tocElement & 0x3FFFFFFFFFL | (long)chunkId << 38;
    }

    static long getTocElement(int mapId, int offset, int length, int type) {
        long pos = (long)mapId << 38;
        pos |= (long)offset << 6;
        pos |= (long)DataUtil.encodeLength(length) << 1;
        return pos |= (long)type;
    }

    static short getCheckValue(int x) {
        return (short)(x >> 16 ^ x);
    }

    static int getFletcher32(ByteBuf buf, int offset, int length) {
        int s1 = 65535;
        int s2 = 65535;
        int i = offset;
        int len = offset + (length & 0xFFFFFFFE);
        while (i < len) {
            int end = Math.min(i + 720, len);
            while (i < end) {
                int x = (buf.getByte(i++) & 0xFF) << 8 | buf.getByte(i++) & 0xFF;
                s2 += (s1 += x);
            }
            s1 = (s1 & 0xFFFF) + (s1 >>> 16);
            s2 = (s2 & 0xFFFF) + (s2 >>> 16);
        }
        if ((length & 1) != 0) {
            int x = (buf.getByte(i) & 0xFF) << 8;
            s2 += (s1 += x);
        }
        s1 = (s1 & 0xFFFF) + (s1 >>> 16);
        s2 = (s2 & 0xFFFF) + (s2 >>> 16);
        return s2 << 16 | s1;
    }

    public static byte[] readByteArray(ByteBuf buf) {
        int length = IntBitPacker.readVar(buf);
        int readerIndex = buf.readerIndex();
        byte[] data2 = ByteBufUtil.getBytes((ByteBuf)buf, (int)readerIndex, (int)length);
        buf.readerIndex(readerIndex + length);
        return data2;
    }

    public static void writeByteArray(ByteBuf buf, byte[] value) {
        IntBitPacker.writeVar(buf, value.length);
        buf.writeBytes(value);
    }

    static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    public static ByteBuffer getNioBuffer(ByteBuf buf, int index, int length) {
        int nioBufferCount = buf.nioBufferCount();
        assert (nioBufferCount > 0);
        return nioBufferCount == 1 ? buf.internalNioBuffer(index, length) : buf.nioBuffer(index, length);
    }

    public static void writeLongArray(long[] values2, ByteBuf buf, int length) {
        if (length < 4) {
            for (int i = 0; i < length; ++i) {
                buf.writeLongLE(values2[i]);
            }
            return;
        }
        int lengthInBytes = length << 3;
        ByteBuffer nioBuf = DataUtil.getNioBuffer(buf, buf.writerIndex(), lengthInBytes).order(ByteOrder.LITTLE_ENDIAN);
        nioBuf.asLongBuffer().put(values2, 0, length);
        nioBuf.order(ByteOrder.BIG_ENDIAN);
        buf.writerIndex(buf.writerIndex() + lengthInBytes);
    }

    public static void writeIntArray(int[] values2, ByteBuf buf, int length) {
        if (length < 4) {
            for (int i = 0; i < length; ++i) {
                int value = values2[i];
                buf.writeIntLE(value);
            }
            return;
        }
        int lengthInBytes = length << 2;
        ByteBuffer nioBuf = DataUtil.getNioBuffer(buf, buf.writerIndex(), lengthInBytes).order(ByteOrder.LITTLE_ENDIAN);
        nioBuf.asIntBuffer().put(values2, 0, length);
        nioBuf.order(ByteOrder.BIG_ENDIAN);
        buf.writerIndex(buf.writerIndex() + lengthInBytes);
    }

    public static void readLongArray(long[] values2, ByteBuf buf, int length) {
        if (length < 4) {
            for (int i = 0; i < length; ++i) {
                values2[i] = buf.readLongLE();
            }
            return;
        }
        int lengthInBytes = length << 3;
        ByteBuffer nioBuf = DataUtil.getNioBuffer(buf, buf.readerIndex(), lengthInBytes).order(ByteOrder.LITTLE_ENDIAN);
        nioBuf.asLongBuffer().get(values2, 0, length);
        nioBuf.order(ByteOrder.BIG_ENDIAN);
        buf.readerIndex(buf.readerIndex() + lengthInBytes);
    }

    public static void readIntArray(int[] values2, ByteBuf buf, int length) {
        if (length < 4) {
            for (int i = 0; i < length; ++i) {
                values2[i] = buf.readIntLE();
            }
            return;
        }
        int lengthInBytes = length << 2;
        ByteBuffer nioBuf = DataUtil.getNioBuffer(buf, buf.readerIndex(), lengthInBytes).order(ByteOrder.LITTLE_ENDIAN);
        nioBuf.asIntBuffer().get(values2, 0, length);
        nioBuf.order(ByteOrder.BIG_ENDIAN);
        buf.readerIndex(buf.readerIndex() + lengthInBytes);
    }

    public static void packInts(int[] values2, ByteBuf buf) {
        int initValue;
        int count2 = values2.length;
        int variableEncodingLength = count2 % 32;
        if (variableEncodingLength == 0) {
            initValue = 0;
        } else {
            IntBitPacker.compressVariable(values2, 0, variableEncodingLength, buf);
            if (count2 == variableEncodingLength) {
                return;
            }
            initValue = values2[variableEncodingLength - 1];
        }
        int[] compressed = new int[IntegratedBinaryPacking.estimateCompressedArrayLength(values2, variableEncodingLength, count2, initValue)];
        int compressedArrayLength = IntBitPacker.compressIntegrated(values2, variableEncodingLength, count2, compressed, initValue);
        IntBitPacker.writeVar(buf, compressedArrayLength);
        DataUtil.writeIntArray(compressed, buf, compressedArrayLength);
    }

    public static void unpackInts(int[] values2, ByteBuf buf) {
        int initValue;
        int count2 = values2.length;
        int variableEncodingLength = count2 % 32;
        if (variableEncodingLength == 0) {
            initValue = 0;
        } else {
            IntBitPacker.decompressVariable(buf, values2, variableEncodingLength);
            initValue = values2[variableEncodingLength - 1];
            if (variableEncodingLength == count2) {
                return;
            }
        }
        int compressedArrayLength = IntBitPacker.readVar(buf);
        int[] compressed = new int[compressedArrayLength];
        DataUtil.readIntArray(compressed, buf, compressedArrayLength);
        IntBitPacker.decompressIntegrated(compressed, 0, values2, variableEncodingLength, count2, initValue);
    }
}

