/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.FreeSpaceBitSet;
import org.jetbrains.mvstore.MVStoreException;

final class FileStore {
    static final Set<? extends OpenOption> R = Collections.singleton(StandardOpenOption.READ);
    static final Set<? extends OpenOption> RW = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    static final Set<? extends OpenOption> RW_TRUNCATE = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    private final AtomicLong readCount;
    private final AtomicLong writeCount;
    private final AtomicLong writeBytes;
    final FreeSpaceBitSet freeSpace;
    private final Path file;
    private final boolean readOnly;
    private long fileSize;
    private final FileChannel fileChannel;
    private FileLock fileLock;

    FileStore(@NotNull Path file2, Set<? extends OpenOption> options, boolean useFileCache) throws IOException {
        Path parent;
        if (file2 == null) {
            FileStore.$$$reportNull$$$0(0);
        }
        this.readCount = new AtomicLong();
        this.writeCount = new AtomicLong();
        this.writeBytes = new AtomicLong();
        this.freeSpace = new FreeSpaceBitSet(2, 4096);
        this.file = file2;
        boolean bl = this.readOnly = !options.contains(StandardOpenOption.WRITE);
        if ((options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW)) && (parent = file2.getParent()) != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.fileChannel = FileChannel.open(file2, options, new FileAttribute[0]);
        try {
            try {
                this.fileLock = this.readOnly ? this.fileChannel.tryLock(0L, Long.MAX_VALUE, true) : this.fileChannel.tryLock();
            }
            catch (NonWritableChannelException e) {
                if (this.readOnly && !Files.exists(file2, new LinkOption[0])) {
                    throw new MVStoreException(1, "The file not found: " + this.file, e);
                }
                throw e;
            }
            catch (OverlappingFileLockException e) {
                throw new MVStoreException(7, "The file is locked: " + this.file, e);
            }
            if (this.fileLock == null) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new MVStoreException(7, "The file is locked: " + this.file);
            }
            this.fileSize = this.fileChannel.size();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.file.toString();
    }

    public void readFully(ByteBuf out, long position, int length) {
        DataUtil.readFully(this.fileChannel, position, length, out, this.file);
        this.readCount.incrementAndGet();
    }

    public void copy(long from, long to, int length) {
        try (FileChannel sourceFileChannel = FileChannel.open(this.file, R, new FileAttribute[0]);){
            sourceFileChannel.position(from);
            this.fileChannel.transferFrom(sourceFileChannel, to, length);
        }
        catch (IOException e) {
            throw new MVStoreException(2, "Closing failed for file: " + this.file, e);
        }
        this.readCount.incrementAndGet();
    }

    public void writeFully(ByteBuf in, long position) {
        int length = in.readableBytes();
        this.fileSize = Math.max(this.fileSize, position + (long)length);
        DataUtil.writeFully(this.fileChannel, position, in);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(length);
    }

    public void close() {
        try {
            if (this.fileChannel != null && this.fileChannel.isOpen()) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
                this.fileChannel.close();
            }
        }
        catch (Exception e) {
            throw new MVStoreException(2, "Closing failed for file: " + this.file, e);
        }
        finally {
            this.fileLock = null;
        }
    }

    void sync() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(true);
            }
            catch (IOException e) {
                throw new MVStoreException(2, "Could not sync file " + this.file);
            }
        }
    }

    long size() {
        return this.fileSize;
    }

    public void truncate(long size) {
        int attemptCount = 0;
        while (true) {
            try {
                this.writeCount.incrementAndGet();
                this.fileChannel.truncate(size);
                this.fileSize = Math.min(this.fileSize, size);
                return;
            }
            catch (IOException e) {
                if (++attemptCount == 10) {
                    throw new MVStoreException(2, "Could not truncate file " + this.file + " to size " + size, e);
                }
                Thread.yield();
                continue;
            }
            break;
        }
    }

    long getWriteCount() {
        return this.writeCount.get();
    }

    long getReadCount() {
        return this.readCount.get();
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    int getDefaultRetentionTime() {
        return 45000;
    }

    void markUsed(long pos, int length) {
        this.freeSpace.markUsed(pos, length);
    }

    long allocate(int length, long reservedLow, long reservedHigh) {
        return this.freeSpace.allocate(length, reservedLow, reservedHigh);
    }

    long predictAllocation(int blocks, long reservedLow, long reservedHigh) {
        return this.freeSpace.predictAllocation(blocks, reservedLow, reservedHigh);
    }

    void free(long pos, int length) {
        this.freeSpace.free(pos, length);
    }

    int getFillRate() {
        return this.freeSpace.getFillRate();
    }

    int getProjectedFillRate(int vacatedBlocks) {
        return this.freeSpace.getProjectedFillRate(vacatedBlocks);
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    long getFileLengthInUse() {
        return this.freeSpace.getLastFree();
    }

    int getMovePriority(int block) {
        return this.freeSpace.getMovePriority(block);
    }

    long getAfterLastBlock() {
        return this.freeSpace.getAfterLastBlock();
    }

    public void clear() {
        this.freeSpace.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/mvstore/FileStore", "<init>"));
    }
}

