/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore.type;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.integratedBinaryPacking.LongBitPacker;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.type.KeyableDataType;
import org.jetbrains.mvstore.type.LongKeyManager;

public final class LongDataType
implements KeyableDataType<Long> {
    public static final LongDataType INSTANCE = new LongDataType();

    private LongDataType() {
    }

    @Override
    public int getMemory(Long obj) {
        return this.getFixedMemory();
    }

    @Override
    public int getFixedMemory() {
        return 8;
    }

    @Override
    public void write(ByteBuf buff, Long data2) {
        LongBitPacker.writeVar(buff, data2);
    }

    @Override
    public Long read(ByteBuf buff) {
        return LongBitPacker.readVar(buff);
    }

    public Long[] createStorage(int size) {
        return new Long[size];
    }

    @Override
    public int compare(Long one, Long two) {
        return Long.compare(one, two);
    }

    @Override
    @NotNull
    public KeyManager<Long> createEmptyManager(@NotNull MVMap<Long, ?> map2) {
        if (map2 == null) {
            LongDataType.$$$reportNull$$$0(0);
        }
        return new LongKeyManager(LongKeyManager.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public KeyManager<Long> createManager(ByteBuf buf, int count2) {
        return new LongKeyManager(buf, count2);
    }

    @Override
    public boolean isGenericCompressionApplicable() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/mvstore/type/LongDataType", "createEmptyManager"));
    }
}

