/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.OrdinalFormat;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    @NlsSafe
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    public static final boolean SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
    public static final boolean SHOW_KEYS = Boolean.getBoolean("idea.l10n.keys");
    static final String L10N_MARKER = "\ud83d\udd05";
    private static final Logger LOG = Logger.getInstance(BundleBase.class);
    private static boolean assertOnMissedKeys;
    private static final String[] SUFFIXES;
    private static volatile BiConsumer<? super String, ? super String> ourTranslationConsumer;

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @Nls
    public static String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(0);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(1);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(2);
        }
        if (unassignedParams <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] newParams = Arrays.copyOf(params, params.length + unassignedParams);
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i2 = 0; i2 < unassignedParams; ++i2) {
            newParams[i2 + params.length] = prefix + i2 + suffix;
        }
        String message = BundleBase.message(bundle, key, newParams);
        return BundleBase.quotePattern(message).replace(prefix, "{").replace(suffix, "}");
    }

    @NlsSafe
    private static String quotePattern(String message) {
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder(message.length() + 5);
        for (int i2 = 0; i2 < message.length(); ++i2) {
            boolean needToQuote;
            char c2 = message.charAt(i2);
            boolean bl = needToQuote = c2 == '{' || c2 == '}';
            if (needToQuote != inQuotes) {
                inQuotes = needToQuote;
                sb.append('\'');
            }
            if (c2 == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c2);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        return sb.toString();
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(3);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(4);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(5);
        }
        String string2 = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string2 == null) {
            BundleBase.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue, Object ... params) {
        String value;
        if (key == null) {
            BundleBase.$$$reportNull$$$0(7);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(8);
        }
        if (bundle == null) {
            return defaultValue;
        }
        boolean resourceFound = true;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            resourceFound = false;
            value = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result2 = BundleBase.postprocessValue(bundle, value, params);
        BiConsumer<? super String, ? super String> consumer2 = ourTranslationConsumer;
        if (consumer2 != null) {
            consumer2.accept(key, result2);
        }
        if (!resourceFound) {
            return result2;
        }
        if (SHOW_KEYS && SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result2, " (" + key + "=" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_KEYS) {
            return BundleBase.appendLocalizationSuffix(result2, " (" + key + ")");
        }
        if (SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result2, " (" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_LOCALIZED_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result2, L10N_MARKER);
        }
        return result2;
    }

    @NotNull
    public static String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        block5: {
            String string2;
            if (bundle == null) {
                BundleBase.$$$reportNull$$$0(9);
            }
            if (key == null) {
                BundleBase.$$$reportNull$$$0(10);
            }
            try {
                Object parentBundle;
                Field parent2 = ReflectionUtil.getDeclaredField(ResourceBundle.class, "parent");
                if (parent2 == null || !((parentBundle = parent2.get(bundle)) instanceof ResourceBundle)) break block5;
                string2 = ((ResourceBundle)parentBundle).getString(key);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + "'");
            }
            if (string2 == null) {
                BundleBase.$$$reportNull$$$0(11);
            }
            return string2;
        }
        return "undefined";
    }

    @NlsSafe
    @NotNull
    protected static String appendLocalizationSuffix(@NotNull String result2, @NotNull String suffixToAppend) {
        if (result2 == null) {
            BundleBase.$$$reportNull$$$0(12);
        }
        if (suffixToAppend == null) {
            BundleBase.$$$reportNull$$$0(13);
        }
        for (String suffix : SUFFIXES) {
            if (!result2.endsWith(suffix)) continue;
            String string2 = result2.substring(0, result2.length() - suffix.length()) + L10N_MARKER + suffix;
            if (string2 == null) {
                BundleBase.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String string3 = result2 + suffixToAppend;
        if (string3 == null) {
            BundleBase.$$$reportNull$$$0(15);
        }
        return string3;
    }

    @Nls
    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue) {
        if (key == null) {
            BundleBase.$$$reportNull$$$0(16);
        }
        if (defaultValue != null) {
            String string2 = defaultValue;
            if (string2 == null) {
                BundleBase.$$$reportNull$$$0(17);
            }
            return string2;
        }
        if (assertOnMissedKeys) {
            String bundleName = bundle != null ? "(" + bundle.getBaseBundleName() + ")" : "";
            LOG.error("'" + key + "' is not found in " + bundle + bundleName);
        }
        String string3 = "!" + key + "!";
        if (string3 == null) {
            BundleBase.$$$reportNull$$$0(18);
        }
        return string3;
    }

    @Nls
    @NotNull
    static String postprocessValue(@NotNull ResourceBundle bundle, @NotNull @Nls String value, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(19);
        }
        if (value == null) {
            BundleBase.$$$reportNull$$$0(20);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(21);
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
                OrdinalFormat.apply(format);
                value = format.format(params);
            }
            catch (IllegalArgumentException e) {
                value = "!invalid format: `" + value + "`!";
            }
        }
        String string2 = value;
        if (string2 == null) {
            BundleBase.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        if (value == null) {
            BundleBase.$$$reportNull$$$0(23);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(24);
        }
        String string2 = params.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params) : value;
        if (string2 == null) {
            BundleBase.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nls
    public static String replaceMnemonicAmpersand(@Nullable @Nls String value) {
        if (value == null || value.indexOf(38) < 0 || value.indexOf(27) >= 0) {
            return value;
        }
        StringBuilder builder2 = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        boolean mnemonicAdded = false;
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '\\') {
                if (i2 < value.length() - 1 && value.charAt(i2 + 1) == '&') {
                    builder2.append('&');
                    ++i2;
                    continue;
                }
                builder2.append(c2);
                continue;
            }
            if (c2 == '&') {
                if (i2 < value.length() - 1 && value.charAt(i2 + 1) == '&') {
                    if (SystemInfoRt.isMac && !mnemonicAdded) {
                        mnemonicAdded = true;
                        builder2.append('\u001b');
                    }
                    ++i2;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic || mnemonicAdded) continue;
                mnemonicAdded = true;
                builder2.append('\u001b');
                continue;
            }
            builder2.append(c2);
        }
        @NlsSafe String result2 = builder2.toString();
        return result2;
    }

    @TestOnly
    public static void setTranslationConsumer(@Nullable BiConsumer<? super String, ? super String> consumer2) {
        ourTranslationConsumer = consumer2;
    }

    static {
        SUFFIXES = new String[]{"</body></html>", "</html>"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/BundleBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixToAppend";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/BundleBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLocalizationSuffix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "useDefaultValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "postprocessValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "partialMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendLocalizationSuffix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "useDefaultValue";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "postprocessValue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

