/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeUtil;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnalysisActionUtils {
    private static AnalysisScope getFileScopeFromInspectionView(DataContext dataContext2) {
        AnalysisScope scope;
        int type;
        InspectionResultsView inspectionView = (InspectionResultsView)dataContext2.getData(InspectionResultsView.DATA_KEY);
        if (inspectionView != null && (type = (scope = inspectionView.getScope()).getScopeType()) != 4 && type != 1 && scope.isValid()) {
            return scope;
        }
        return null;
    }

    @Nullable
    public static AnalysisScope getInspectionScope(@NotNull DataContext dataContext2, @NotNull Project project2, Boolean acceptNonProjectDirectories) {
        AnalysisScope scope;
        if (dataContext2 == null) {
            AnalysisActionUtils.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            AnalysisActionUtils.$$$reportNull$$$0(1);
        }
        if ((scope = AnalysisActionUtils.getFileScopeFromInspectionView(dataContext2)) != null) {
            return scope;
        }
        scope = AnalysisActionUtils.getInspectionScopeImpl(dataContext2, project2, acceptNonProjectDirectories);
        return scope.getScopeType() != 6 ? scope : null;
    }

    @NotNull
    private static AnalysisScope getInspectionScopeImpl(@NotNull DataContext dataContext2, @NotNull Project project2, Boolean acceptNonProjectDirectories) {
        Project projectContext;
        if (dataContext2 == null) {
            AnalysisActionUtils.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            AnalysisActionUtils.$$$reportNull$$$0(3);
        }
        if ((projectContext = (Project)PlatformCoreDataKeys.PROJECT_CONTEXT.getData(dataContext2)) != null) {
            return new AnalysisScope(projectContext);
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScopeUtil.KEY.getData(dataContext2);
        if (analysisScope != null) {
            AnalysisScope analysisScope2 = analysisScope;
            if (analysisScope2 == null) {
                AnalysisActionUtils.$$$reportNull$$$0(4);
            }
            return analysisScope2;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (psiFile != null && psiFile.getManager().isInProject(psiFile)) {
            PsiDirectory psiDirectory;
            VirtualFile jarRoot;
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType && acceptNonProjectDirectories.booleanValue() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null && (psiDirectory = psiFile.getManager().findDirectory(jarRoot)) != null) {
                return new AnalysisScope(psiDirectory);
            }
            return new AnalysisScope(psiFile);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
        if (virtualFiles != null) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
            if (virtualFiles.length == 1) {
                PsiDirectory psiDirectory;
                VirtualFile file3 = virtualFiles[0];
                PsiDirectory psiDirectory2 = psiDirectory = file3.isValid() ? PsiManager.getInstance(project2).findDirectory(file3) : null;
                if (psiDirectory != null && (acceptNonProjectDirectories.booleanValue() || psiDirectory.getManager().isInProject(psiDirectory))) {
                    return new AnalysisScope(psiDirectory);
                }
            }
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                files2.add(vFile);
            }
            return new AnalysisScope(project2, files2);
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext2);
        if (moduleContext != null) {
            return new AnalysisScope(moduleContext);
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext2);
        if (modulesArray != null) {
            return new AnalysisScope(modulesArray);
        }
        return new AnalysisScope(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/AnalysisActionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/AnalysisActionUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionScopeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScopeImpl";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

