/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance(AnalysisScope.class);
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    protected static final int PACKAGE = 5;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private Set<? extends VirtualFile> myVFiles;
    private VirtualFileSet myFilesSet;
    private boolean myIncludeTestSource;
    private boolean myAnalyzeInjectedCode;

    public AnalysisScope(@NotNull Project project2) {
        if (project2 == null) {
            AnalysisScope.$$$reportNull$$$0(0);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project2;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module2) {
        if (module2 == null) {
            AnalysisScope.$$$reportNull$$$0(1);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = module2.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module2;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(Module @NotNull [] modules2) {
        if (modules2 == null) {
            AnalysisScope.$$$reportNull$$$0(2);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myModules = Arrays.asList(modules2);
        this.myModule = null;
        this.myProject = modules2[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AnalysisScope.$$$reportNull$$$0(3);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AnalysisScope.$$$reportNull$$$0(4);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project2) {
        if (scope == null) {
            AnalysisScope.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            AnalysisScope.$$$reportNull$$$0(6);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project2;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project2 == null) {
            AnalysisScope.$$$reportNull$$$0(7);
        }
        if (virtualFiles == null) {
            AnalysisScope.$$$reportNull$$$0(8);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project2;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        VirtualFileSet files2 = VfsUtilCore.createCompactVirtualFileSet(virtualFiles);
        files2.freeze();
        this.myVFiles = files2;
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        LOG.assertTrue(this.myFilesSet == null, "don't modify AnalysisScope after it has been used");
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        LOG.assertTrue(this.myFilesSet == null, "don't modify AnalysisScope after it has been used");
        this.myIncludeTestSource = includeTestSource;
    }

    public void setAnalyzeInjectedCode(boolean analyzeInjectedCode) {
        LOG.assertTrue(this.myFilesSet == null, "don't modify AnalysisScope after it has been used");
        this.myAnalyzeInjectedCode = analyzeInjectedCode;
    }

    @NotNull
    protected Processor<? super VirtualFile> createFileSearcher(@NotNull Collection<? super VirtualFile> addTo) {
        ProgressIndicator indicator;
        if (addTo == null) {
            AnalysisScope.$$$reportNull$$$0(9);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText(AnalysisBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        Processor<VirtualFile> processor = virtualFile2 -> {
            addTo.add((VirtualFile)virtualFile2);
            return true;
        };
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(10);
        }
        return processor;
    }

    private boolean isFilteredOut(@NotNull VirtualFile virtualFile2) {
        GlobalSearchScope filter2;
        if (virtualFile2 == null) {
            AnalysisScope.$$$reportNull$$$0(11);
        }
        if ((filter2 = this.myFilter) != null && !filter2.contains(virtualFile2)) {
            return true;
        }
        return !this.myIncludeTestSource && ReadAction.compute(() -> TestSourcesFilter.isTestSources(virtualFile2, this.myProject)) != false;
    }

    @NotNull
    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule == null ? ProjectRootManager.getInstance(this.myProject).getFileIndex() : ModuleRootManager.getInstance(this.myModule).getFileIndex();
        if (fileIndex == null) {
            AnalysisScope.$$$reportNull$$$0(12);
        }
        return fileIndex;
    }

    @NotNull
    private static String displayProjectRelativePath(@NotNull PsiFileSystemItem item) {
        VirtualFile virtualFile2;
        if (item == null) {
            AnalysisScope.$$$reportNull$$$0(13);
        }
        LOG.assertTrue((virtualFile2 = item.getVirtualFile()) != null, item);
        String string2 = ProjectUtilCore.displayUrlRelativeToProject(virtualFile2, virtualFile2.getPresentableUrl(), item.getProject(), true, false);
        if (string2 == null) {
            AnalysisScope.$$$reportNull$$$0(14);
        }
        return string2;
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        VirtualFile file2;
        if (psiElement == null) {
            AnalysisScope.$$$reportNull$$$0(15);
        }
        return (file2 = psiElement.getContainingFile().getVirtualFile()) != null && this.contains(file2);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AnalysisScope.$$$reportNull$$$0(16);
        }
        if (this.myFilesSet == null) {
            if (this.myType == 8 && this.myScope != null) {
                return this.myScope.contains(file2);
            }
            if (this.myType == 1) {
                ProjectFileIndex index2 = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index2.isInContent(file2) && !this.isFilteredOut(file2);
            }
        }
        return this.getFileSet().contains(file2);
    }

    @NotNull
    protected VirtualFileSet createFilesSet() {
        final VirtualFileSet fileSet = VfsUtilCore.createCompactVirtualFileSet();
        switch (this.myType) {
            case 3: {
                fileSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
                fileSet.freeze();
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                long timeStamp = System.currentTimeMillis();
                this.accept(this.createFileSearcher(fileSet));
                fileSet.freeze();
                LOG.info("Scanning scope took " + (System.currentTimeMillis() - timeStamp) + " ms");
                break;
            }
            case 9: {
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                for (VirtualFile virtualFile2 : this.myVFiles) {
                    VfsUtilCore.visitChildrenRecursively(virtualFile2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                        @Override
                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                            boolean ignored;
                            if (file2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!(ignored = ReadAction.compute(() -> fileIndex.isExcluded(file2)).booleanValue()) && !file2.isDirectory()) {
                                fileSet.add(file2);
                            }
                            VirtualFileVisitor.Result result2 = ignored ? SKIP_CHILDREN : CONTINUE;
                            if (result2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/analysis/AnalysisScope$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/analysis/AnalysisScope$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFileEx";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFileEx";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string2);
                                case 1 -> new IllegalStateException(string2);
                            };
                        }
                    });
                }
                fileSet.freeze();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.myType + "; can't create file set off it");
            }
        }
        VirtualFileSet virtualFileSet = fileSet;
        if (virtualFileSet == null) {
            AnalysisScope.$$$reportNull$$$0(17);
        }
        return virtualFileSet;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            AnalysisScope.$$$reportNull$$$0(18);
        }
        this.acceptImpl(visitor2, false);
    }

    public void acceptIdempotentVisitor(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            AnalysisScope.$$$reportNull$$$0(19);
        }
        this.acceptImpl(visitor2, true);
    }

    private void acceptImpl(@NotNull PsiElementVisitor visitor2, boolean idempotent) {
        if (visitor2 == null) {
            AnalysisScope.$$$reportNull$$$0(20);
        }
        boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        FileIndex fileIndex = this.getFileIndex();
        this.accept((? super VirtualFile file2) -> {
            if (file2.isDirectory()) {
                return true;
            }
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file2)) {
                return true;
            }
            boolean isInContent = ReadAction.compute(() -> fileIndex.isInContent((VirtualFile)file2));
            if (isInContent && !this.isFilteredOut((VirtualFile)file2) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file2, this.myProject)) {
                return AnalysisScope.processFile(file2, visitor2, psiManager, needReadAction, idempotent);
            }
            return true;
        });
    }

    public boolean accept(@NotNull Processor<? super VirtualFile> processor) {
        List<Module> modules2;
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(21);
        }
        if (this.myFilesSet != null) {
            return this.myFilesSet.process(processor);
        }
        if (this.myType == 9) {
            return this.getFileSet().process(file2 -> this.isFilteredOut((VirtualFile)file2) || processor.process((VirtualFile)file2));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (PsiElement element : psiElements) {
                VirtualFile file3 = ReadAction.compute(() -> PsiUtilCore.getVirtualFile(element));
                if (file3 == null || !files2.add(file3) || processor.process(file3)) continue;
                return false;
            }
            return true;
        }
        List<Module> list2 = modules2 = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules2 != null) {
            for (Module module2 : modules2) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module2).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, null))) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file4 = ReadAction.compute(() -> PsiUtilCore.getVirtualFile(this.myElement));
            return file4 == null || processor.process(file4);
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, null));
    }

    @NotNull
    private VirtualFileSet getFileSet() {
        VirtualFileSet fileSet = this.myFilesSet;
        if (fileSet == null) {
            this.myFilesSet = fileSet = this.createFilesSet();
        }
        VirtualFileSet virtualFileSet = fileSet;
        if (virtualFileSet == null) {
            AnalysisScope.$$$reportNull$$$0(22);
        }
        return virtualFileSet;
    }

    @NotNull
    private ContentIterator createScopeIterator(@NotNull Processor<? super VirtualFile> processor, @Nullable SearchScope searchScope2) {
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(23);
        }
        ContentIterator contentIterator = fileOrDir -> {
            boolean isInScope = ReadAction.compute(() -> {
                if (this.isFilteredOut(fileOrDir)) {
                    return false;
                }
                if (searchScope2 != null && !searchScope2.contains(fileOrDir)) {
                    return false;
                }
                return !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, this.myProject);
            });
            return !isInScope || processor.process(fileOrDir);
        };
        if (contentIterator == null) {
            AnalysisScope.$$$reportNull$$$0(24);
        }
        return contentIterator;
    }

    private static boolean processFile(@NotNull VirtualFile vFile, @NotNull PsiElementVisitor visitor2, @NotNull PsiManager psiManager, boolean needReadAction, boolean idempotent) {
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(25);
        }
        if (visitor2 == null) {
            AnalysisScope.$$$reportNull$$$0(26);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(27);
        }
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            Project project2 = psiManager.getProject();
            if (idempotent) {
                ReadAction.nonBlocking(() -> AnalysisScope.doProcessFile(visitor2, psiManager, vFile)).withDocumentsCommitted(project2).inSmartMode(project2).executeSynchronously();
            } else {
                AnalysisScope.commitAndRunInSmartMode(() -> AnalysisScope.doProcessFile(visitor2, psiManager, vFile), project2);
            }
        } else {
            AnalysisScope.doProcessFile(visitor2, psiManager, vFile);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(Runnable runnable, Project project2) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project2);
            dumbService.waitForSmartMode();
        } while (!(passed = PsiDocumentManager.getInstance(project2).commitAndRunReadAction(() -> {
            if (dumbService.isDumb()) {
                return false;
            }
            runnable.run();
            return true;
        }).booleanValue()));
    }

    private static boolean shouldHighlightFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            AnalysisScope.$$$reportNull$$$0(28);
        }
        return ProblemHighlightFilter.shouldProcessFileInBatch(file2);
    }

    public boolean containsModule(@NotNull Module module2) {
        if (module2 == null) {
            AnalysisScope.$$$reportNull$$$0(29);
        }
        return switch (this.myType) {
            case 1 -> true;
            case 4 -> {
                if (this.myModule == module2) {
                    yield true;
                }
                yield false;
            }
            case 7 -> this.myModules.contains(module2);
            case 8 -> {
                if (module2.isDisposed()) {
                    yield false;
                }
                for (VirtualFile file : ModuleRootManager.getInstance(module2).getSourceRoots()) {
                    if (!this.myScope.contains(file)) continue;
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor2, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile) {
        if (visitor2 == null) {
            AnalysisScope.$$$reportNull$$$0(30);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(31);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(32);
        }
        ProgressManager.checkCanceled();
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor2);
        InjectedLanguageManager.getInstance(psiManager.getProject()).dropFileCaches(psiFile);
    }

    protected boolean accept(@NotNull PsiDirectory dir, @NotNull Processor<? super VirtualFile> processor) {
        if (dir == null) {
            AnalysisScope.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(34);
        }
        Project project2 = dir.getProject();
        boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project2);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, fileOrDir -> {
            if (this.isFilteredOut(fileOrDir)) {
                return true;
            }
            if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project2)) {
                return true;
            }
            return fileOrDir.isDirectory() || processor.process(fileOrDir);
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module2 : this.myModules) {
                if (!module2.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        return switch (this.myType) {
            case 8 -> this.myScope.getDisplayName();
            case 4 -> AnalysisBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            case 7 -> {
                String modules = StringUtil.join(this.myModules, module2 -> AnalysisScope.pathToName(module2.getModuleFilePath()), ", ");
                yield AnalysisBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1 -> AnalysisBundle.message("scope.project", this.myProject.getName());
            case 3 -> AnalysisBundle.message("scope.file", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
            case 2 -> AnalysisBundle.message("scope.directory", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
            case 9 -> AnalysisBundle.message("scope.virtual.files", new Object[0]);
            default -> "";
        };
    }

    @NotNull
    @Nls
    public String getShortenName() {
        return switch (this.myType) {
            case 8 -> this.myScope.getDisplayName();
            case 4 -> AnalysisBundle.message("scope.option.module", this.myModule.getName());
            case 7 -> {
                String modules = StringUtil.join(this.myModules, Module::getName, ", ");
                yield AnalysisBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1 -> AnalysisBundle.message("scope.project", this.myProject.getName());
            case 3 -> {
                String relativePath = this.getRelativePath();
                yield AnalysisBundle.message("scope.file", relativePath);
            }
            case 2 -> {
                String relativeDirPath = this.getRelativePath();
                yield AnalysisBundle.message("scope.directory", relativeDirPath);
            }
            case 9 -> AnalysisBundle.message("scope.selected.files", new Object[0]);
            default -> "";
        };
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            AnalysisScope.$$$reportNull$$$0(35);
        }
        return project2;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public List<Module> getModules() {
        List<Module> list2 = this.myModules == null ? Collections.emptyList() : Collections.unmodifiableList(this.myModules);
        if (list2 == null) {
            AnalysisScope.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public Set<VirtualFile> getFiles() {
        Set<Object> set2 = this.myVFiles == null ? Collections.emptySet() : this.myVFiles;
        if (set2 == null) {
            AnalysisScope.$$$reportNull$$$0(37);
        }
        return set2;
    }

    @NotNull
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement);
        if (relativePath.length() > 100) {
            String string2 = ((PsiFileSystemItem)this.myElement).getName();
            if (string2 == null) {
                AnalysisScope.$$$reportNull$$$0(38);
            }
            return string2;
        }
        String string3 = relativePath;
        if (string3 == null) {
            AnalysisScope.$$$reportNull$$$0(39);
        }
        return string3;
    }

    @NotNull
    private static String pathToName(@NotNull String path2) {
        if (path2 == null) {
            AnalysisScope.$$$reportNull$$$0(40);
        }
        File file2 = new File(path2);
        String string2 = FileUtilRt.getNameWithoutExtension(file2.getName());
        if (string2 == null) {
            AnalysisScope.$$$reportNull$$$0(41);
        }
        return string2;
    }

    public int getFileCount() {
        return this.getFileSet().size();
    }

    public void invalidate() {
        if (this.myType == 9) {
            List<VirtualFile> valid = ContainerUtil.filter(this.myVFiles, virtualFile2 -> virtualFile2 != null && virtualFile2.isValid());
            VirtualFileSet files2 = VfsUtilCore.createCompactVirtualFileSet(valid);
            files2.freeze();
            this.myVFiles = files2;
        }
        this.myFilesSet = null;
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file2;
            Project project2 = this.myElement.getProject();
            ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index2.isInSourceContent(directory)) {
                    return isTest == TestSourcesFilter.isTestSources(directory, this.myProject);
                }
            } else if (this.myElement instanceof PsiFile && (file2 = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest == TestSourcesFilter.isTestSources(file2, this.myProject);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(42);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules2 = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules2.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules2.add(this.myModule);
        } else if (this.myType == 7) {
            modules2.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules2);
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull Set<? extends Module> modules2) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(43);
        }
        if (modules2 == null) {
            AnalysisScope.$$$reportNull$$$0(44);
        }
        if (modules2.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module2 : modules2) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module2, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module2, allModules));
            modulesToAnalyze.add(module2);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(Module.EMPTY_ARRAY));
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, Module @NotNull [] allModules) {
        if (fromModule == null) {
            AnalysisScope.$$$reportNull$$$0(45);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(46);
        }
        HashSet<Module> result2 = new HashSet<Module>();
        for (Module module2 : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (OrderEntry orderEntry2 : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry2 instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry2).isExported() || fromModule != ((ModuleOrderEntry)orderEntry2).getModule()) continue;
                result2.addAll(AnalysisScope.getDirectBackwardDependencies(module2, allModules));
            }
        }
        HashSet<Module> hashSet = result2;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(47);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module2, Module @NotNull [] allModules) {
        if (module2 == null) {
            AnalysisScope.$$$reportNull$$$0(48);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(49);
        }
        HashSet<Module> result2 = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find(ModuleRootManager.getInstance(dependency).getDependencies(), module2) <= -1) continue;
            result2.add(dependency);
        }
        HashSet<Module> hashSet = result2;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(50);
        }
        return hashSet;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            AnalysisScope.$$$reportNull$$$0(51);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(52);
        }
        HashSet<Module> modules2 = new HashSet<Module>();
        if (fileIndex.isInLibrary(vFile)) {
            for (OrderEntry orderEntry2 : fileIndex.getOrderEntriesForFile(vFile)) {
                modules2.add(orderEntry2.getOwnerModule());
            }
        } else {
            modules2.add(fileIndex.getModuleForFile(vFile));
        }
        HashSet<Module> hashSet = modules2;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(53);
        }
        return hashSet;
    }

    @NotNull
    public SearchScope toSearchScope() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        SearchScope searchScope2 = switch (this.myType) {
            case 8 -> this.myScope;
            case 2 -> GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
            case 3 -> GlobalSearchScope.fileScope((PsiFile)this.myElement);
            case 6 -> LocalSearchScope.EMPTY;
            case 4 -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                if (this.myIncludeTestSource) {
                    yield moduleScope;
                }
                yield GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
            }
            case 7 -> GlobalSearchScope.union((GlobalSearchScope[])this.myModules.stream().map(m -> GlobalSearchScope.moduleScope(m)).toArray(GlobalSearchScope[]::new));
            case 1 -> {
                if (this.myIncludeTestSource) {
                    yield GlobalSearchScope.projectScope(this.myProject);
                }
                yield GlobalSearchScopesCore.projectProductionScope(this.myProject);
            }
            case 9 -> new GlobalSearchScope(){

                @Override
                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return AnalysisScope.this.getFileSet().contains(file2);
                }

                @Override
                public boolean isSearchInModuleContent(@NotNull Module aModule) {
                    if (aModule == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return false;
                }

                @Override
                public boolean isSearchInLibraries() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aModule";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/analysis/AnalysisScope$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contains";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSearchInModuleContent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            default -> {
                LOG.error("invalid type " + this.myType);
                yield LocalSearchScope.EMPTY;
            }
        };
        if (searchScope2 == null) {
            AnalysisScope.$$$reportNull$$$0(54);
        }
        return searchScope2;
    }

    public boolean isTotalScope() {
        return this.getScopeType() == 1 && this.isIncludeTestSource();
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public boolean isAnalyzeInjectedCode() {
        return this.myAnalyzeInjectedCode;
    }

    public void setFilter(@NotNull GlobalSearchScope filter2) {
        if (filter2 == null) {
            AnalysisScope.$$$reportNull$$$0(55);
        }
        this.myFilter = filter2;
    }

    public String toString() {
        return ReadAction.compute(() -> this.toSearchScope().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 17, 22, 24, 35, 36, 37, 38, 39, 41, 47, 50, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 29: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 22: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 47: 
            case 50: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: 
            case 32: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProject";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModule";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModules";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSearcher";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "displayProjectRelativePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesSet";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSet";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeIterator";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportBackwardDependencies";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectBackwardDependencies";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterestingModules";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "toSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileSearcher";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 22: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 47: 
            case 50: 
            case 53: 
            case 54: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFilteredOut";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "displayProjectRelativePath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 18: 
            case 21: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "acceptIdempotentVisitor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "acceptImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createScopeIterator";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsModule";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doProcessFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "pathToName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedComplementaryScope";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getExportBackwardDependencies";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDirectBackwardDependencies";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterestingModules";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 12, 14, 17, 22, 24, 35, 36, 37, 38, 39, 41, 47, 50, 53, 54 -> new IllegalStateException(string2);
        };
    }

    public static @interface Type {
    }
}

