/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialogUI;
import com.intellij.analysis.ModelScopeItemView;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.find.FindSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseAnalysisActionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(BaseAnalysisActionDialog.class);
    @NotNull
    private final AnalysisUIOptions myOptions;
    private final boolean myRememberScope;
    private final boolean myShowInspectTestSource;
    private final @NlsContexts.Separator String myScopeTitle;
    @NotNull
    private final Project myProject;
    private final ArrayList<JRadioButton> radioButtons;
    private final JCheckBox myInspectTestSource;
    private final JCheckBox myAnalyzeInjectedCode;
    private final List<ModelScopeItemView> myViewItems;

    @Deprecated
    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project2, @NotNull AnalysisScope scope, String moduleName, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context2) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(0);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(3);
        }
        if (analysisUIOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(4);
        }
        this(title, scopeTitle, project2, BaseAnalysisActionDialog.standardItems(project2, scope, moduleName != null ? ModuleManager.getInstance(project2).findModuleByName(moduleName) : null, context2), analysisUIOptions, rememberScope);
    }

    @NotNull
    public static List<ModelScopeItem> standardItems(@NotNull Project project2, @NotNull AnalysisScope scope, @Nullable Module module2, @Nullable PsiElement context2) {
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(6);
        }
        List<ModelScopeItem> list2 = ContainerUtil.mapNotNull(ModelScopeItemPresenter.EP_NAME.getExtensionList(), presenter -> presenter.tryCreate(project2, scope, module2, context2));
        if (list2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project2, @NotNull List<? extends ModelScopeItem> items2, @NotNull AnalysisUIOptions options2, boolean rememberScope) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(8);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(10);
        }
        if (items2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(11);
        }
        if (options2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(12);
        }
        this(title, scopeTitle, project2, items2, options2, rememberScope, ModuleUtil.hasTestSourceRoots(project2));
    }

    public BaseAnalysisActionDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull @NlsContexts.Separator String scopeTitle, @NotNull Project project2, @NotNull List<? extends ModelScopeItem> items2, @NotNull AnalysisUIOptions options2, boolean rememberScope, boolean showInspectTestSource) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(13);
        }
        if (scopeTitle == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(15);
        }
        if (items2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(16);
        }
        if (options2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(17);
        }
        super(true);
        this.radioButtons = new ArrayList();
        this.myInspectTestSource = new JCheckBox();
        this.myAnalyzeInjectedCode = new JCheckBox();
        this.myScopeTitle = scopeTitle;
        this.myProject = project2;
        this.myViewItems = ModelScopeItemPresenter.createOrderedViews(items2, this.getDisposable());
        this.myOptions = options2;
        this.myRememberScope = rememberScope;
        this.myShowInspectTestSource = showInspectTestSource;
        this.init();
        this.setTitle(title);
        this.setResizable(false);
        this.setOKButtonText(this.getOKButtonText());
    }

    protected JComponent createCenterPanel() {
        this.myInspectTestSource.setText(CodeInsightBundle.message("scope.option.include.test.sources", new Object[0]));
        this.myInspectTestSource.setSelected(this.myOptions.ANALYZE_TEST_SOURCES);
        this.myInspectTestSource.setVisible(this.myShowInspectTestSource);
        this.myAnalyzeInjectedCode.setText(CodeInsightBundle.message("scope.option.analyze.injected.code", new Object[0]));
        this.myAnalyzeInjectedCode.setSelected(this.myOptions.ANALYZE_INJECTED_CODE);
        this.myAnalyzeInjectedCode.setVisible(false);
        JPanel panel2 = new BaseAnalysisActionDialogUI().panel(this.myScopeTitle, this.myViewItems, this.myInspectTestSource, this.myAnalyzeInjectedCode, this.radioButtons, this.myDisposable, this.getAdditionalActionSettings(this.myProject));
        this.preselectButton();
        new RadioUpDownListener(this.radioButtons.toArray(new JRadioButton[0]));
        panel2.setPreferredSize(panel2.getMinimumSize());
        return panel2;
    }

    public void setShowInspectInjectedCode(boolean showInspectInjectedCode) {
        this.myAnalyzeInjectedCode.setVisible(showInspectInjectedCode);
    }

    public void setAnalyzeInjectedCode(boolean selected) {
        this.myAnalyzeInjectedCode.setSelected(selected);
    }

    private void preselectButton() {
        int type;
        List<ModelScopeItemView> preselectedScopes;
        if (this.myRememberScope && (preselectedScopes = ContainerUtil.filter(this.myViewItems, arg_0 -> BaseAnalysisActionDialog.lambda$preselectButton$1(type = this.myOptions.SCOPE_TYPE, arg_0))).size() >= 1) {
            LOG.assertTrue(preselectedScopes.size() == 1, "preselectedScopes.size() == 1");
            preselectedScopes.get((int)0).button.setSelected(true);
            return;
        }
        ArrayList<ModelScopeItemView> candidates = new ArrayList<ModelScopeItemView>();
        for (ModelScopeItemView view : this.myViewItems) {
            candidates.add(view);
            if (view.scopeId != 3) continue;
            break;
        }
        Collections.reverse(candidates);
        for (ModelScopeItemView x : candidates) {
            int scopeType = x.scopeId;
            if (scopeType == 8 || scopeType == 10) continue;
            x.button.setSelected(true);
            break;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        for (JRadioButton button2 : this.radioButtons) {
            if (!button2.isSelected()) continue;
            return button2;
        }
        return super.getPreferredFocusedComponent();
    }

    @Deprecated
    public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project2, Module module2) {
        if (uiOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(18);
        }
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(20);
        }
        return this.getScope(defaultScope);
    }

    public boolean isProjectScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 1).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isInspectTestSources() {
        return this.myInspectTestSource.isSelected();
    }

    public boolean isAnalyzeInjectedCode() {
        return !this.myAnalyzeInjectedCode.isVisible() || this.myAnalyzeInjectedCode.isSelected();
    }

    public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(21);
        }
        AnalysisScope scope = null;
        for (ModelScopeItemView x : this.myViewItems) {
            if (!x.button.isSelected()) continue;
            int type = x.scopeId;
            scope = x.model.getScope();
            if (!this.myRememberScope) continue;
            this.myOptions.SCOPE_TYPE = type;
            if (type != 8) continue;
            this.myOptions.CUSTOM_SCOPE_NAME = scope.toSearchScope().getDisplayName();
        }
        if (scope == null) {
            scope = defaultScope;
            if (this.myRememberScope) {
                this.myOptions.SCOPE_TYPE = scope.getScopeType();
            }
        }
        if (this.myInspectTestSource.isVisible()) {
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_TEST_SOURCES = this.isInspectTestSources();
            }
            scope.setIncludeTestSource(this.isInspectTestSources());
        }
        if (this.myAnalyzeInjectedCode.isVisible()) {
            boolean analyzeInjectedCode = this.isAnalyzeInjectedCode();
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_INJECTED_CODE = analyzeInjectedCode;
            }
            scope.setAnalyzeInjectedCode(analyzeInjectedCode);
        }
        FindSettings.getInstance().setDefaultScopeName(scope.getDisplayName());
        return scope;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(@NotNull Project project2) {
        if (project2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(22);
        }
        return null;
    }

    @NotNull
    @Nls
    public String getOKButtonText() {
        String string2 = CodeInsightBundle.message("action.analyze.verb", new Object[0]);
        if (string2 == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ boolean lambda$preselectButton$1(int type, ModelScopeItemView x) {
        return x.scopeId == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeTitle";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisUIOptions";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiOptions";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisActionDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "standardItems";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "standardItems";
                break;
            }
            case 7: 
            case 23: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActionSettings";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 23 -> new IllegalStateException(string2);
        };
    }
}

