/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.dialog;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.find.FindSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CustomScopeItem
implements ModelScopeItem {
    private final Project myProject;
    private boolean mySearchInLib;
    private String myPreselect;
    private Supplier<? extends SearchScope> mySupplierScope;

    public CustomScopeItem(Project project2, @Nullable PsiElement context2) {
        this.myProject = project2;
        AnalysisUIOptions options2 = AnalysisUIOptions.getInstance(project2);
        VirtualFile file2 = PsiUtilCore.getVirtualFile(context2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        this.mySearchInLib = file2 != null && fileIndex.isInLibrary(file2);
        String string2 = this.myPreselect = StringUtil.isEmptyOrSpaces(options2.CUSTOM_SCOPE_NAME) ? FindSettings.getInstance().getDefaultScopeName() : options2.CUSTOM_SCOPE_NAME;
        if (this.mySearchInLib && GlobalSearchScope.projectScope(this.myProject).getDisplayName().equals(this.myPreselect)) {
            this.myPreselect = GlobalSearchScope.allScope(this.myProject).getDisplayName();
        }
        if (GlobalSearchScope.allScope(this.myProject).getDisplayName().equals(this.myPreselect) && options2.SCOPE_TYPE == 8) {
            options2.CUSTOM_SCOPE_NAME = this.myPreselect;
            this.mySearchInLib = true;
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean getSearchInLibFlag() {
        return this.mySearchInLib;
    }

    public String getPreselectedCustomScope() {
        return this.myPreselect;
    }

    @Override
    public AnalysisScope getScope() {
        if (this.mySupplierScope != null) {
            return new AnalysisScope(this.mySupplierScope.get(), this.myProject);
        }
        return null;
    }

    public void setSearchScopeSupplier(Supplier<? extends SearchScope> supplier2) {
        this.mySupplierScope = supplier2;
    }
}

