/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.toolWindow.HighlightingErrorsProviderBase;
import com.intellij.analysis.problemsView.toolWindow.HighlightingWatcher;
import com.intellij.codeInsight.daemon.impl.WolfTheProblemSolverImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingErrorsProvider;", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingErrorsProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "watchers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingWatcher;", "problemsAppeared", "", "file", "problemsDisappeared", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nHighlightingErrorsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingErrorsProvider.kt\ncom/intellij/analysis/problemsView/toolWindow/HighlightingErrorsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public class HighlightingErrorsProvider
implements HighlightingErrorsProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, HighlightingWatcher> watchers;

    public HighlightingErrorsProvider(@NotNull Project project2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
            this.watchers = new LinkedHashMap();
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
            Topic<ProblemListener> topic = ProblemListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, this);
            WolfTheProblemSolver wolfTheProblemSolver = WolfTheProblemSolver.getInstance(this.project);
            WolfTheProblemSolverImpl wolfTheProblemSolverImpl = wolfTheProblemSolver instanceof WolfTheProblemSolverImpl ? (WolfTheProblemSolverImpl)wolfTheProblemSolver : null;
            if (wolfTheProblemSolverImpl == null) break block0;
            wolfTheProblemSolverImpl.processProblemFiles(arg_0 -> HighlightingErrorsProvider._init_$lambda$0((Function1)new Function1<VirtualFile, Boolean>(){

                @NotNull
                public final Boolean invoke(VirtualFile it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.problemsAppeared(it);
                    return true;
                }
            }, arg_0));
        }
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void problemsAppeared(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid() || FileTypeRegistry.getInstance().isFileIgnored(file2)) {
            return;
        }
        if (this.project.isDisposed() || ProjectFileIndex.getInstance(this.project).isExcluded(file2)) {
            return;
        }
        Map<VirtualFile, HighlightingWatcher> map2 = this.watchers;
        synchronized (map2) {
            boolean bl = false;
            HighlightingWatcher highlightingWatcher = this.watchers.computeIfAbsent(file2, arg_0 -> HighlightingErrorsProvider.problemsAppeared$lambda$2$lambda$1((Function1)new Function1<VirtualFile, HighlightingWatcher>(this){
                final /* synthetic */ HighlightingErrorsProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final HighlightingWatcher invoke(@NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    HighlightingWatcher highlightingWatcher = new HighlightingWatcher(this.this$0, ProblemsCollector.Companion.getInstance(this.this$0.getProject()), file2, HighlightSeverity.ERROR.myVal);
                    HighlightingErrorsProvider highlightingErrorsProvider = this.this$0;
                    HighlightingWatcher watcher = highlightingWatcher;
                    boolean bl = false;
                    Disposer.register(highlightingErrorsProvider, watcher);
                    return highlightingWatcher;
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void problemsDisappeared(@NotNull VirtualFile file2) {
        HighlightingWatcher highlightingWatcher;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Map<VirtualFile, HighlightingWatcher> map2 = this.watchers;
        synchronized (map2) {
            boolean bl = false;
            HighlightingWatcher highlightingWatcher2 = this.watchers.remove(file2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var3_2
            highlightingWatcher = highlightingWatcher2;
        }
        if (highlightingWatcher == null) {
            return;
        }
        HighlightingWatcher watcher = highlightingWatcher;
        Disposer.dispose(watcher);
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final HighlightingWatcher problemsAppeared$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HighlightingWatcher)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final HighlightingErrorsProvider getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingErrorsProvider$Companion;", "", "()V", "getInstance", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingErrorsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HighlightingErrorsProvider getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            HighlightingErrorsProvider highlightingErrorsProvider = project2.getService(HighlightingErrorsProvider.class);
            Intrinsics.checkNotNull((Object)highlightingErrorsProvider);
            return highlightingErrorsProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

