/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.ProblemNodeFinder;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.analysis.problemsView.toolWindow.Status;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdService;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001:B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0015\u0010#\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b$J\n\u0010%\u001a\u0004\u0018\u00010&H\u0014J\n\u0010'\u001a\u0004\u0018\u00010&H\u0014J\n\u0010(\u001a\u0004\u0018\u00010)H\u0014J\b\u0010*\u001a\u00020\u0019H\u0016J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0014J\u001a\u00104\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00105\u001a\u000203H\u0002J\u001a\u00106\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00105\u001a\u000203H\u0002J\b\u00107\u001a\u00020\u0019H\u0002J\b\u00108\u001a\u00020\u0019H\u0002J\b\u00109\u001a\u00020\u0019H\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/ide/PowerSaveMode$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentFile", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCurrentFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "currentRoot", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "getCurrentRoot$intellij_platform_lang_impl", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "previousStatus", "Lcom/intellij/analysis/problemsView/toolWindow/Status;", "statusUpdateAlarm", "Lcom/intellij/util/SingleAlarm;", "fileClosed", "", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "fileOpened", "findCurrentFile", "getCurrentStatus", "getData", "", "dataId", "", "getRoot", "getRoot$intellij_platform_lang_impl", "getSortBySeverity", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getSortFoldersFirst", "getTreeExpander", "Lcom/intellij/ide/TreeExpander;", "powerSaveStateChanged", "selectHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "selectionChangedTo", "selected", "", "statusAnalyzing", "filtered", "statusComplete", "updateCurrentFile", "updateCurrentFileIfLocalId", "updateStatus", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nHighlightingPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingPanel.kt\ncom/intellij/analysis/problemsView/toolWindow/HighlightingPanel\n+ 2 ClientId.kt\ncom/intellij/codeWithMe/ClientId$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n211#2,7:167\n218#2,10:178\n211#2,7:188\n218#2,10:199\n19#3,4:174\n19#3,4:195\n*S KotlinDebug\n*F\n+ 1 HighlightingPanel.kt\ncom/intellij/analysis/problemsView/toolWindow/HighlightingPanel\n*L\n80#1:167,7\n80#1:178,10\n122#1:188,7\n122#1:199,10\n80#1:174,4\n122#1:195,4\n*E\n"})
public final class HighlightingPanel
extends ProblemsViewPanel
implements FileEditorManagerListener,
PowerSaveMode.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingleAlarm statusUpdateAlarm;
    @Nullable
    private Status previousStatus;
    @NotNull
    public static final String ID = "CurrentFile";

    public HighlightingPanel(@NotNull Project project2, @NotNull ProblemsViewState state) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(project2, ID, state, ProblemsViewBundle.messagePointer("problems.view.highlighting", new Object[0]));
        this.statusUpdateAlarm = new SingleAlarm(this::updateStatus, 200, (Disposable)this, Alarm.ThreadToUse.SWING_THREAD, ModalityState.stateForComponent((Component)((Object)this)));
        this.getTree().setShowsRootHandles(false);
        this.updateCurrentFile();
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect(this);
        Topic<FileEditorManagerListener> topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, this);
        MessageBusConnection messageBusConnection2 = ApplicationManager.getApplication().getMessageBus().connect(this);
        Topic<PowerSaveMode.Listener> topic2 = PowerSaveMode.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, this);
    }

    @Override
    @Nullable
    protected ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Override
    @Nullable
    protected TreeExpander getTreeExpander() {
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.getCurrentFile();
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected ToggleOptionAction.Option getSortBySeverity() {
        return this.mySortBySeverity;
    }

    @Override
    protected void selectionChangedTo(boolean selected) {
        super.selectionChangedTo(selected);
        if (selected) {
            this.updateCurrentFile();
        }
    }

    @Override
    public void powerSaveStateChanged() {
        this.statusUpdateAlarm.cancelAndRequest(true);
        this.updateToolWindowContent();
    }

    @Override
    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    @Override
    public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    @Override
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateCurrentFileIfLocalId();
    }

    private final void updateCurrentFileIfLocalId() {
        if (Intrinsics.areEqual((Object)ClientId.Companion.getCurrent(), (Object)this.myClientId)) {
            this.updateCurrentFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateCurrentFile() {
        VirtualFile virtualFile2;
        void this_$iv;
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId = this.myClientId;
        HighlightingPanel highlightingPanel = this;
        boolean $i$f$withClientId = false;
        ClientIdService clientIdService = this_$iv.getCachedService();
        if (clientIdService == null) {
            boolean bl = false;
            virtualFile2 = this.findCurrentFile();
        } else {
            String string2;
            void clientId$iv;
            ClientIdService service$iv = clientIdService;
            if (service$iv.isValid((ClientId)clientId$iv)) {
                void v2 = clientId$iv;
                string2 = v2 != null ? v2.getValue() : null;
            } else {
                Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    logger.trace("Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace());
                }
                string2 = null;
            }
            String newClientIdValue$iv = string2;
            String oldClientIdValue$iv = service$iv.getClientIdValue();
            try {
                service$iv.setClientIdValue(newClientIdValue$iv);
                boolean bl = false;
                VirtualFile virtualFile3 = this.findCurrentFile();
                virtualFile2 = virtualFile3;
            }
            finally {
                service$iv.setClientIdValue(oldClientIdValue$iv);
            }
        }
        highlightingPanel.setCurrentFile(virtualFile2);
    }

    @Nullable
    public final HighlightingFileRoot getCurrentRoot$intellij_platform_lang_impl() {
        Root root = this.getTreeModel().getRoot();
        return root instanceof HighlightingFileRoot ? (HighlightingFileRoot)root : null;
    }

    @Nullable
    public final VirtualFile getCurrentFile() {
        HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot$intellij_platform_lang_impl();
        return highlightingFileRoot != null ? highlightingFileRoot.getFile() : null;
    }

    public final void setCurrentFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            if (this.getCurrentRoot$intellij_platform_lang_impl() == null) {
                return;
            }
            this.getTreeModel().setRoot(null);
        } else {
            HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot$intellij_platform_lang_impl();
            if (Intrinsics.areEqual((Object)(highlightingFileRoot != null ? highlightingFileRoot.getFile() : null), (Object)file2)) {
                return;
            }
            this.getTreeModel().setRoot(this.getRoot$intellij_platform_lang_impl(file2));
            TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.getTree()));
        }
        this.powerSaveStateChanged();
    }

    @NotNull
    public final HighlightingFileRoot getRoot$intellij_platform_lang_impl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new HighlightingFileRoot(this, file2);
    }

    public final void selectHighlighter(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Object object = this.getCurrentRoot$intellij_platform_lang_impl();
        if (object == null || (object = ((HighlightingFileRoot)object).findProblem(highlighter)) == null) {
            return;
        }
        Object problem = object;
        TreeUtil.promiseSelect((JTree)((JTree)this.getTree()), (TreeVisitor)new ProblemNodeFinder((Problem)problem));
    }

    private final VirtualFile findCurrentFile() {
        VirtualFile file2;
        if (this.getProject().isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(this.getProject());
        if (fileEditorManager == null || (fileEditorManager = fileEditorManager.getSelectedEditor()) == null) {
            return null;
        }
        FileEditorManager fileEditor = fileEditorManager;
        VirtualFile virtualFile2 = file2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor().getVirtualFile() : fileEditor.getFile();
        if (file2 != null) {
            return file2;
        }
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return null;
        }
        TextEditor textEditor2 = textEditor;
        return FileDocumentManager.getInstance().getFile(textEditor2.getEditor().getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateStatus() {
        Status status;
        void this_$iv;
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId$iv = this.myClientId;
        boolean $i$f$withClientId = false;
        ClientIdService clientIdService = this_$iv.getCachedService();
        if (clientIdService == null) {
            $i$a$-withClientId-HighlightingPanel$updateStatus$status$1 = false;
            status = this.getCurrentStatus();
        } else {
            String string2;
            ClientIdService service$iv = clientIdService;
            if (service$iv.isValid(clientId$iv)) {
                ClientId clientId = clientId$iv;
                string2 = clientId != null ? clientId.getValue() : null;
            } else {
                Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    logger.trace("Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace());
                }
                string2 = null;
            }
            String newClientIdValue$iv = string2;
            String oldClientIdValue$iv = service$iv.getClientIdValue();
            try {
                service$iv.setClientIdValue(newClientIdValue$iv);
                $i$a$-withClientId-HighlightingPanel$updateStatus$status$1 = false;
                Status status2 = this.getCurrentStatus();
                status = status2;
            }
            finally {
                service$iv.setClientIdValue(oldClientIdValue$iv);
            }
        }
        Status status3 = status;
        if (!Intrinsics.areEqual((Object)this.previousStatus, (Object)status3)) {
            this.previousStatus = status3;
            this.getTree().getEmptyText().setText(status3.getTitle());
            if (((CharSequence)status3.getDetails()).length() > 0) {
                this.getTree().getEmptyText().appendLine(status3.getDetails());
            }
        }
        if (status3.getRequest()) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.statusUpdateAlarm, (boolean)false, (int)1, null);
        }
    }

    private final Status getCurrentStatus() {
        VirtualFile virtualFile2 = this.getCurrentFile();
        if (virtualFile2 == null) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.no.selected.file", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"problems.view.h\u2026ghting.no.selected.file\")");
            return new Status(string2, null, false, 6, null);
        }
        VirtualFile file2 = virtualFile2;
        if (PowerSaveMode.isEnabled()) {
            String string3 = ProblemsViewBundle.message("problems.view.highlighting.power.save.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"problems.view.h\u2026ighting.power.save.mode\")");
            return new Status(string3, null, false, 6, null);
        }
        Document document = ProblemsView.getDocument(this.getProject(), file2);
        if (document == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Document document2 = document;
        Editor editor2 = EditorFactory.getInstance().editors(document2, this.getProject()).findFirst().orElse(null);
        if (editor2 == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Editor editor3 = editor2;
        MarkupModel markupModel = editor3.getMarkupModel();
        EditorMarkupModel editorMarkupModel = markupModel instanceof EditorMarkupModel ? (EditorMarkupModel)markupModel : null;
        if (editorMarkupModel == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        EditorMarkupModel model2 = editorMarkupModel;
        ErrorStripeRenderer errorStripeRenderer = model2.getErrorStripeRenderer();
        if (errorStripeRenderer == null || (errorStripeRenderer = errorStripeRenderer.getStatus()) == null) {
            return HighlightingPanel.statusComplete$default(this, file2, false, 2, null);
        }
        ErrorStripeRenderer status = errorStripeRenderer;
        return switch (WhenMappings.$EnumSwitchMapping$0[status.getAnalyzingType().ordinal()]) {
            case 1 -> new Status(status.getTitle(), status.getDetails(), true);
            case 2 -> this.statusComplete(file2, !((Collection)this.getState().getHideBySeverity()).isEmpty());
            case 3 -> this.statusAnalyzing(file2, !((Collection)this.getState().getHideBySeverity()).isEmpty());
            default -> HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        };
    }

    private final Status statusAnalyzing(VirtualFile file2, boolean filtered) {
        Object[] objectArray = new Object[]{file2.getName()};
        String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.analyzing", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"problems.view.h\u2026ms.analyzing\", file.name)");
        String title = string2;
        if (filtered) {
            String string3 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"problems.view.h\u2026oblems.not.found.filter\")");
            String details2 = string3;
            return new Status(title, details2, true);
        }
        return new Status(title, null, true, 2, null);
    }

    static /* synthetic */ Status statusAnalyzing$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusAnalyzing(virtualFile2, bl);
    }

    private final Status statusComplete(VirtualFile file2, boolean filtered) {
        Object[] objectArray = new Object[]{file2.getName()};
        String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"problems.view.h\u2026ms.not.found\", file.name)");
        String title = string2;
        if (filtered) {
            String string3 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"problems.view.h\u2026oblems.not.found.filter\")");
            String details2 = string3;
            return new Status(title, details2, false, 4, null);
        }
        return new Status(title, null, false, 6, null);
    }

    static /* synthetic */ Status statusComplete$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusComplete(virtualFile2, bl);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalyzingType.values().length];
            try {
                nArray[AnalyzingType.SUSPENDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalyzingType.COMPLETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalyzingType.PARTIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel$Companion;", "", "()V", "ID", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

