/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.CommonBundle;
import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.HighlightingProblem;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AsyncDescriptionSupplier;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001:B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010/\u001a\u00020\fH\u0002J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\fH\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010\u001d\u001a\u000209H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000eR\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u0004\u0018\u00010%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u0014\u0010,\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0012\u00a8\u0006;"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "(Lcom/intellij/analysis/problemsView/ProblemsProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)V", "asyncDescriptionRequested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "column", "", "getColumn", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "group", "getGroup", "getHighlighter", "()Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getInfo", "()Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "line", "getLine", "loading", "position", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getPosition", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "severity", "getSeverity", "text", "getText", "computePosition", "offset", "equals", "", "other", "", "level", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "hashCode", "requestAsyncDescription", "", "Lcom/intellij/codeInsight/daemon/impl/AsyncDescriptionSupplier;", "CachedPosition", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nHighlightingProblem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingProblem.kt\ncom/intellij/analysis/problemsView/toolWindow/HighlightingProblem\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,122:1\n151#2,6:123\n151#2,6:129\n*S KotlinDebug\n*F\n+ 1 HighlightingProblem.kt\ncom/intellij/analysis/problemsView/toolWindow/HighlightingProblem\n*L\n73#1:123,6\n88#1:129,6\n*E\n"})
public final class HighlightingProblem
implements FileProblem {
    @NotNull
    private final ProblemsProvider provider;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final RangeHighlighterEx highlighter;
    @NotNull
    private AtomicBoolean asyncDescriptionRequested;
    @NotNull
    private AtomicBoolean loading;
    @Nullable
    private CachedPosition position;

    public HighlightingProblem(@NotNull ProblemsProvider provider2, @NotNull VirtualFile file2, @NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.provider = provider2;
        this.file = file2;
        this.highlighter = highlighter;
        this.asyncDescriptionRequested = new AtomicBoolean(false);
        this.loading = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public ProblemsProvider getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    private final Icon getIcon(HighlightDisplayLevel level) {
        return ((CharSequence)this.getText()).length() == 0 || this.asyncDescriptionRequested.get() ? (Icon)AnimatedIcon.Default.INSTANCE : (this.getSeverity() >= level.getSeverity().myVal ? level.getIcon() : null);
    }

    @Nullable
    public final HighlightInfo getInfo() {
        HighlightInfo info2 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)this.highlighter);
        if (info2 instanceof AsyncDescriptionSupplier) {
            this.requestAsyncDescription((AsyncDescriptionSupplier)((Object)info2));
        }
        return info2;
    }

    private final void requestAsyncDescription(AsyncDescriptionSupplier info2) {
        if (!this.asyncDescriptionRequested.compareAndSet(false, true)) {
            return;
        }
        this.loading.set(true);
        info2.requestDescription().onSuccess(arg_0 -> HighlightingProblem.requestAsyncDescription$lambda$0((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ HighlightingProblem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                ApplicationManager.getApplication().invokeLater(() -> requestAsyncDescription.1.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(HighlightingProblem this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                ProblemsViewTab problemsViewTab = ProblemsViewToolWindowUtils.INSTANCE.getTabById(this$0.getProvider().getProject(), "CurrentFile");
                HighlightingPanel panel2 = problemsViewTab instanceof HighlightingPanel ? (HighlightingPanel)problemsViewTab : null;
                Disposable disposable = panel2;
                if (disposable != null && (disposable = ((HighlightingPanel)disposable).getCurrentRoot$intellij_platform_lang_impl()) != null) {
                    ((HighlightingFileRoot)disposable).problemUpdated(this$0);
                }
                HighlightingProblem.access$getLoading$p(this$0).set(false);
            }
        }, arg_0));
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Object object;
        Object object2;
        HighlightInfo highlightInfo;
        HighlightInfo highlightInfo2 = highlightInfo = this.getInfo();
        HighlightSeverity severity = highlightInfo2 == null ? HighlightSeverity.INFORMATION : highlightInfo2.getSeverity();
        Object object3 = HighlightDisplayLevel.find(severity);
        if (object3 == null || (object3 = ((HighlightDisplayLevel)object3).getIcon()) == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"ERROR");
            object3 = this.getIcon(highlightDisplayLevel);
            if (object3 == null) {
                HighlightDisplayLevel highlightDisplayLevel2 = HighlightDisplayLevel.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel2, (String)"WARNING");
                object3 = this.getIcon(highlightDisplayLevel2);
            }
        }
        if ((object2 = object3) == null) {
            Icon icon2 = HighlightDisplayLevel.WEAK_WARNING.getIcon();
            object = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"WEAK_WARNING.icon");
        } else {
            object = object2;
        }
        return object;
    }

    @Override
    @NotNull
    public String getText() {
        Object object;
        int pos;
        String text2;
        block4: {
            int n;
            HighlightInfo highlightInfo = this.getInfo();
            String string2 = highlightInfo != null ? highlightInfo.getDescription() : null;
            if (string2 == null) {
                String string3 = CommonBundle.getLoadingTreeNodeText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLoadingTreeNodeText()");
                return string3;
            }
            text2 = string2;
            CharSequence $this$indexOfFirst$iv = text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!StringUtil.isLineBreak(it)) continue;
                n = index$iv;
                break block4;
            }
            n = pos = -1;
        }
        if (pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true)) {
            object = text2;
        } else {
            String string4 = text2.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string4 + "\u2026";
        }
        return object;
    }

    @Override
    @Nullable
    public String getGroup() {
        Object object = this.getInfo();
        if (object == null || (object = ((HighlightInfo)object).getInspectionToolId()) == null) {
            return null;
        }
        Object id = object;
        return HighlightDisplayKey.getDisplayNameByKey(HighlightDisplayKey.findById((String)id));
    }

    @Override
    @Nullable
    public String getDescription() {
        int n;
        String text2;
        block3: {
            HighlightInfo highlightInfo = this.getInfo();
            String string2 = highlightInfo != null ? highlightInfo.getDescription() : null;
            if (string2 == null) {
                return null;
            }
            text2 = string2;
            if (((CharSequence)text2).length() == 0) {
                return null;
            }
            CharSequence $this$indexOfFirst$iv = text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!StringUtil.isLineBreak(it)) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int pos = n;
        return pos < 0 || StringsKt.startsWith((String)text2, (String)"<html>", (boolean)true) ? null : "<html>" + StringUtil.join(StringUtil.splitByLines(XmlStringUtil.escapeString(text2)), "<br/>");
    }

    public final int getSeverity() {
        Object object = this.getInfo();
        return object != null && (object = ((HighlightInfo)object).getSeverity()) != null ? ((HighlightSeverity)object).myVal : -1;
    }

    public int hashCode() {
        return this.highlighter.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HighlightingProblem && Intrinsics.areEqual((Object)((HighlightingProblem)other).highlighter, (Object)this.highlighter);
    }

    @Override
    public int getLine() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getLine() : -1;
    }

    @Override
    public int getColumn() {
        CachedPosition cachedPosition = this.getPosition();
        return cachedPosition != null ? cachedPosition.getColumn() : -1;
    }

    private final CachedPosition getPosition() {
        CachedPosition cachedPosition;
        HighlightInfo highlightInfo = this.getInfo();
        if (highlightInfo != null) {
            int it = highlightInfo.getActualStartOffset();
            boolean bl = false;
            CachedPosition cachedPosition2 = this.position;
            if (!(cachedPosition2 != null ? it == cachedPosition2.getOffset() : false)) {
                this.position = this.computePosition(it);
            }
            cachedPosition = this.position;
        } else {
            cachedPosition = null;
        }
        return cachedPosition;
    }

    private final CachedPosition computePosition(int offset2) {
        if (offset2 < 0) {
            return null;
        }
        Document document = ProblemsView.getDocument(this.getProvider().getProject(), this.getFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (offset2 > document2.getTextLength()) {
            return null;
        }
        int line = document2.getLineNumber(offset2);
        return new CachedPosition(offset2, line, offset2 - document2.getLineStartOffset(line));
    }

    private static final void requestAsyncDescription$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ AtomicBoolean access$getLoading$p(HighlightingProblem $this) {
        return $this.loading;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingProblem$CachedPosition;", "", "offset", "", "line", "column", "(III)V", "getColumn", "()I", "getLine", "getOffset", "intellij.platform.lang.impl"})
    private static final class CachedPosition {
        private final int offset;
        private final int line;
        private final int column;

        public CachedPosition(int offset2, int line, int column) {
            this.offset = offset2;
            this.line = line;
            this.column = column;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }
    }
}

