/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ChangesDiffCalculator;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.formatting.service.AbstractDocumentFormattingService;
import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.PresentableEnumUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleAbstractPanel
implements Disposable,
ComponentHighlightingListener {
    private static final long TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOG = Logger.getInstance(CodeStyleAbstractPanel.class);
    private final List<TextRange> myPreviewRangesToHighlight;
    private final EditorEx myEditor;
    @NotNull
    private final CodeStyleSettings mySettings;
    private boolean myShouldUpdatePreview;
    private long myLastDocumentModificationStamp;
    private String myTextToReformat;
    private final UserActivityWatcher myUserActivityWatcher;
    private final Alarm myUpdateAlarm;
    @Nullable
    private CodeStyleSchemesModel myModel;
    private boolean mySomethingChanged;
    private long myEndHighlightPreviewChangesTimeMillis;
    private boolean myShowsPreviewHighlighters;
    private final CodeStyleSettings myCurrentSettings;
    private final Language myDefaultLanguage;
    private Document myDocumentBeforeChanges;
    @Nullable
    private String myLastSearchString;

    protected CodeStyleAbstractPanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(0);
        }
        this(null, null, settings);
    }

    protected CodeStyleAbstractPanel(@Nullable Language defaultLanguage, @Nullable CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(1);
        }
        this.myPreviewRangesToHighlight = new ArrayList<TextRange>();
        this.myUserActivityWatcher = new UserActivityWatcher();
        this.myEndHighlightPreviewChangesTimeMillis = -1L;
        this.myCurrentSettings = currentSettings;
        this.mySettings = settings;
        this.myDefaultLanguage = defaultLanguage;
        this.myEditor = this.createEditor();
        this.myUpdateAlarm = this.myEditor == null ? new Alarm() : new Alarm(this.myEditor.getComponent(), (Disposable)this);
        this.myUserActivityWatcher.addUserActivityListener(() -> this.somethingChanged());
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(ComponentHighlightingListener.TOPIC, this);
        this.updatePreview(true);
    }

    protected void setShouldUpdatePreview(boolean shouldUpdatePreview) {
        this.myShouldUpdatePreview = shouldUpdatePreview;
    }

    private synchronized void setSomethingChanged(boolean b) {
        this.mySomethingChanged = b;
    }

    private synchronized boolean isSomethingChanged() {
        return this.mySomethingChanged;
    }

    public void setModel(@NotNull CodeStyleSchemesModel model2) {
        if (model2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(2);
        }
        this.myModel = model2;
    }

    protected void somethingChanged() {
        if (this.myModel != null) {
            this.myModel.fireBeforeCurrentSettingsChanged();
        }
    }

    protected void addPanelToWatch(Component component2) {
        this.myUserActivityWatcher.register(component2);
    }

    @Nullable
    private EditorEx createEditor() {
        if (StringUtil.isEmpty(this.getPreviewText())) {
            return null;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor2 = (EditorEx)editorFactory.createEditor(editorDocument);
        CodeStyleAbstractPanel.fillEditorSettings(editor2.getSettings());
        this.myLastDocumentModificationStamp = editor2.getDocument().getModificationStamp();
        return editor2;
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
        editorSettings.setSoftMargins(Collections.emptyList());
    }

    protected void updatePreview(boolean useDefaultSample) {
        if (this.myEditor == null) {
            return;
        }
        this.updateEditor(useDefaultSample);
        this.updatePreviewHighlighter(this.myEditor);
    }

    private void updateEditor(boolean useDefaultSample) {
        if (!this.myShouldUpdatePreview || !ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (this.myEditor.isDisposed()) {
            return;
        }
        if (this.myLastDocumentModificationStamp != this.myEditor.getDocument().getModificationStamp()) {
            this.myTextToReformat = this.myEditor.getDocument().getText();
        } else if (useDefaultSample || this.myTextToReformat == null) {
            this.myTextToReformat = StringUtil.convertLineSeparators(ObjectUtils.notNull(this.getPreviewText(), ""));
        }
        this.updateEditorState(true);
    }

    protected void setEditorText(@NotNull String text2, boolean updateHighlighter) {
        if (text2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(3);
        }
        this.myTextToReformat = StringUtil.convertLineSeparators(text2);
        if (updateHighlighter) {
            this.updatePreviewHighlighter(this.myEditor);
        }
        this.updateEditorState(false);
    }

    private void updateEditorState(boolean collectChanges) {
        int currOffs = this.myEditor.getScrollingModel().getVerticalScrollOffset();
        Project project2 = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CommandProcessor.getInstance().executeCommand(project2, () -> this.replaceText(project2, collectChanges), null, null);
        this.myEditor.getSettings().setRightMargin(this.getAdjustedRightMargin());
        this.myLastDocumentModificationStamp = this.myEditor.getDocument().getModificationStamp();
        this.myEditor.getScrollingModel().scrollVertically(currOffs);
    }

    private int getAdjustedRightMargin() {
        int result2 = this.getRightMargin();
        return result2 > 0 ? result2 : CodeStyle.getSettings((Project)ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).getRightMargin(this.getDefaultLanguage());
    }

    protected abstract int getRightMargin();

    private void replaceText(@NotNull Project project2, boolean collectChanges) {
        if (project2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document beforeReformat = null;
                if (collectChanges && this.myEditor.getDocument().getTextLength() > 0) {
                    beforeReformat = this.collectChangesBeforeCurrentSettingsAppliance(project2);
                }
                PsiFile psiFile = this.createFileFromText(project2, this.myTextToReformat);
                this.prepareForReformat(psiFile);
                DocumentEx document = this.myEditor.getDocument();
                AbstractDocumentFormattingService.setDocument((PsiFile)psiFile, (Document)document);
                this.applySettingsToModel();
                Ref formatted = Ref.create();
                CodeStyle.doWithTemporarySettings((Project)project2, (CodeStyleSettings)this.mySettings, settings -> {
                    settings.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
                    this.myEditor.getSettings().setTabSize(settings.getTabSize(this.getFileType()));
                    formatted.set(this.doReformat(project2, psiFile));
                });
                document.replaceString(0, document.getTextLength(), ((PsiFile)formatted.get()).getText());
                DocumentReference docRef = DocumentReferenceManager.getInstance().create(document);
                UndoManager.getInstance(project2).nonundoableActionPerformed(docRef, false);
                if (beforeReformat != null) {
                    this.highlightChanges(beforeReformat);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        });
    }

    protected void applySettingsToModel() {
        if (this.mySettings instanceof CodeStyleSchemesModel.ModelSettings && ((CodeStyleSchemesModel.ModelSettings)this.mySettings).isLocked()) {
            return;
        }
        try {
            if (this.myModel != null && this.myModel.isUiEventsEnabled()) {
                this.apply(this.mySettings);
                this.myModel.fireAfterCurrentSettingsChanged();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Nullable
    private Document collectChangesBeforeCurrentSettingsAppliance(@NotNull Project project2) {
        if (project2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = this.createFileFromText(project2, this.myTextToReformat);
        this.prepareForReformat(psiFile);
        CodeStyle.doWithTemporarySettings((Project)project2, (CodeStyleSettings)this.mySettings, settings -> {
            settings.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
            this.doReformat(project2, psiFile);
        });
        return this.getDocumentBeforeChanges(project2, psiFile);
    }

    private Document getDocumentBeforeChanges(@NotNull Project project2, @NotNull PsiFile file2) {
        Document document;
        PsiDocumentManager documentManager;
        if (project2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(7);
        }
        if ((documentManager = PsiDocumentManager.getInstance(project2)) != null && (document = documentManager.getDocument(file2)) != null) {
            return document;
        }
        if (this.myDocumentBeforeChanges == null) {
            this.myDocumentBeforeChanges = new DocumentImpl(file2.getText());
        } else {
            this.myDocumentBeforeChanges.replaceString(0, this.myDocumentBeforeChanges.getTextLength(), file2.getText());
        }
        return this.myDocumentBeforeChanges;
    }

    private void prepareForReformat(PsiFile psiFile) {
    }

    @NotNull
    protected String getFileExt() {
        String string2 = this.getFileType().getDefaultExtension();
        if (string2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Deprecated(forRemoval=true)
    protected PsiFile createFileFromText(@NotNull Project project2, @NotNull String text2) {
        PsiFile file2;
        LanguageCodeStyleSettingsProvider provider2;
        Language language;
        if (project2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(10);
        }
        if ((language = this.getDefaultLanguage()) != null && (provider2 = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null && (file2 = provider2.createFileFromText(project2, text2)) != null) {
            if (file2.isPhysical()) {
                LOG.error(provider2.getClass() + " creates a physical file with PSI events enabled");
            }
            return file2;
        }
        return PsiFileFactory.getInstance(project2).createFileFromText("a." + this.getFileExt(), this.getFileType(), (CharSequence)text2, LocalTimeCounter.currentTime(), false);
    }

    @NotNull
    protected PsiFile doReformat(Project project2, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(11);
        }
        CodeStyleManager.getInstance(project2).reformat(psiFile);
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(12);
        }
        return psiFile2;
    }

    private void highlightChanges(@NotNull Document beforeReformat) {
        if (beforeReformat == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(13);
        }
        this.myPreviewRangesToHighlight.clear();
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        markupModel.removeAllHighlighters();
        this.myPreviewRangesToHighlight.addAll(ChangesDiffCalculator.calculateDiff(beforeReformat, this.myEditor.getDocument()));
        if (!this.myPreviewRangesToHighlight.isEmpty()) {
            this.myEndHighlightPreviewChangesTimeMillis = System.currentTimeMillis() + TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS;
            this.myShowsPreviewHighlighters = true;
        }
    }

    private static boolean isWithinBounds(@NotNull VisualPosition targetPosition, @NotNull VisualPosition startPosition, VisualPosition endPosition) {
        if (targetPosition == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(14);
        }
        if (startPosition == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(15);
        }
        return targetPosition.line >= startPosition.line && targetPosition.line <= endPosition.line && targetPosition.column >= startPosition.column && targetPosition.column <= endPosition.column;
    }

    private void updatePreviewHighlighter(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(16);
        }
        EditorColorsScheme scheme = editor2.getColorsScheme();
        editor2.getSettings().setCaretRowShown(false);
        EditorHighlighter highlighter = this.createHighlighter(scheme);
        if (highlighter != null) {
            editor2.setHighlighter(highlighter);
        } else {
            LOG.warn("No highlighter for " + this.getDefaultLanguage());
        }
    }

    @Nullable
    protected abstract EditorHighlighter createHighlighter(@NotNull EditorColorsScheme var1);

    @NotNull
    protected abstract FileType getFileType();

    @NonNls
    @Nullable
    protected abstract String getPreviewText();

    public abstract void apply(@NotNull CodeStyleSettings var1) throws ConfigurationException;

    public final void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(17);
        }
        this.myShouldUpdatePreview = false;
        try {
            this.resetImpl(settings);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            this.myShouldUpdatePreview = true;
        }
    }

    public abstract boolean isModified(CodeStyleSettings var1);

    @Nullable
    public abstract JComponent getPanel();

    @Override
    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
    }

    protected abstract void resetImpl(@NotNull CodeStyleSettings var1);

    protected static void fillWrappingCombo(@NotNull JComboBox<CodeStyleSettings.WrapStyle> wrapCombo) {
        if (wrapCombo == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(18);
        }
        PresentableEnumUtil.fill(wrapCombo, CodeStyleSettings.WrapStyle.class);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static String readFromFile(@NotNull Class<?> resourceContainerClass, @NonNls @NotNull String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void installPreviewPanel(@NotNull JPanel previewPanel) {
        if (previewPanel == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(22);
        }
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        previewPanel.setBorder(new AbstractBorder(){
            private static final int LEFT_WHITE_SPACE = 2;

            @Override
            public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
                Editor editor2 = CodeStyleAbstractPanel.this.getEditor();
                if (editor2 instanceof EditorEx) {
                    g.setColor(((EditorEx)editor2).getBackgroundColor());
                    g.fillRect(x + 1, y, 2, height);
                }
                g.setColor(OnePixelDivider.BACKGROUND);
                g.fillRect(x, y, 1, height);
            }

            @Override
            public Insets getBorderInsets(Component c2, Insets insets) {
                insets.set(0, 3, 0, 0);
                return insets;
            }
        });
    }

    public void onSomethingChanged() {
        this.setSomethingChanged(true);
        if (this.myEditor != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.updateEditor(true);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), () -> this.addUpdatePreviewRequest());
            }
        } else {
            this.applySettingsToModel();
        }
    }

    private void addUpdatePreviewRequest() {
        this.myUpdateAlarm.addComponentRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CodeStyleAbstractPanel.this.myUpdateAlarm.cancelAllRequests();
                    Project project2 = CodeStyleAbstractPanel.this.myEditor.getProject();
                    if (CodeStyleAbstractPanel.this.myEditor.isDisposed() || project2 != null && project2.isDisposed()) {
                        return;
                    }
                    if (CodeStyleAbstractPanel.this.isSomethingChanged()) {
                        CodeStyleAbstractPanel.this.updateEditor(false);
                    }
                    if (System.currentTimeMillis() <= CodeStyleAbstractPanel.this.myEndHighlightPreviewChangesTimeMillis && !CodeStyleAbstractPanel.this.myPreviewRangesToHighlight.isEmpty()) {
                        CodeStyleAbstractPanel.this.blinkHighlighters();
                        CodeStyleAbstractPanel.this.myUpdateAlarm.addComponentRequest((Runnable)this, 500);
                    } else {
                        CodeStyleAbstractPanel.this.myEditor.getMarkupModel().removeAllHighlighters();
                    }
                }
                finally {
                    CodeStyleAbstractPanel.this.setSomethingChanged(false);
                }
            }
        }, 300);
    }

    private void blinkHighlighters() {
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        if (this.myShowsPreviewHighlighters) {
            Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
            VisualPosition visualStart = this.myEditor.xyToVisualPosition(visibleArea.getLocation());
            VisualPosition visualEnd = this.myEditor.xyToVisualPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
            int endColumnCandidate = visibleArea.width / EditorUtil.getSpaceWidth((int)0, (Editor)this.myEditor) + visualStart.column;
            if (endColumnCandidate > visualEnd.column) {
                visualEnd = new VisualPosition(visualEnd.line, endColumnCandidate);
            }
            int offsetToScroll = -1;
            CharSequence text2 = this.myEditor.getDocument().getCharsSequence();
            TextAttributes backgroundAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextAttributes borderAttributes = new TextAttributes(null, null, backgroundAttributes.getBackgroundColor(), EffectType.BOXED, 0);
            boolean scrollToChange = true;
            for (TextRange range : this.myPreviewRangesToHighlight) {
                if (scrollToChange) {
                    boolean rangeVisible = CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getStartOffset()), visualStart, visualEnd) || CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getEndOffset()), visualStart, visualEnd);
                    boolean bl = scrollToChange = !rangeVisible;
                    if (offsetToScroll < 0) {
                        if (text2.charAt(range.getStartOffset()) != '\n') {
                            offsetToScroll = range.getStartOffset();
                        } else if (range.getEndOffset() > 0 && text2.charAt(range.getEndOffset() - 1) != '\n') {
                            offsetToScroll = range.getEndOffset() - 1;
                        }
                    }
                }
                TextAttributes attributesToUse = range.getLength() > 0 ? backgroundAttributes : borderAttributes;
                markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 6000, attributesToUse, HighlighterTargetArea.EXACT_RANGE);
            }
            if (scrollToChange) {
                if (offsetToScroll < 0 && !this.myPreviewRangesToHighlight.isEmpty()) {
                    offsetToScroll = this.myPreviewRangesToHighlight.get(0).getStartOffset();
                }
                if (offsetToScroll >= 0 && offsetToScroll < text2.length() - 1 && text2.charAt(offsetToScroll) != '\n') {
                    ++offsetToScroll;
                }
                if (offsetToScroll >= 0 && offsetToScroll < this.myEditor.getDocument().getTextLength()) {
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offsetToScroll), ScrollType.RELATIVE);
                }
            }
        } else {
            markupModel.removeAllHighlighters();
        }
        this.myShowsPreviewHighlighters = !this.myShowsPreviewHighlighters;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(23);
        }
        return codeStyleSettings;
    }

    @NotNull
    public Set<String> processListOptions() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(24);
        }
        return set2;
    }

    @NotNull
    public OptionsContainingConfigurable getOptionIndexer() {
        return new OptionsContainingConfigurable(){

            @NotNull
            public Set<String> processListOptions() {
                Set<String> set2 = CodeStyleAbstractPanel.this.processListOptions();
                if (set2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return set2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleAbstractPanel$3", "processListOptions"));
            }
        };
    }

    final void applyPredefinedSettings(@NotNull PredefinedCodeStyle codeStyle) {
        if (codeStyle == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(25);
        }
        codeStyle.apply(this.mySettings, this.myDefaultLanguage);
        ((CodeStyleSchemesModel.ModelSettings)this.mySettings).doWithLockedSettings(() -> this.resetImpl(this.mySettings));
        if (this.myModel != null) {
            this.myModel.fireAfterCurrentSettingsChanged();
        }
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.myDefaultLanguage;
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string2 = ApplicationBundle.message((String)"settings.code.style.tab.title.other", (Object[])new Object[0]);
        if (string2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(26);
        }
        return string2;
    }

    protected CodeStyleSettings getCurrentSettings() {
        return this.myCurrentSettings;
    }

    @Nullable
    protected CodeStyleSettings getModelSettings() {
        CodeStyleSchemesModel model2 = this.myModel;
        return model2 != null ? model2.getCloneSettings(model2.getSelectedScheme()) : null;
    }

    public void setupCopyFromMenu(@NotNull JPopupMenu copyMenu) {
        if (copyMenu == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(27);
        }
        copyMenu.removeAll();
    }

    public final void highlight(@NotNull JComponent component2, @NotNull String searchString) {
        if (component2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(28);
        }
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(29);
        }
        if (this.isNewSearchString(searchString) && this.isInsideThisPanel(component2)) {
            if (component2 instanceof TabLabel) {
                Container parent2 = component2.getParent();
                if (parent2 instanceof JBTabs) {
                    ((JBTabs)parent2).select(((TabLabel)component2).getInfo(), false);
                }
            } else {
                JTabbedPane tabbedPane;
                int index2;
                JPanel tabPanel = CodeStyleAbstractPanel.findTabbedPaneChild(component2);
                if (tabPanel != null && (index2 = (tabbedPane = (JTabbedPane)tabPanel.getParent()).indexOfComponent(tabPanel)) >= 0) {
                    tabbedPane.setSelectedIndex(index2);
                }
            }
        }
    }

    private boolean isNewSearchString(@NotNull String searchString) {
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(30);
        }
        if (searchString.equals(this.myLastSearchString)) {
            return false;
        }
        this.myLastSearchString = searchString;
        return true;
    }

    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(31);
        }
    }

    @Nullable
    private static JPanel findTabbedPaneChild(@NotNull JComponent component2) {
        if (component2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(32);
        }
        Container parent2 = component2.getParent();
        while (parent2 != null && !(parent2 instanceof NewCodeStyleSettingsPanel)) {
            Container nextParent = parent2.getParent();
            if (nextParent instanceof JTabbedPane && parent2 instanceof JPanel) {
                return (JPanel)parent2;
            }
            parent2 = nextParent;
        }
        return null;
    }

    private boolean isInsideThisPanel(@NotNull JComponent rootComponent) {
        if (rootComponent == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(33);
        }
        JComponent thisPanel = this.getPanel();
        for (Container parent2 = rootComponent.getParent(); parent2 != null && !(parent2 instanceof NewCodeStyleSettingsPanel); parent2 = parent2.getParent()) {
            if (parent2 != thisPanel) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 21, 23, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleAbstractPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeReformat";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPosition";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapCombo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceContainerClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewPanel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyle";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyMenu";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleAbstractPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doReformat";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEditorText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectChangesBeforeCurrentSettingsAppliance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentBeforeChanges";
                break;
            }
            case 8: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doReformat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightChanges";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviewHighlighter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillWrappingCombo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "installPreviewPanel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyPredefinedSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setupCopyFromMenu";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNewSearchString";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findTabbedPaneChild";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInsideThisPanel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 12, 21, 23, 24, 26 -> new IllegalStateException(string2);
        };
    }
}

