/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.application.options.GeneralCodeStyleOptionsProviderEP;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedGlobPatternsPanel;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedScopesPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final ExtensionPointName<GeneralCodeStyleOptionsProviderEP> EP_NAME = new ExtensionPointName("com.intellij.generalCodeStyleOptionsProvider");
    private static final Logger LOG = Logger.getInstance(GeneralCodeStylePanel.class);
    private List<GeneralCodeStyleOptionsProvider> myAdditionalOptions;
    private IntegerField myRightMarginField;
    private ComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private JBCheckBox myCbWrapWhenTypingReachesRightMargin;
    private JCheckBox myEnableFormatterTags;
    private JTextField myFormatterOnTagField;
    private JTextField myFormatterOffTagField;
    private JCheckBox myAcceptRegularExpressionsCheckBox;
    private JBLabel myFormatterOffLabel;
    private JBLabel myFormatterOnLabel;
    private JPanel myMarkerOptionsPanel;
    private JPanel myAdditionalSettingsPanel;
    private JCheckBox myAutodetectIndentsBox;
    private CommaSeparatedIntegersField myVisualGuides;
    private JBLabel myVisualGuidesHint;
    private JBLabel myLineSeparatorHint;
    private JBLabel myVisualGuidesLabel;
    private JBTabbedPane myTabbedPane;
    private ExcludedGlobPatternsPanel myExcludedPatternsPanel;
    private ExcludedScopesPanel myExcludedScopesPanel;
    private JPanel myGeneralTab;
    private JPanel myFormatterTab;
    private JBCheckBox myEnableSecondReformat;
    private final JScrollPane myScrollPane;
    private static int ourSelectedTabIndex = -1;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.myLineSeparatorCombo.addItem((Object)GeneralCodeStylePanel.getSystemDependantString());
        this.myLineSeparatorCombo.addItem((Object)GeneralCodeStylePanel.getUnixString());
        this.myLineSeparatorCombo.addItem((Object)GeneralCodeStylePanel.getWindowsString());
        this.myLineSeparatorCombo.addItem((Object)GeneralCodeStylePanel.getMacintoshString());
        this.addPanelToWatch(this.myPanel);
        this.myRightMarginField.setDefaultValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myEnableFormatterTags.addActionListener(__ -> {
            boolean tagsEnabled = this.myEnableFormatterTags.isSelected();
            this.setFormatterTagControlsEnabled(tagsEnabled);
        });
        this.myAutodetectIndentsBox.setBorder(JBUI.Borders.emptyTop(10));
        this.myPanel.setBorder(JBUI.Borders.empty());
        this.myScrollPane = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScrollPane.setViewport((JViewport)new GradientViewport((Component)this.myPanel, (Insets)JBUI.insetsTop(5), true));
        this.myAdditionalSettingsPanel.setLayout(new VerticalFlowLayout(true, true));
        this.updateGeneralOptionsPanel();
        this.myVisualGuidesLabel.setText(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]) + ":");
        this.myVisualGuidesHint.setForeground((Color)JBColor.GRAY);
        this.myVisualGuidesHint.setFont(UIUtil.getLabelFont(UIUtil.FontSize.SMALL));
        this.myLineSeparatorHint.setForeground((Color)JBColor.GRAY);
        this.myLineSeparatorHint.setFont(UIUtil.getLabelFont(UIUtil.FontSize.SMALL));
        this.myGeneralTab.setBorder(JBUI.Borders.empty(15, 15, 0, 0));
        this.myFormatterTab.setBorder(JBUI.Borders.empty(15, 15, 0, 0));
        this.myMarkerOptionsPanel.setBorder(JBUI.Borders.emptyTop(10));
        this.myEnableSecondReformat.setBorder((Border)JBUI.Borders.emptyTop(10));
        if (ourSelectedTabIndex >= 0) {
            this.myTabbedPane.setSelectedIndex(ourSelectedTabIndex);
        }
        this.myTabbedPane.addChangeListener(__ -> {
            ourSelectedTabIndex = this.myTabbedPane.getSelectedIndex();
        });
        this.myTabbedPane.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (ourSelectedTabIndex > 0 && GeneralCodeStylePanel.this.myTabbedPane.getSelectedIndex() != ourSelectedTabIndex) {
                    GeneralCodeStylePanel.this.myTabbedPane.setSelectedIndex(ourSelectedTabIndex);
                }
            }
        });
        EP_NAME.addExtensionPointListener(new ExtensionPointListener<GeneralCodeStyleOptionsProviderEP>(){

            @Override
            public void extensionAdded(@NotNull GeneralCodeStyleOptionsProviderEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                GeneralCodeStylePanel.this.updateGeneralOptionsPanel();
            }

            @Override
            public void extensionRemoved(@NotNull GeneralCodeStyleOptionsProviderEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                GeneralCodeStylePanel.this.updateGeneralOptionsPanel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/application/options/GeneralCodeStylePanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    private void updateGeneralOptionsPanel() {
        this.myAdditionalSettingsPanel.removeAll();
        this.myAdditionalOptions = ConfigurableWrapper.createConfigurables(EP_NAME);
        for (GeneralCodeStyleOptionsProvider provider2 : this.myAdditionalOptions) {
            JComponent generalSettingsComponent = provider2.createComponent();
            if (generalSettingsComponent == null) continue;
            this.myAdditionalSettingsPanel.add(Box.createRigidArea(JBUI.size(0, 5)));
            this.myAdditionalSettingsPanel.add(generalSettingsComponent);
        }
    }

    @Override
    protected int getRightMargin() {
        return this.myRightMarginField.getValue();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        if (languageFileType == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(1);
        }
        this.myVisualGuides.validateContent();
        this.myRightMarginField.validateContent();
        settings.setDefaultSoftMargins(this.myVisualGuides.getValue());
        this.myExcludedScopesPanel.apply(settings);
        this.myExcludedPatternsPanel.apply(settings);
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.setDefaultRightMargin(this.getRightMargin());
        settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myCbWrapWhenTypingReachesRightMargin.isSelected();
        settings.FORMATTER_TAGS_ENABLED = this.myEnableFormatterTags.isSelected();
        settings.FORMATTER_TAGS_ACCEPT_REGEXP = this.myAcceptRegularExpressionsCheckBox.isSelected();
        settings.FORMATTER_OFF_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG);
        settings.setFormatterOffPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG));
        settings.FORMATTER_ON_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOnTagField, settings.FORMATTER_ON_TAG);
        settings.setFormatterOnPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOnTagField, settings.FORMATTER_ON_TAG));
        settings.AUTODETECT_INDENTS = this.myAutodetectIndentsBox.isSelected();
        settings.ENABLE_SECOND_REFORMAT = this.myEnableSecondReformat.isSelected();
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.apply(settings);
        }
    }

    private void createUIComponents() {
        this.myRightMarginField = new IntegerField(ApplicationBundle.message((String)"editbox.right.margin.columns", (Object[])new Object[0]), 0, 1000);
        this.myVisualGuides = new CommaSeparatedIntegersField(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]), 0, 1000, ApplicationBundle.message((String)"settings.code.style.visual.guides.optional", (Object[])new Object[0]));
        this.myExcludedPatternsPanel = new ExcludedGlobPatternsPanel();
        this.myExcludedPatternsPanel.setBorder(JBUI.Borders.emptyTop(5));
        this.myExcludedScopesPanel = new ExcludedScopesPanel();
    }

    @Nullable
    private static Pattern compilePattern(CodeStyleSettings settings, JTextField field, String patternText) {
        try {
            return Pattern.compile(patternText);
        }
        catch (PatternSyntaxException pse) {
            settings.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            GeneralCodeStylePanel.showError(field, ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.invalid.regexp", (Object[])new Object[0]));
            return null;
        }
    }

    private static String getTagText(JTextField field, String defaultValue) {
        String fieldText = field.getText();
        if (StringUtil.isEmpty(field.getText())) {
            return defaultValue;
        }
        return fieldText;
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (GeneralCodeStylePanel.getUnixString().equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (GeneralCodeStylePanel.getMacintoshString().equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (GeneralCodeStylePanel.getWindowsString().equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!this.myVisualGuides.getValue().equals(settings.getDefaultSoftMargins())) {
            return true;
        }
        if (this.myExcludedScopesPanel.isModified(settings)) {
            return true;
        }
        if (this.myExcludedPatternsPanel.isModified(settings)) {
            return true;
        }
        if (!Objects.equals(this.getSelectedLineSeparator(), settings.LINE_SEPARATOR)) {
            return true;
        }
        if (settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ^ this.myCbWrapWhenTypingReachesRightMargin.isSelected()) {
            return true;
        }
        if (this.getRightMargin() != settings.getDefaultRightMargin()) {
            return true;
        }
        if (this.myEnableFormatterTags.isSelected() ? !settings.FORMATTER_TAGS_ENABLED || settings.FORMATTER_TAGS_ACCEPT_REGEXP != this.myAcceptRegularExpressionsCheckBox.isSelected() || !StringUtil.equals(this.myFormatterOffTagField.getText(), settings.FORMATTER_OFF_TAG) || !StringUtil.equals(this.myFormatterOnTagField.getText(), settings.FORMATTER_ON_TAG) : settings.FORMATTER_TAGS_ENABLED) {
            return true;
        }
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            if (!option.isModified(settings)) continue;
            return true;
        }
        return settings.AUTODETECT_INDENTS != this.myAutodetectIndentsBox.isSelected() || settings.ENABLE_SECOND_REFORMAT != this.myEnableSecondReformat.isSelected();
    }

    @Override
    public JComponent getPanel() {
        return this.myScrollPane;
    }

    @Override
    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(2);
        }
        this.myVisualGuides.setValue(settings.getDefaultSoftMargins());
        this.myExcludedScopesPanel.reset(settings);
        this.myExcludedPatternsPanel.reset(settings);
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem((Object)GeneralCodeStylePanel.getUnixString());
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem((Object)GeneralCodeStylePanel.getWindowsString());
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem((Object)GeneralCodeStylePanel.getMacintoshString());
        } else {
            this.myLineSeparatorCombo.setSelectedItem((Object)GeneralCodeStylePanel.getSystemDependantString());
        }
        this.myRightMarginField.setValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myCbWrapWhenTypingReachesRightMargin.setSelected(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myAcceptRegularExpressionsCheckBox.setSelected(settings.FORMATTER_TAGS_ACCEPT_REGEXP);
        this.myEnableFormatterTags.setSelected(settings.FORMATTER_TAGS_ENABLED);
        this.myFormatterOnTagField.setText(settings.FORMATTER_ON_TAG);
        this.myFormatterOffTagField.setText(settings.FORMATTER_OFF_TAG);
        this.setFormatterTagControlsEnabled(settings.FORMATTER_TAGS_ENABLED);
        this.myAutodetectIndentsBox.setSelected(settings.AUTODETECT_INDENTS);
        this.myEnableSecondReformat.setSelected(settings.ENABLE_SECOND_REFORMAT);
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.reset(settings);
        }
    }

    private void setFormatterTagControlsEnabled(boolean isEnabled) {
        this.myFormatterOffTagField.setEnabled(isEnabled);
        this.myFormatterOnTagField.setEnabled(isEnabled);
        this.myAcceptRegularExpressionsCheckBox.setEnabled(isEnabled);
        this.myFormatterOffLabel.setEnabled(isEnabled);
        this.myFormatterOnLabel.setEnabled(isEnabled);
        this.myMarkerOptionsPanel.setEnabled(isEnabled);
    }

    @Override
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(3);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
    }

    @Override
    public Language getDefaultLanguage() {
        return null;
    }

    private static void showError(JTextField field, @NlsContexts.PopupContent String message) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null);
        balloonBuilder.setFadeoutTime(1500L);
        Balloon balloon = balloonBuilder.createBalloon();
        Rectangle rect2 = field.getBounds();
        Point p = new Point(0, rect2.height);
        RelativePoint point = new RelativePoint(field, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register(ApplicationManager.getApplication(), (Disposable)balloon);
    }

    @Override
    public void setModel(@NotNull CodeStyleSchemesModel model2) {
        if (model2 == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(4);
        }
        super.setModel(model2);
        this.myExcludedScopesPanel.setSchemesModel(model2);
    }

    @Override
    public void dispose() {
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.disposeUIResources();
        }
        super.dispose();
    }

    @NlsContexts.ListItem
    private static String getSystemDependantString() {
        return ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    }

    @NlsContexts.ListItem
    private static String getUnixString() {
        return ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    }

    @NlsContexts.ListItem
    private static String getWindowsString() {
        return ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    }

    @NlsContexts.ListItem
    private static String getMacintoshString() {
        return ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    }

    public static void selectFormatterTab(@NotNull Settings settings) {
        if (settings == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(5);
        }
        ourSelectedTabIndex = 1;
        settings.select(settings.find("preferences.sourceCode"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JBLabel jBLabel;
        JTextField jTextField2;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel5;
        ComboBox comboBox;
        JPanel jPanel4;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel5.add((Component)jBTabbedPane, "Center");
        this.myGeneralTab = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.tab.title"), null, jPanel4, null);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("combobox.line.separator.for.new.files"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLineSeparatorCombo = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myLineSeparatorHint = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("combobox.lineseparator.for.new.files.hint"));
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("editbox.right.margin.columns"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        IntegerField integerField = this.myRightMarginField;
        jPanel4.add((Component)integerField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCbWrapWhenTypingReachesRightMargin = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setHideActionText(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("wrapping.wrap.on.typing"));
        jPanel4.add((Component)jBCheckBox2, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        CommaSeparatedIntegersField commaSeparatedIntegersField = this.myVisualGuides;
        jPanel4.add((Component)commaSeparatedIntegersField, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myVisualGuidesLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.visual.guides"));
        jPanel4.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVisualGuidesHint = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.visual.guides.hint"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(4, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("margin.columns"));
        jPanel4.add((Component)jBLabel6, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("margin.columns"));
        jPanel4.add((Component)jBLabel7, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, new Dimension(0, 17), null));
        this.myAutodetectIndentsBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.autodetect.indents"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFormatterTab = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.formatter.control.tab.title"), null, jPanel2, null);
        this.myMarkerOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFormatterOffLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.formatter.off.tag"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myFormatterOffTagField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFormatterOnLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.formatter.on.tag"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myFormatterOnTagField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAcceptRegularExpressionsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.formatter.marker.regexp"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        this.myEnableFormatterTags = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("settings.code.style.general.enable.formatter.tags"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ExcludedScopesPanel excludedScopesPanel = this.myExcludedScopesPanel;
        jPanel2.add((Component)excludedScopesPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        ExcludedGlobPatternsPanel excludedGlobPatternsPanel = this.myExcludedPatternsPanel;
        jPanel2.add((Component)excludedGlobPatternsPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEnableSecondReformat = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", GeneralCodeStylePanel.class).getString("reformat.again.to.remove.custom.line.breaks"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/GeneralCodeStylePanel";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/GeneralCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectFormatterTab";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

