/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModelListener;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleMainPanel
extends JPanel
implements TabbedLanguageCodeStylePanel.TabChangeListener {
    private final CardLayout myLayout = new CardLayout();
    private final JPanel mySettingsPanel = new JPanel(this.myLayout);
    private final Map<String, NewCodeStyleSettingsPanel> mySettingsPanels = new HashMap<String, NewCodeStyleSettingsPanel>();
    private Future<?> myAlarm = CompletableFuture.completedFuture(null);
    private final CodeStyleSchemesModel myModel;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesPanel mySchemesPanel;
    private boolean myIsDisposed;
    private final Action mySetFromAction = new AbstractAction(CodeInsightBundle.message("settings.code.style.set.from", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent event) {
            CodeStyleAbstractPanel selectedPanel = CodeStyleMainPanel.this.ensureCurrentPanel().getSelectedPanel();
            if (selectedPanel instanceof TabbedLanguageCodeStylePanel) {
                ((TabbedLanguageCodeStylePanel)selectedPanel).showSetFrom((Component)event.getSource());
            }
        }
    };
    @NonNls
    private static final String WAIT_CARD = "CodeStyleSchemesConfigurable.$$$.Wait.placeholder.$$$";
    private final PropertiesComponent myProperties;
    private static final String SELECTED_TAB = "settings.code.style.selected.tab";

    public CodeStyleMainPanel(CodeStyleSchemesModel model2, CodeStyleSettingsPanelFactory factory2, boolean schemesPanelEnabled) {
        super(new BorderLayout());
        this.myModel = model2;
        this.myFactory = factory2;
        this.mySchemesPanel = new CodeStyleSchemesPanel(model2){

            protected JComponent createTopComponent() {
                return CodeStyleMainPanel.this.createLinkComponent();
            }
        };
        this.myProperties = PropertiesComponent.getInstance();
        model2.addListener(new CodeStyleSchemesModelListener(){

            @Override
            public void currentSchemeChanged(Object source) {
                if (source != CodeStyleMainPanel.this.mySchemesPanel) {
                    CodeStyleMainPanel.this.mySchemesPanel.onSelectedSchemeChanged();
                }
                CodeStyleMainPanel.this.onCurrentSchemeChanged();
            }

            @Override
            public void schemeListChanged() {
                CodeStyleMainPanel.this.mySettingsPanels.keySet().removeIf(name -> !CodeStyleMainPanel.this.myModel.containsScheme((String)name, false) && !CodeStyleMainPanel.this.myModel.containsScheme((String)name, true));
                CodeStyleMainPanel.this.mySchemesPanel.resetSchemesCombo();
            }

            @Override
            public void beforeCurrentSettingsChanged() {
                if (!CodeStyleMainPanel.this.myIsDisposed) {
                    CodeStyleMainPanel.this.ensureCurrentPanel().onSomethingChanged();
                }
            }

            @Override
            public void afterCurrentSettingsChanged() {
                CodeStyleMainPanel.this.mySchemesPanel.updateOnCurrentSettingsChange();
                DataContext context2 = DataManager.getInstance().getDataContext((Component)CodeStyleMainPanel.this.mySettingsPanel);
                Settings settings = (Settings)Settings.KEY.getData(context2);
                if (settings != null) {
                    settings.revalidate();
                }
            }

            @Override
            public void schemeChanged(CodeStyleScheme scheme) {
                CodeStyleMainPanel.this.ensurePanel(scheme).reset(scheme.getCodeStyleSettings());
            }

            @Override
            public void settingsChanged(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    3.$$$reportNull$$$0(0);
                }
                CodeStyleMainPanel.this.ensureCurrentPanel().reset(settings);
            }

            @Override
            public void overridingStatusChanged() {
                ApplicationManager.getApplication().invokeLater(() -> CodeStyleMainPanel.this.mySchemesPanel.updateOverridingMessage(), ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/CodeStyleMainPanel$3", "settingsChanged"));
            }
        });
        this.addWaitCard();
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        if (schemesPanelEnabled) {
            top.add((Component)((Object)this.mySchemesPanel));
        }
        top.setBorder(JBUI.Borders.empty(5, 10, 0, 10));
        this.add((Component)top, "North");
        this.add((Component)this.mySettingsPanel, "Center");
        this.mySchemesPanel.resetSchemesCombo();
        this.mySchemesPanel.onSelectedSchemeChanged();
        this.onCurrentSchemeChanged();
    }

    @NotNull
    private JComponent createLinkComponent() {
        ActionLink link = new ActionLink(this.mySetFromAction);
        link.setVerticalAlignment(3);
        Box linkBox = new Box(1);
        linkBox.add(Box.createVerticalGlue());
        linkBox.add((Component)link);
        Box row = new Box(0);
        row.add(Box.createRigidArea(new JBDimension(0, 12)));
        row.add(Box.createHorizontalGlue());
        row.add(linkBox);
        Box box2 = row;
        if (box2 == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        return box2;
    }

    private void addWaitCard() {
        JPanel waitPanel = new JPanel(new BorderLayout());
        JLabel label2 = new JLabel(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        label2.setHorizontalAlignment(0);
        waitPanel.add((Component)label2, "Center");
        label2.setCursor(Cursor.getPredefinedCursor(3));
        waitPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.mySettingsPanel.add(WAIT_CARD, waitPanel);
    }

    private void onCurrentSchemeChanged() {
        this.myLayout.show(this.mySettingsPanel, WAIT_CARD);
        Runnable replaceLayout = () -> {
            if (!this.myIsDisposed) {
                this.ensureCurrentPanel().onSomethingChanged();
                String schemeName = this.myModel.getSelectedScheme().getName();
                this.updateSetFrom();
                this.myLayout.show(this.mySettingsPanel, schemeName);
            }
        };
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            replaceLayout.run();
        } else {
            this.myAlarm.cancel(false);
            this.myAlarm = EdtExecutorService.getScheduledExecutorInstance().schedule(replaceLayout, 200L, TimeUnit.MILLISECONDS);
        }
    }

    private void updateSetFrom() {
        this.mySetFromAction.setEnabled(this.ensureCurrentPanel().getSelectedPanel() instanceof TabbedLanguageCodeStylePanel);
    }

    public NewCodeStyleSettingsPanel[] getPanels() {
        Collection<NewCodeStyleSettingsPanel> panels = this.mySettingsPanels.values();
        return panels.toArray(new NewCodeStyleSettingsPanel[0]);
    }

    public boolean isModified() {
        NewCodeStyleSettingsPanel[] panels;
        for (NewCodeStyleSettingsPanel panel2 : panels = this.getPanels()) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.clearPanels();
        this.onCurrentSchemeChanged();
    }

    private void clearPanels() {
        for (NewCodeStyleSettingsPanel panel2 : this.mySettingsPanels.values()) {
            panel2.dispose();
        }
        this.mySettingsPanels.clear();
    }

    public void apply() throws ConfigurationException {
        for (NewCodeStyleSettingsPanel panel2 : this.getPanels()) {
            if (!panel2.isModified()) continue;
            panel2.apply();
        }
    }

    @NonNls
    @Nullable
    public String getHelpTopic() {
        NewCodeStyleSettingsPanel selectedPanel = this.ensureCurrentPanel();
        return selectedPanel != null ? selectedPanel.getHelpTopic() : "reference.settingsdialog.IDE.globalcodestyle";
    }

    private NewCodeStyleSettingsPanel ensureCurrentPanel() {
        return this.ensurePanel(this.myModel.getSelectedScheme());
    }

    public void showTabOnCurrentPanel(String tab) {
        NewCodeStyleSettingsPanel selectedPanel = this.ensureCurrentPanel();
        CodeStyleAbstractPanel settingsPanel = selectedPanel.getSelectedPanel();
        if (settingsPanel instanceof TabbedLanguageCodeStylePanel) {
            TabbedLanguageCodeStylePanel tabbedPanel = (TabbedLanguageCodeStylePanel)settingsPanel;
            tabbedPanel.changeTab(tab);
        }
    }

    private NewCodeStyleSettingsPanel ensurePanel(CodeStyleScheme scheme) {
        String name = scheme.getName();
        if (!this.mySettingsPanels.containsKey(name)) {
            NewCodeStyleSettingsPanel panel2 = this.myFactory.createPanel(scheme);
            panel2.reset(this.myModel.getCloneSettings(scheme));
            panel2.setModel(this.myModel);
            CodeStyleAbstractPanel settingsPanel = panel2.getSelectedPanel();
            if (settingsPanel instanceof TabbedLanguageCodeStylePanel) {
                TabbedLanguageCodeStylePanel tabbedPanel = (TabbedLanguageCodeStylePanel)settingsPanel;
                tabbedPanel.setListener(this);
                String currentTab = this.myProperties.getValue(CodeStyleMainPanel.getSelectedTabPropertyName(tabbedPanel));
                if (currentTab != null) {
                    tabbedPanel.changeTab(currentTab);
                }
            }
            this.mySchemesPanel.setSeparatorVisible(false);
            this.mySettingsPanels.put(name, panel2);
            this.mySettingsPanel.add(scheme.getName(), panel2);
        }
        return this.mySettingsPanels.get(name);
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.myModel.getSelectedScheme().getName();
    }

    public void disposeUIResources() {
        this.myAlarm.cancel(false);
        this.clearPanels();
        this.myIsDisposed = true;
    }

    public boolean isModified(CodeStyleScheme scheme) {
        if (!this.mySettingsPanels.containsKey(scheme.getName())) {
            return false;
        }
        return this.mySettingsPanels.get(scheme.getName()).isModified();
    }

    @NotNull
    public OptionsContainingConfigurable getOptionIndexer() {
        CodeStyleScheme defaultScheme = CodeStyleSchemes.getInstance().getDefaultScheme();
        NewCodeStyleSettingsPanel panel2 = this.ensurePanel(defaultScheme);
        OptionsContainingConfigurable optionsContainingConfigurable = panel2.getOptionIndexer();
        if (optionsContainingConfigurable == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        return optionsContainingConfigurable;
    }

    @Override
    public void tabChanged(@NotNull TabbedLanguageCodeStylePanel source, @NotNull String tabTitle) {
        if (source == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        if (tabTitle == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(3);
        }
        this.myProperties.setValue(CodeStyleMainPanel.getSelectedTabPropertyName(source), tabTitle);
        for (NewCodeStyleSettingsPanel panel2 : this.getPanels()) {
            panel2.tabChanged(source, tabTitle);
        }
    }

    @NotNull
    private static String getSelectedTabPropertyName(@NotNull TabbedLanguageCodeStylePanel panel2) {
        Language language;
        if (panel2 == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(4);
        }
        return (language = panel2.getDefaultLanguage()) != null ? "settings.code.style.selected.tab." + language.getID() : SELECTED_TAB;
    }

    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            CodeStyleMainPanel.$$$reportNull$$$0(5);
        }
        this.ensureCurrentPanel().highlightOptions(searchString);
    }

    public void setSchemesPanelVisible(boolean isVisible) {
        this.mySchemesPanel.setVisible(isVisible);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleMainPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIndexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tabChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTabPropertyName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

