/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomizableLanguageCodeStylePanel
extends CodeStyleAbstractPanel
implements CodeStyleSettingsCustomizable {
    private static final Logger LOG = Logger.getInstance(CustomizableLanguageCodeStylePanel.class);

    protected CustomizableLanguageCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
    }

    protected void init() {
        this.customizeSettings();
    }

    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage(this.getDefaultLanguage());
        if (provider2 != null) {
            provider2.customizeSettings(this, this.getSettingsType());
        }
    }

    public abstract LanguageCodeStyleSettingsProvider.SettingsType getSettingsType();

    protected void resetDefaultNames() {
    }

    @Override
    protected String getPreviewText() {
        if (this.getDefaultLanguage() == null) {
            return "";
        }
        String sample2 = LanguageCodeStyleSettingsProvider.getCodeSample(this.getDefaultLanguage(), this.getSettingsType());
        if (sample2 == null) {
            return "";
        }
        return sample2;
    }

    @Override
    protected int getRightMargin() {
        if (this.getDefaultLanguage() == null) {
            return -1;
        }
        return LanguageCodeStyleSettingsProvider.getRightMargin(this.getDefaultLanguage(), this.getSettingsType());
    }

    @Override
    @NotNull
    protected String getFileExt() {
        String fileExt = LanguageCodeStyleSettingsProvider.getFileExt(this.getDefaultLanguage());
        if (fileExt != null) {
            String string2 = fileExt;
            if (string2 == null) {
                CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = super.getFileExt();
        if (string3 == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(1);
        }
        return string3;
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType assocType;
        if (this.getDefaultLanguage() != null && (assocType = this.getDefaultLanguage().getAssociatedFileType()) != null) {
            LanguageFileType languageFileType = assocType;
            if (languageFileType == null) {
                CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(2);
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(3);
        }
        return languageFileType;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(4);
        }
        FileType fileType = this.getFileType();
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), fileType, null, scheme);
    }

    @Override
    @NotNull
    protected PsiFile doReformat(Project project2, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(5);
        }
        String text2 = psiFile.getText();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(project2);
        Document doc = manager.getDocument(psiFile);
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (doc != null) {
                doc.replaceString(0, doc.getTextLength(), text2);
                manager.commitDocument(doc);
            }
            try {
                super.doReformat(project2, psiFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }), "", "");
        if (doc != null) {
            manager.commitDocument(doc);
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(6);
        }
        return psiFile2;
    }

    protected static JPanel createPreviewPanel() {
        return new JPanel(new BorderLayout());
    }

    @Override
    public void moveStandardOption(@NonNls @NotNull String fieldName, @Nls @NotNull String newGroup) {
        if (fieldName == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(7);
        }
        if (newGroup == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    protected <T extends OrderedOption> List<T> sortOptions(Collection<? extends T> options2) {
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(options2, option -> option.getOptionName()));
        ArrayList<OrderedOption> order = new ArrayList<OrderedOption>(options2.size());
        MultiMap<String, OrderedOption> afters = new MultiMap<String, OrderedOption>();
        MultiMap<String, OrderedOption> befores = new MultiMap<String, OrderedOption>();
        for (OrderedOption each : options2) {
            String anchorOptionName = each.getAnchorOptionName();
            if (anchorOptionName != null && names.contains(anchorOptionName)) {
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.AFTER) {
                    afters.putValue(anchorOptionName, each);
                    continue;
                }
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.BEFORE) {
                    befores.putValue(anchorOptionName, each);
                    continue;
                }
            }
            order.add(each);
        }
        ArrayList<Object> result2 = new ArrayList<Object>(options2.size());
        for (OrderedOption each : order) {
            result2.addAll(befores.get(each.getOptionName()));
            result2.add(each);
            result2.addAll(afters.get(each.getOptionName()));
        }
        assert (result2.size() == options2.size());
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doReformat";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doReformat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveStandardOption";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 4, 5, 7, 8 -> new IllegalArgumentException(string2);
        };
    }

    protected static abstract class OrderedOption {
        @NotNull
        private final String optionName;
        @Nullable
        private final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        private final String anchorOptionName;

        protected OrderedOption(@NotNull String optionName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorOptionName) {
            if (optionName == null) {
                OrderedOption.$$$reportNull$$$0(0);
            }
            this.optionName = optionName;
            this.anchor = anchor;
            this.anchorOptionName = anchorOptionName;
        }

        @NotNull
        public String getOptionName() {
            String string2 = this.optionName;
            if (string2 == null) {
                OrderedOption.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Nullable
        public CodeStyleSettingsCustomizable.OptionAnchor getAnchor() {
            return this.anchor;
        }

        @Nullable
        public String getAnchorOptionName() {
            return this.anchorOptionName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel$OrderedOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel$OrderedOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

