/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementUiUtil;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MultiRowFlowPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRuleEditor
extends JPanel
implements ArrangementUiComponent.Listener {
    @NotNull
    private final Map<ArrangementSettingsToken, ArrangementUiComponent> myComponents;
    @NotNull
    private final List<MultiRowFlowPanel> myRows;
    @NotNull
    private final ArrangementMatchingRulesControl myControl;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    private int myRow;
    private int myLabelWidth;
    @Nullable
    private JComponent myDefaultFocusRequestor;
    @Nullable
    private JComponent myFocusRequestor;
    private boolean mySkipStateChange;

    public ArrangementMatchingRuleEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl control) {
        if (settingsManager == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(1);
        }
        if (control == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(2);
        }
        this(settingsManager, settingsManager.getSupportedMatchingTokens(), colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @Nullable List<? extends CompositeArrangementSettingsToken> tokens, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl control) {
        if (settingsManager == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(3);
        }
        if (colorsProvider == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(4);
        }
        if (control == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(5);
        }
        this.myComponents = new HashMap<ArrangementSettingsToken, ArrangementUiComponent>();
        this.myRows = new ArrayList<MultiRowFlowPanel>();
        this.myRow = -1;
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
        this.myControl = control;
        this.init(tokens);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ArrangementMatchingRuleEditor.this.onMouseClicked(e);
            }
        });
    }

    private void init(@Nullable List<? extends CompositeArrangementSettingsToken> tokens) {
        this.setLayout(new GridBagLayout());
        this.setBorder(JBUI.Borders.empty(5));
        if (tokens != null) {
            for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : tokens) {
                this.addToken(compositeArrangementSettingsToken);
            }
        }
        this.applyBackground(UIUtil.getListBackground());
    }

    private void addToken(@NotNull CompositeArrangementSettingsToken rowToken) {
        ArrangementUiComponent component2;
        if (rowToken == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(6);
        }
        List tokens = ArrangementUtil.flatten((CompositeArrangementSettingsToken)rowToken);
        GridBag labelConstraints = new GridBag().anchor(18).insets(4, 0, 0, 0);
        MultiRowFlowPanel panel2 = new MultiRowFlowPanel(0, 5, 3);
        ArrayList<ArrangementSettingsToken> prevTokens = new ArrayList<ArrangementSettingsToken>();
        StdArrangementTokenUiRole prevRole = null;
        block4: for (CompositeArrangementSettingsToken token : tokens) {
            StdArrangementTokenUiRole role = token.getRole();
            if (role != prevRole && !prevTokens.isEmpty()) {
                component2 = ArrangementUiUtil.buildUiComponent(role, prevTokens, this.myColorsProvider, this.mySettingsManager);
                component2.setListener(this);
                for (ArrangementSettingsToken prevToken : prevTokens) {
                    this.myComponents.put(prevToken, component2);
                }
                panel2.add(component2.getUiComponent());
                panel2 = this.addRowIfNecessary(panel2);
                prevRole = null;
                prevTokens.clear();
            }
            component2 = ArrangementUiUtil.buildUiComponent(role, Collections.singletonList(token.getToken()), this.myColorsProvider, this.mySettingsManager);
            component2.setListener(this);
            JComponent uiComponent = component2.getUiComponent();
            switch (role) {
                case LABEL: {
                    panel2 = this.addRowIfNecessary(panel2);
                    this.add((Component)uiComponent, labelConstraints);
                    this.myLabelWidth = Math.max(this.myLabelWidth, uiComponent.getPreferredSize().width);
                    prevRole = null;
                    break;
                }
                case TEXT_FIELD: {
                    panel2 = this.addRowIfNecessary(panel2);
                    ArrangementUiComponent textLabel = ArrangementUiUtil.buildUiComponent(StdArrangementTokenUiRole.LABEL, Collections.singletonList(token.getToken()), this.myColorsProvider, this.mySettingsManager);
                    JComponent textLabelComponent = textLabel.getUiComponent();
                    this.add((Component)textLabelComponent, labelConstraints);
                    this.myLabelWidth = Math.max(this.myLabelWidth, textLabelComponent.getPreferredSize().width);
                    panel2.add(uiComponent);
                    panel2 = this.addRowIfNecessary(panel2);
                    prevRole = null;
                    this.myComponents.put(token.getToken(), component2);
                    if (this.myDefaultFocusRequestor != null) continue block4;
                    this.myDefaultFocusRequestor = uiComponent;
                    break;
                }
                default: {
                    if (role == StdArrangementTokenUiRole.COMBO_BOX) {
                        prevTokens.add(token.getToken());
                        prevRole = role;
                        break;
                    }
                    panel2.add(uiComponent);
                    this.myComponents.put(token.getToken(), component2);
                }
            }
        }
        if (prevRole != null && !prevTokens.isEmpty()) {
            component2 = ArrangementUiUtil.buildUiComponent(prevRole, prevTokens, this.myColorsProvider, this.mySettingsManager);
            panel2.add(component2.getUiComponent());
            component2.setListener(this);
            for (ArrangementSettingsToken prevToken : prevTokens) {
                this.myComponents.put(prevToken, component2);
            }
        }
        this.addRowIfNecessary(panel2);
    }

    @NotNull
    private MultiRowFlowPanel addRowIfNecessary(@NotNull MultiRowFlowPanel panel2) {
        if (panel2 == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(7);
        }
        if (panel2.getComponentCount() <= 0) {
            MultiRowFlowPanel multiRowFlowPanel = panel2;
            if (multiRowFlowPanel == null) {
                ArrangementMatchingRuleEditor.$$$reportNull$$$0(8);
            }
            return multiRowFlowPanel;
        }
        this.add((Component)panel2, new GridBag().anchor(17).weightx(1.0).fillCellHorizontally().coverLine());
        this.myRows.add(panel2);
        return new MultiRowFlowPanel(0, 5, 3);
    }

    @Override
    public void stateChanged() {
        if (!this.mySkipStateChange) {
            this.apply();
        }
    }

    @Nullable
    private Pair<ArrangementMatchCondition, ArrangementSettingsToken> buildCondition() {
        ArrayList<ArrangementMatchCondition> conditions = new ArrayList<ArrangementMatchCondition>();
        ArrangementSettingsToken orderType = null;
        for (ArrangementUiComponent component2 : this.myComponents.values()) {
            if (!component2.isEnabled() || !component2.isSelected()) continue;
            ArrangementSettingsToken token = component2.getToken();
            if (token != null && StdArrangementTokenType.ORDER.is(token)) {
                orderType = token;
                continue;
            }
            conditions.add(component2.getMatchCondition());
        }
        if (!conditions.isEmpty()) {
            if (orderType == null) {
                orderType = StdArrangementTokens.Order.KEEP;
            }
            return Pair.create(ArrangementUtil.combine((ArrangementMatchCondition[])conditions.toArray(new ArrangementMatchCondition[0])), orderType);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myFocusRequestor != null) {
            if (this.myFocusRequestor.isFocusOwner()) {
                this.myFocusRequestor = null;
            } else {
                this.myFocusRequestor.requestFocusInWindow();
            }
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int row) {
        Map conditionTokens;
        ArrangementMatchCondition condition;
        ArrangementSettingsToken orderType;
        this.myRow = row;
        this.myFocusRequestor = this.myDefaultFocusRequestor;
        this.mySkipStateChange = true;
        try {
            for (ArrangementUiComponent component2 : this.myComponents.values()) {
                component2.reset();
            }
        }
        finally {
            this.mySkipStateChange = false;
        }
        ArrangementMatchingRulesModel model2 = this.myControl.getModel();
        if (row < 0 || row >= model2.getSize()) {
            this.myRow = -1;
            return;
        }
        Object element = model2.getElementAt(row);
        ArrangementSettingsToken arrangementSettingsToken = orderType = element instanceof ArrangementMatchRule ? ((ArrangementMatchRule)element).getOrderType() : null;
        if (element instanceof EmptyArrangementRuleComponent) {
            condition = null;
            conditionTokens = new HashMap();
        } else {
            if (!(element instanceof StdArrangementMatchRule)) {
                return;
            }
            condition = ((StdArrangementMatchRule)element).getMatcher().getCondition();
            conditionTokens = ArrangementUtil.extractTokens((ArrangementMatchCondition)condition);
        }
        this.mySkipStateChange = true;
        try {
            for (ArrangementUiComponent component3 : this.myComponents.values()) {
                Object value;
                ArrangementSettingsToken token = component3.getToken();
                if (token == null || !component3.getAvailableTokens().contains(orderType) && !this.isEnabled(condition, token)) continue;
                component3.setEnabled(true);
                if (component3.getAvailableTokens().contains(orderType)) {
                    component3.chooseToken(orderType);
                } else {
                    component3.setSelected(conditionTokens.containsKey(token));
                }
                if ((value = conditionTokens.get(token)) == null) continue;
                component3.setData(value);
            }
            this.refreshConditions();
        }
        finally {
            this.mySkipStateChange = false;
        }
    }

    private void refreshConditions() {
        Pair<ArrangementMatchCondition, ArrangementSettingsToken> pair = this.buildCondition();
        ArrangementMatchCondition condition = Pair.getFirst(pair);
        for (ArrangementUiComponent component2 : this.myComponents.values()) {
            ArrangementSettingsToken token = component2.getToken();
            if (token == null) continue;
            boolean enabled = this.isEnabled(condition, token);
            component2.setEnabled(enabled);
            if (enabled) continue;
            component2.setSelected(false);
        }
    }

    private boolean isEnabled(@Nullable ArrangementMatchCondition condition, @NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(9);
        }
        return ArrangementSectionRuleManager.isEnabled(token) || this.mySettingsManager.isEnabled(token, condition);
    }

    private void apply() {
        Pair<ArrangementMatchCondition, ArrangementSettingsToken> pair = this.buildCondition();
        EmptyArrangementRuleComponent modelValue2 = pair == null ? new EmptyArrangementRuleComponent(this.myControl.getRowHeight(this.myRow)) : new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)pair.first), (ArrangementSettingsToken)pair.second);
        this.myControl.getModel().set(this.myRow, modelValue2);
        this.myControl.repaintRows(this.myRow, this.myRow, true);
    }

    public void applyAvailableWidth(int width) {
        for (MultiRowFlowPanel row : this.myRows) {
            row.setForcedWidth(width - this.myLabelWidth);
        }
        this.validate();
    }

    private void applyBackground(@NotNull Color color) {
        if (color == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(10);
        }
        this.setBackground(color);
        for (JComponent jComponent : this.myRows) {
            jComponent.setBackground(color);
        }
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        if (e == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(11);
        }
        if (this.myRow < 0) {
            return;
        }
        Point locationOnScreen = e.getLocationOnScreen();
        for (ArrangementUiComponent component2 : this.myComponents.values()) {
            Rectangle screenBounds = component2.getScreenBounds();
            if (screenBounds == null || !screenBounds.contains(locationOnScreen)) continue;
            if (component2.isEnabled()) {
                if (component2.isSelected()) {
                    Set<ArrangementSettingsToken> mutexes = ArrangementSectionRuleManager.getSectionMutexes();
                    if (!mutexes.contains(component2.getToken())) {
                        component2.handleMouseClickOnSelected();
                        this.refreshConditions();
                    }
                } else {
                    this.addCondition(component2);
                }
            }
            this.apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCondition(@NotNull ArrangementUiComponent component2) {
        if (component2 == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(12);
        }
        this.mySkipStateChange = true;
        try {
            component2.setSelected(true);
            Collection<Set<ArrangementSettingsToken>> mutexes = this.mySettingsManager.getMutexes();
            for (Set<ArrangementSettingsToken> mutex : mutexes) {
                this.updateMutexConditions(component2, mutex);
            }
            this.updateMutexConditions(component2, ArrangementSectionRuleManager.getSectionMutexes());
            this.refreshConditions();
        }
        finally {
            this.mySkipStateChange = false;
        }
    }

    private void updateMutexConditions(@NotNull ArrangementUiComponent component2, @NotNull Set<? extends ArrangementSettingsToken> mutex) {
        if (component2 == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(13);
        }
        if (mutex == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(14);
        }
        if (!mutex.contains(component2.getToken())) {
            return;
        }
        for (ArrangementSettingsToken arrangementSettingsToken : mutex) {
            ArrangementUiComponent c2;
            if (arrangementSettingsToken.equals((Object)component2.getToken()) || (c2 = this.myComponents.get(arrangementSettingsToken)) == null || !c2.isEnabled() || c2.alwaysCanBeActive()) continue;
            this.removeCondition(c2);
        }
    }

    private void removeCondition(@NotNull ArrangementUiComponent component2) {
        if (component2 == null) {
            ArrangementMatchingRuleEditor.$$$reportNull$$$0(15);
        }
        component2.setSelected(false);
        component2.setData(true);
        this.refreshConditions();
    }

    @Override
    public String toString() {
        return "matching rule editor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToken";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRuleEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRuleEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addRowIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToken";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRowIfNecessary";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyBackground";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCondition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateMutexConditions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeCondition";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

