/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesControl
extends ArrangementMatchingRulesControl {
    @NotNull
    public static final DataKey<ArrangementSectionRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Match.Control");
    @NotNull
    private static final Logger LOG = Logger.getInstance(ArrangementSectionRulesControl.class);
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @Nullable
    private final ArrangementSectionRuleManager mySectionRuleManager;
    @Nullable
    private ArrangementStandardSettingsManager myExtendedSettingsManager;

    public ArrangementSectionRulesControl(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback) {
        if (language == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(0);
        }
        if (settingsManager == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(1);
        }
        if (colorsProvider == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(3);
        }
        super(settingsManager, colorsProvider, callback);
        this.mySectionRuleManager = ArrangementSectionRuleManager.getInstance(language, settingsManager, colorsProvider, this);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
    }

    private static void appendBufferedSectionRules(@NotNull List<? super ArrangementSectionRule> result2, @NotNull List<? extends StdArrangementMatchRule> buffer, @Nullable String currentSectionStart) {
        if (result2 == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(4);
        }
        if (buffer == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(5);
        }
        if (currentSectionStart == null) {
            return;
        }
        if (buffer.isEmpty()) {
            result2.add((ArrangementSectionRule)ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[0]));
        } else {
            result2.add((ArrangementSectionRule)ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(0)}));
            for (int j = 1; j < buffer.size(); ++j) {
                result2.add((ArrangementSectionRule)ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(j)}));
            }
            buffer.clear();
        }
    }

    @Override
    protected ArrangementMatchingRulesControl.MatchingRulesRendererBase createRender() {
        return new MatchingRulesRenderer();
    }

    @Override
    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        return new ArrangementSectionRulesValidator(this.getModel(), this.mySectionRuleManager);
    }

    @Nullable
    public ArrangementSectionRuleManager getSectionRuleManager() {
        return this.mySectionRuleManager;
    }

    public List<ArrangementSectionRule> getSections() {
        if (this.getModel().getSize() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ArrangementSectionRule> result2 = new ArrayList<ArrangementSectionRule>();
        ArrayList<StdArrangementMatchRule> buffer = new ArrayList<StdArrangementMatchRule>();
        String currentSectionStart = null;
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData sectionRule;
            Object element = this.getModel().getElementAt(i2);
            if (!(element instanceof StdArrangementMatchRule)) continue;
            ArrangementSectionRuleManager.ArrangementSectionRuleData arrangementSectionRuleData = sectionRule = this.mySectionRuleManager == null ? null : this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element);
            if (sectionRule != null) {
                if (sectionRule.isSectionStart()) {
                    ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
                    currentSectionStart = sectionRule.getText();
                    continue;
                }
                result2.add(ArrangementSectionRule.create((String)StringUtil.notNullize(currentSectionStart), (String)sectionRule.getText(), buffer));
                buffer.clear();
                currentSectionStart = null;
                continue;
            }
            if (currentSectionStart == null) {
                result2.add(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)element}));
                continue;
            }
            buffer.add((StdArrangementMatchRule)element);
        }
        ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
        return result2;
    }

    public void setSections(@Nullable List<? extends ArrangementSectionRule> sections) {
        List rules = sections == null ? null : ArrangementUtil.collectMatchRules(sections);
        this.myComponents.clear();
        this.getModel().clear();
        if (rules == null) {
            return;
        }
        for (StdArrangementMatchRule rule : rules) {
            this.getModel().add(rule);
        }
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info("Arrangement matching rules list is refreshed. Given rules:");
            for (StdArrangementMatchRule rule : rules) {
                LOG.info("  " + rule.toString());
            }
        }
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myExtendedSettingsManager == null ? null : this.myExtendedSettingsManager.getRuleAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        if (aliases != null) {
            this.myExtendedSettingsManager = new ArrangementStandardSettingsManager(this.mySettingsManager.getDelegate(), this.myColorsProvider, aliases);
            this.myEditor = new ArrangementMatchingRuleEditor(this.myExtendedSettingsManager, this.myColorsProvider, this);
        }
    }

    @Override
    public void showEditor(int rowToEdit) {
        if (this.mySectionRuleManager != null && this.mySectionRuleManager.isSectionRule(this.getModel().getElementAt(rowToEdit))) {
            this.mySectionRuleManager.showEditor(rowToEdit);
        } else {
            super.showEditor(rowToEdit);
        }
    }

    @NotNull
    public ArrangementRuleAliasDialog createRuleAliasEditDialog() {
        final HashSet<String> tokenIds = new HashSet<String>();
        List<ArrangementSectionRule> sections = this.getSections();
        for (ArrangementSectionRule section : sections) {
            for (StdArrangementMatchRule rule : section.getMatchRules()) {
                rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor(){

                    public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                        if (condition == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (ArrangementUtil.isAliasedCondition((ArrangementAtomMatchCondition)condition)) {
                            tokenIds.add(condition.getType().getId());
                        }
                    }

                    public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                        if (condition == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        for (ArrangementMatchCondition operand : condition.getOperands()) {
                            operand.invite((ArrangementMatchConditionVisitor)this);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl$1", "visit"));
                    }
                });
            }
        }
        Collection<StdArrangementRuleAliasToken> aliases = this.getRulesAliases();
        assert (aliases != null);
        return new ArrangementRuleAliasDialog(null, this.mySettingsManager, this.myColorsProvider, aliases, tokenIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBufferedSectionRules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MatchingRulesRenderer
    extends ArrangementMatchingRulesControl.MatchingRulesRendererBase {
        private MatchingRulesRenderer() {
        }

        @Override
        public boolean allowModifications(StdArrangementMatchRule rule) {
            return ArrangementSectionRulesControl.this.mySectionRuleManager == null || !ArrangementSectionRulesControl.this.mySectionRuleManager.isSectionRule(rule);
        }
    }
}

