/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.formatting.fileSet.FileSetDescriptorFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobPatternDescriptor
implements FileSetDescriptor {
    public static final String TYPE = "globPattern";
    private String myPattern;

    public GlobPatternDescriptor(@NotNull String pattern) {
        if (pattern == null) {
            GlobPatternDescriptor.$$$reportNull$$$0(0);
        }
        this.myPattern = pattern;
    }

    public boolean matches(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobPatternDescriptor.$$$reportNull$$$0(1);
        }
        return this.matches(psiFile.getVirtualFile());
    }

    public boolean matches(@Nullable VirtualFile file2) {
        if (this.myPattern != null && file2 != null && file2.isInLocalFileSystem()) {
            try {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher(GlobPatternDescriptor.getGlob(this.myPattern));
                return matcher.matches(Paths.get(file2.getPath(), new String[0]));
            }
            catch (PatternSyntaxException ignore) {
                return false;
            }
        }
        return false;
    }

    private static String getGlob(@NotNull String pattern) {
        if (pattern == null) {
            GlobPatternDescriptor.$$$reportNull$$$0(2);
        }
        return "glob:" + (pattern.startsWith("/") ? "**" : "**/") + pattern;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    @Nullable
    public String getPattern() {
        return this.myPattern;
    }

    public void setPattern(@Nullable String pattern) {
        this.myPattern = pattern;
    }

    public boolean equals(Object obj) {
        return obj instanceof GlobPatternDescriptor && Objects.equals(((GlobPatternDescriptor)obj).myPattern, this.myPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/GlobPatternDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getGlob";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Factory
    implements FileSetDescriptorFactory {
        @Nullable
        public FileSetDescriptor createDescriptor(@NotNull FileSetDescriptor.State state) {
            if (state == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (GlobPatternDescriptor.TYPE.equals(state.type) && state.pattern != null) {
                return new GlobPatternDescriptor(state.pattern);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/application/options/codeStyle/excludedFiles/GlobPatternDescriptor$Factory", "createDescriptor"));
        }
    }
}

