/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.application.options.codeStyle.excludedFiles.GlobPatternDescriptor;
import com.intellij.application.options.codeStyle.excludedFiles.NamedScopeDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamedScopeToGlobConverter {
    private static final String FILE_PREFIX = "file:";
    private static final String OR_SEPARATOR = "\\|\\|";

    private NamedScopeToGlobConverter() {
    }

    @Nullable
    public static GlobPatternDescriptor convert(@NotNull NamedScopeDescriptor descriptor2) {
        if (descriptor2 == null) {
            NamedScopeToGlobConverter.$$$reportNull$$$0(0);
        }
        String pattern = descriptor2.getPattern();
        ArrayList<String> globPatterns = new ArrayList<String>();
        if (pattern != null) {
            String[] orPatterns;
            for (String orPattern : orPatterns = pattern.split(OR_SEPARATOR)) {
                if (StringUtil.isEmpty(orPattern)) continue;
                String filePattern = NamedScopeToGlobConverter.convertSinglePattern(orPattern.trim());
                if (filePattern == null) {
                    return null;
                }
                globPatterns.add(filePattern);
            }
        }
        if (globPatterns.size() == 0) {
            return null;
        }
        if (globPatterns.size() == 1) {
            return new GlobPatternDescriptor((String)globPatterns.get(0));
        }
        return new GlobPatternDescriptor("{" + StringUtil.join(globPatterns, ",") + "}");
    }

    @Nullable
    static String convertSinglePattern(@NotNull String rawPattern) {
        String filePattern;
        String sampleName;
        if (rawPattern == null) {
            NamedScopeToGlobConverter.$$$reportNull$$$0(1);
        }
        if (PathUtil.isValidFileName(sampleName = (filePattern = StringUtil.trimStart(rawPattern, FILE_PREFIX)).replaceAll("\\*", "ab"))) {
            return filePattern;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawPattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/NamedScopeToGlobConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convertSinglePattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

