/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JumpToColorsAndFontsAction
extends DumbAwareAction {
    public JumpToColorsAndFontsAction() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabledAndVisible(project2 != null && editor2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project2 == null || editor2 == null) {
            return;
        }
        HashMap<TextAttributesKey, Pair> keyMap = new HashMap<TextAttributesKey, Pair>();
        Processor<RangeHighlighterEx> processor = r -> {
            Pair p;
            HighlightInfo info2 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)r);
            TextAttributesKey key = info2 != null ? ObjectUtils.chooseNotNull(info2.forcedTextAttributesKey, info2.type.getAttributesKey()) : null;
            Pair pair = p = key == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key);
            if (p != null) {
                keyMap.put(key, p);
            }
            return true;
        };
        JBIterable<Editor> editors2 = editor2 instanceof EditorWindow ? JBIterable.of(editor2, ((EditorWindow)editor2).getDelegate()) : JBIterable.of(editor2);
        block0: for (Editor ed : editors2) {
            TextRange selection = EditorUtil.getSelectionInAnyMode((Editor)ed);
            MarkupModel forDocument = DocumentMarkupModel.forDocument((Document)ed.getDocument(), (Project)project2, (boolean)false);
            if (forDocument != null) {
                ((MarkupModelEx)forDocument).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), processor);
            }
            ((MarkupModelEx)ed.getMarkupModel()).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), processor);
            EditorHighlighter highlighter = editor2.getHighlighter();
            SyntaxHighlighter syntaxHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
            if (syntaxHighlighter == null) continue;
            HighlighterIterator iterator2 = highlighter.createIterator(selection.getStartOffset());
            while (!iterator2.atEnd()) {
                for (TextAttributesKey key : syntaxHighlighter.getTokenHighlights(iterator2.getTokenType())) {
                    Pair p2;
                    Pair pair = p2 = key == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key);
                    if (p2 == null) continue;
                    keyMap.put(key, p2);
                }
                if (iterator2.getEnd() >= selection.getEndOffset()) continue block0;
                iterator2.advance();
            }
        }
        if (keyMap.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.no.text.attributes.found", new Object[0]));
        } else if (keyMap.size() == 1) {
            Pair p3 = (Pair)keyMap.values().iterator().next();
            if (!JumpToColorsAndFontsAction.openSettingsAndSelectKey(project2, (ColorAndFontDescriptorsProvider)p3.first, (AttributesDescriptor)p3.second)) {
                HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.no.appropriate.settings.page.found", new Object[0]));
            }
        } else {
            ArrayList attrs = new ArrayList(keyMap.values());
            attrs.sort((o1, o2) -> StringUtil.naturalCompare(((ColorAndFontDescriptorsProvider)o1.first).getDisplayName() + ((AttributesDescriptor)o1.second).getDisplayName(), ((ColorAndFontDescriptorsProvider)o2.first).getDisplayName() + ((AttributesDescriptor)o2.second).getDisplayName()));
            final EditorColorsScheme colorsScheme = editor2.getColorsScheme();
            ColoredListCellRenderer<Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>> renderer = new ColoredListCellRenderer<Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor>> list2, Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> value, int index2, boolean selected, boolean hasFocus) {
                    boolean addBoxed;
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TextAttributes ta = colorsScheme.getAttributes(((AttributesDescriptor)value.second).getKey());
                    Color fg = ObjectUtils.chooseNotNull(ta.getForegroundColor(), colorsScheme.getDefaultForeground());
                    Color bg = ObjectUtils.chooseNotNull(ta.getBackgroundColor(), colorsScheme.getDefaultBackground());
                    SimpleTextAttributes sa = SimpleTextAttributes.fromTextAttributes((TextAttributes)ta);
                    SimpleTextAttributes saOpaque = sa.derive(0x100 | sa.getStyle(), fg, bg, null);
                    SimpleTextAttributes saSelected = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(sa.getStyle(), null, null, null);
                    SimpleTextAttributes saCur = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    List<String> split2 = StringUtil.split(((ColorAndFontDescriptorsProvider)value.first).getDisplayName() + "//" + ((AttributesDescriptor)value.second).getDisplayName(), "//");
                    int len = split2.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        boolean last2;
                        boolean bl = last2 = i2 == len - 1;
                        SimpleTextAttributes simpleTextAttributes = !last2 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (saCur = selected ? saSelected : saOpaque);
                        if (last2) {
                            this.append(" ", saCur);
                        }
                        this.append(split2.get(i2), saCur);
                        if (last2) {
                            this.append(" ", saCur);
                            continue;
                        }
                        this.append(" > ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    Color stripeColor = ta.getErrorStripeColor();
                    boolean addStripe = stripeColor != null && stripeColor != saCur.getBgColor();
                    boolean bl = addBoxed = ta.getEffectType() == EffectType.BOXED && ta.getEffectColor() != null;
                    if (addBoxed) {
                        this.append("\u25a2" + (addStripe ? "" : " "), saCur.derive(-1, ta.getEffectColor(), null, null));
                    }
                    if (addStripe) {
                        this.append(" ", saCur.derive(256, null, stripeColor, null));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/JumpToColorsAndFontsAction$1", "customizeCellRenderer"));
                }
            };
            JBPopupFactory.getInstance().createPopupChooserBuilder(attrs).setRenderer((ListCellRenderer)renderer).setTitle(StringUtil.notNullize(e.getPresentation().getText())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(p -> {
                if (!JumpToColorsAndFontsAction.openSettingsAndSelectKey(project2, (ColorAndFontDescriptorsProvider)p.first, (AttributesDescriptor)p.second)) {
                    HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.no.appropriate.settings.page.found", new Object[0]));
                }
            }).createPopup().showInBestPositionFor(editor2);
        }
    }

    private static boolean openSettingsAndSelectKey(@NotNull Project project2, @NotNull ColorAndFontDescriptorsProvider page2, @NotNull AttributesDescriptor descriptor2) {
        if (project2 == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(3);
        }
        if (page2 == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            JumpToColorsAndFontsAction.$$$reportNull$$$0(5);
        }
        return ColorAndFontOptions.selectOrEditColor(id -> CommonDataKeys.PROJECT.is(id) ? project2 : null, (String)descriptor2.getDisplayName(), (String)page2.getDisplayName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/JumpToColorsAndFontsAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/JumpToColorsAndFontsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openSettingsAndSelectKey";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

