/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.application.options.colors.pluginExport.ColorSchemePluginTemplate;
import com.intellij.application.options.colors.pluginExport.PluginExportData;
import com.intellij.application.options.colors.pluginExport.PluginInfoDialog;
import com.intellij.application.options.schemes.SerializableSchemeExporter;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSchemePluginExporter
extends ConfigurableSchemeExporter<PluginExportData, EditorColorsScheme> {
    public void exportScheme(@NotNull EditorColorsScheme scheme, @NotNull OutputStream outputStream, @Nullable PluginExportData exportData) throws Exception {
        if (scheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(1);
        }
        if (exportData != null) {
            try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
                zipStream.putNextEntry(new ZipEntry("META-INF/plugin.xml"));
                ColorSchemePluginExporter.writePluginXml(scheme, zipStream, exportData);
                zipStream.putNextEntry(new ZipEntry("colors/" + scheme.getName() + ".xml"));
                SerializableSchemeExporter.writeToStream((SerializableScheme)((SerializableScheme)scheme), (OutputStream)zipStream);
            }
        }
    }

    public String getExtension() {
        return "jar";
    }

    @Nullable
    public PluginExportData getConfiguration(@NotNull Component parent2, @NotNull EditorColorsScheme scheme) {
        if (parent2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(2);
        }
        if (scheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(3);
        }
        PluginExportData exportData = ColorSchemePluginExporter.getPluginExportData(scheme);
        EditorColorsScheme schemeToUpdate = ColorSchemePluginExporter.getSchemeToUpdate(scheme);
        PluginInfoDialog infoDialog = new PluginInfoDialog(parent2, exportData);
        if (infoDialog.showAndGet()) {
            infoDialog.apply();
            exportData.saveToProperties(schemeToUpdate.getMetaProperties());
            if (schemeToUpdate instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)schemeToUpdate).setSaveNeeded(true);
            }
            return exportData;
        }
        return null;
    }

    private static void writePluginXml(@NotNull EditorColorsScheme scheme, @NotNull OutputStream outputStream, @NotNull PluginExportData exportData) throws IOException {
        if (scheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(4);
        }
        if (outputStream == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(5);
        }
        if (exportData == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(6);
        }
        ColorSchemePluginTemplate template = new ColorSchemePluginTemplate(scheme, exportData);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer.write(template.getText());
        writer.flush();
    }

    @NotNull
    private static EditorColorsScheme getSchemeToUpdate(@NotNull EditorColorsScheme scheme) {
        AbstractColorsScheme original;
        if (scheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(7);
        }
        if (scheme instanceof AbstractColorsScheme && (original = ((AbstractColorsScheme)scheme).getOriginal()) != null) {
            AbstractColorsScheme abstractColorsScheme = original;
            if (abstractColorsScheme == null) {
                ColorSchemePluginExporter.$$$reportNull$$$0(8);
            }
            return abstractColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme;
        if (editorColorsScheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(9);
        }
        return editorColorsScheme;
    }

    @NotNull
    private static PluginExportData getPluginExportData(@NotNull EditorColorsScheme scheme) {
        AbstractColorsScheme original;
        PluginExportData data2;
        if (scheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(10);
        }
        if ((data2 = new PluginExportData(scheme.getMetaProperties())).isEmpty() && scheme instanceof AbstractColorsScheme && !(scheme instanceof ReadOnlyColorsScheme) && (original = ((AbstractColorsScheme)scheme).getOriginal()) != null) {
            return ColorSchemePluginExporter.getPluginExportData((EditorColorsScheme)original);
        }
        PluginExportData pluginExportData = data2;
        if (pluginExportData == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(11);
        }
        return pluginExportData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportData";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/pluginExport/ColorSchemePluginExporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/pluginExport/ColorSchemePluginExporter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeToUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginExportData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exportScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writePluginXml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemeToUpdate";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPluginExportData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 11 -> new IllegalStateException(string2);
        };
    }
}

