/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.CheckboxDescriptor;
import com.intellij.application.options.editor.CheckboxDescriptorKt;
import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsPanelKt;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.BoundCompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/application/options/editor/EditorOptionsPanel;", "Lcom/intellij/openapi/options/BoundCompositeConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "Lcom/intellij/openapi/options/Configurable$WithEpDependencies;", "()V", "apply", "", "createConfigurables", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getDependencies", "", "Lcom/intellij/openapi/extensions/BaseExtensionPointName;", "Companion", "intellij.platform.lang.impl"})
public final class EditorOptionsPanel
extends BoundCompositeConfigurable<UnnamedConfigurable>
implements Configurable.WithEpDependencies {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "preferences.editor";

    public EditorOptionsPanel() {
        String string2 = ApplicationBundle.message((String)"title.editor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"title.editor\")");
        super(string2, ID);
    }

    @NotNull
    public List<UnnamedConfigurable> createConfigurables() {
        List list2 = ConfigurableWrapper.createConfigurables((ExtensionPointName)EditorOptionsPanelKt.access$getEP_NAME$p());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createConfigurables(EP_NAME)");
        return list2;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return SetsKt.setOf((Object)EditorOptionsPanelKt.access$getEP_NAME$p());
    }

    @NotNull
    public DialogPanel createPanel() {
        Ref.ObjectRef chkEnableWheelFontSizeChange = new Ref.ObjectRef();
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, (Ref.ObjectRef<JCheckBox>)chkEnableWheelFontSizeChange){
            final /* synthetic */ EditorOptionsPanel this$0;
            final /* synthetic */ Ref.ObjectRef<JCheckBox> $chkEnableWheelFontSizeChange;
            {
                this.this$0 = $receiver;
                this.$chkEnableWheelFontSizeChange = $chkEnableWheelFontSizeChange;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"group.advanced.mouse.usages", (Object[])new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$chkEnableWheelFontSizeChange){
                    final /* synthetic */ Ref.ObjectRef<JCheckBox> $chkEnableWheelFontSizeChange;
                    {
                        this.$chkEnableWheelFontSizeChange = $chkEnableWheelFontSizeChange;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Panel $this$group) {
                        void getter$iv;
                        void $this$bind$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$chkEnableWheelFontSizeChange){
                            final /* synthetic */ Ref.ObjectRef<JCheckBox> $chkEnableWheelFontSizeChange;
                            {
                                this.$chkEnableWheelFontSizeChange = $chkEnableWheelFontSizeChange;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull Row $this$row) {
                                void $this$invoke_u24lambda_u240;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                JComponent jComponent = CheckboxDescriptorKt.checkBox((Row)$this$row, (CheckboxDescriptor)EditorOptionsPanelKt.access$getEnableWheelFontChange()).getComponent();
                                JBCheckBox jBCheckBox = (JBCheckBox)jComponent;
                                Ref.ObjectRef<JCheckBox> objectRef = this.$chkEnableWheelFontSizeChange;
                                boolean bl = false;
                                Object[] objectArray = new String[]{LangBundle.message("checkbox.enable.ctrl.mousewheel.changes.font.size.search.hit.1", new Object[0]), LangBundle.message("checkbox.enable.ctrl.mousewheel.changes.font.size.search.hit.2", new Object[0])};
                                ClientProperty.put((JComponent)$this$invoke_u24lambda_u240, SearchUtil.ADDITIONAL_SEARCH_LABELS_KEY, CollectionsKt.listOf((Object[])objectArray));
                                objectRef.element = jComponent;
                            }
                        }), (int)1, null);
                        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)true, (Function1)((Function1)new Function1<Panel, Unit>(this.$chkEnableWheelFontSizeChange){
                            final /* synthetic */ Ref.ObjectRef<JCheckBox> $chkEnableWheelFontSizeChange;
                            {
                                this.$chkEnableWheelFontSizeChange = $chkEnableWheelFontSizeChange;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$buttonsGroup) {
                                JCheckBox jCheckBox;
                                Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                                Row row = Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)createPanel.1.INSTANCE, (int)1, null);
                                if (this.$chkEnableWheelFontSizeChange.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"chkEnableWheelFontSizeChange");
                                    jCheckBox = null;
                                } else {
                                    jCheckBox = (JCheckBox)this.$chkEnableWheelFontSizeChange.element;
                                }
                                row.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
                            }
                        }), (int)1, null);
                        Function0 function0 = createPanel.3.INSTANCE;
                        Function1 setter$iv = createPanel.4.INSTANCE;
                        boolean $i$f$bind = false;
                        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Boolean.class);
                        Panel.row$default((Panel)$this$group, null, (Function1)createPanel.5.INSTANCE, (int)1, null);
                    }
                }), (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"group.soft.wraps", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.2.INSTANCE, (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"group.virtual.space", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.3.INSTANCE, (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"group.caret.movement", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.4.INSTANCE, (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"editor.options.scrolling", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.5.INSTANCE, (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"group.richcopy", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.6.INSTANCE, (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)ApplicationBundle.message((String)"editor.options.save.files.group", (Object[])new Object[0]), (boolean)false, (Function1)createPanel.7.INSTANCE, (int)2, null);
                for (UnnamedConfigurable configurable2 : this.this$0.getConfigurables()) {
                    EditorOptionsPanel.access$appendDslConfigurable(this.this$0, $this$panel, configurable2);
                }
            }
        }));
    }

    public void apply() {
        boolean wasModified = this.isModified();
        super.apply();
        if (wasModified) {
            EditorOptionsPanel.Companion.clearAllIdentifierHighlighters();
            Companion.reinitAllEditors();
            UISettings.Companion.getInstance().fireUISettingsChanged();
            Companion.restartDaemons();
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = EditorOptionsListener.OPTIONS_PANEL_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"OPTIONS_PANEL_TOPIC");
            ((EditorOptionsListener)messageBus.syncPublisher(topic)).changesApplied();
        }
    }

    @JvmStatic
    public static final void reinitAllEditors() {
        Companion.reinitAllEditors();
    }

    @JvmStatic
    public static final void restartDaemons() {
        Companion.restartDaemons();
    }

    public static final /* synthetic */ void access$appendDslConfigurable(EditorOptionsPanel $this, Panel $receiver, UnnamedConfigurable configurable2) {
        $this.appendDslConfigurable($receiver, configurable2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/application/options/editor/EditorOptionsPanel$Companion;", "", "()V", "ID", "", "clearAllIdentifierHighlighters", "", "reinitAllEditors", "restartDaemons", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void clearAllIdentifierHighlighters() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
            for (Project project2 : projectArray) {
                FileEditor[] fileEditorArray;
                Intrinsics.checkNotNullExpressionValue((Object)FileEditorManager.getInstance(project2).getAllEditors(), (String)"getInstance(project).allEditors");
                for (FileEditor fileEditor : fileEditorArray) {
                    Document document;
                    if (!(fileEditor instanceof TextEditor)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((TextEditor)fileEditor).getEditor().getDocument(), (String)"fileEditor.editor.document");
                    IdentifierHighlighterPass.clearMyHighlights(document, project2);
                }
            }
        }

        @JvmStatic
        public final void reinitAllEditors() {
            EditorFactory.getInstance().refreshAllEditors();
        }

        @JvmStatic
        public final void restartDaemons() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
            for (Project project2 : projectArray) {
                DaemonCodeAnalyzer.getInstance(project2).settingsChanged();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

