/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.DynamicBundle;
import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GutterIconsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String ID = "editor.preferences.gutterIcons";
    private JPanel myPanel;
    private CheckBoxList<GutterIconDescriptor> myList;
    private JBCheckBox myShowGutterIconsJBCheckBox;
    private final List<GutterIconDescriptor> myDescriptors;
    private final Map<GutterIconDescriptor, PluginDescriptor> myFirstDescriptors;

    public GutterIconsConfigurable() {
        this.$$$setupUI$$$();
        this.myDescriptors = new ArrayList<GutterIconDescriptor>();
        this.myFirstDescriptors = new HashMap<GutterIconDescriptor, PluginDescriptor>();
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.GutterIconsConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.editor.gutter.icons";
    }

    @Nullable
    public JComponent createComponent() {
        LanguageExtensionPoint<LineMarkerProvider>[] extensions2 = LineMarkerProviders.EP_NAME.getExtensions();
        NullableFunction<LanguageExtensionPoint, PluginDescriptor> function = point1 -> {
            LineMarkerProvider instance2 = (LineMarkerProvider)point1.getInstance();
            return instance2 instanceof LineMarkerProviderDescriptor && ((LineMarkerProviderDescriptor)instance2).getName() != null ? point1.getPluginDescriptor() : null;
        };
        MultiMap<PluginDescriptor, LanguageExtensionPoint> map2 = ContainerUtil.groupBy(Arrays.asList(extensions2), function);
        HashMap<GutterIconDescriptor, PluginDescriptor> pluginDescriptorMap = new HashMap<GutterIconDescriptor, PluginDescriptor>();
        HashSet<String> ids = new HashSet<String>();
        for (PluginDescriptor descriptor2 : map2.keySet()) {
            Collection<LanguageExtensionPoint> points = map2.get(descriptor2);
            for (LanguageExtensionPoint extensionPoint : points) {
                GutterIconDescriptor instance2 = (GutterIconDescriptor)extensionPoint.getInstance();
                if (instance2.getOptions().length > 0) {
                    for (GutterIconDescriptor.Option option : instance2.getOptions()) {
                        if (!ids.add(((GutterIconDescriptor)option).getId())) continue;
                        this.myDescriptors.add(option);
                        pluginDescriptorMap.put(option, descriptor2);
                    }
                    continue;
                }
                if (ids.add(instance2.getId())) {
                    this.myDescriptors.add(instance2);
                }
                pluginDescriptorMap.put(instance2, descriptor2);
            }
        }
        this.myDescriptors.sort((o1, o2) -> {
            int byPlugin = StringUtil.naturalCompare(GutterIconsConfigurable.getPluginDisplayName((PluginDescriptor)pluginDescriptorMap.get(o1)), GutterIconsConfigurable.getPluginDisplayName((PluginDescriptor)pluginDescriptorMap.get(o2)));
            return byPlugin != 0 ? byPlugin : StringUtil.naturalCompare(o1.getName(), o2.getName());
        });
        PluginId current = null;
        for (GutterIconDescriptor descriptor3 : this.myDescriptors) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)pluginDescriptorMap.get(descriptor3);
            PluginId pluginId = pluginDescriptor != null ? pluginDescriptor.getPluginId() : null;
            if (pluginId == null || pluginId.equals(current)) continue;
            this.myFirstDescriptors.put(descriptor3, pluginDescriptor);
            current = pluginId;
        }
        this.myList.setItems(this.myDescriptors, GutterIconDescriptor::getName);
        this.myShowGutterIconsJBCheckBox.addChangeListener(e -> this.myList.setEnabled(this.myShowGutterIconsJBCheckBox.isSelected()));
        SwingUtilities.updateComponentTreeUI(this.myPanel);
        return this.myPanel;
    }

    public boolean isModified() {
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            if (this.myList.isItemSelected((Object)descriptor2) == LineMarkerSettings.getSettings().isEnabled(descriptor2)) continue;
            return true;
        }
        return this.myShowGutterIconsJBCheckBox.isSelected() != EditorSettingsExternalizable.getInstance().areGutterIconsShown();
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        if (this.myShowGutterIconsJBCheckBox.isSelected() != editorSettings.areGutterIconsShown()) {
            editorSettings.setGutterIconsShown(this.myShowGutterIconsJBCheckBox.isSelected());
            EditorOptionsPanel.reinitAllEditors();
        }
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            LineMarkerSettings.getSettings().setEnabled(descriptor2, this.myList.isItemSelected((Object)descriptor2));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance(project2).restart();
        }
        ((EditorOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorOptionsListener.GUTTER_ICONS_CONFIGURABLE_TOPIC)).changesApplied();
    }

    public void reset() {
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            this.myList.setItemSelected((Object)descriptor2, LineMarkerSettings.getSettings().isEnabled(descriptor2));
        }
        boolean gutterIconsShown = EditorSettingsExternalizable.getInstance().areGutterIconsShown();
        this.myShowGutterIconsJBCheckBox.setSelected(gutterIconsShown);
        this.myList.setEnabled(gutterIconsShown);
    }

    public void disposeUIResources() {
        for (ChangeListener listener2 : this.myShowGutterIconsJBCheckBox.getChangeListeners()) {
            this.myShowGutterIconsJBCheckBox.removeChangeListener(listener2);
        }
    }

    @Nls
    private static String getPluginDisplayName(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            GutterIconsConfigurable.$$$reportNull$$$0(0);
        }
        return pluginDescriptor instanceof IdeaPluginDescriptor && PluginManagerCore.CORE_ID.equals(pluginDescriptor.getPluginId()) ? IdeBundle.message((String)"title.common", (Object[])new Object[0]) : pluginDescriptor.getName();
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList<GutterIconDescriptor>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index2, boolean selected, boolean hasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBorder(BorderFactory.createEmptyBorder());
                GutterIconDescriptor descriptor2 = (GutterIconDescriptor)GutterIconsConfigurable.this.myList.getItemAt(index2);
                Icon icon2 = descriptor2 == null ? null : descriptor2.getIcon();
                JLabel label2 = new JLabel(icon2 == null ? EmptyIcon.ICON_16 : icon2);
                label2.setOpaque(true);
                label2.setPreferredSize(new Dimension(25, -1));
                label2.setHorizontalAlignment(0);
                panel2.add((Component)label2, "West");
                panel2.add((Component)checkBox, "Center");
                panel2.setBackground(this.getBackground(false));
                label2.setBackground(this.getBackground(selected));
                if (!checkBox.isOpaque()) {
                    checkBox.setOpaque(true);
                }
                checkBox.setBorder(null);
                PluginDescriptor pluginDescriptor = GutterIconsConfigurable.this.myFirstDescriptors.get(descriptor2);
                if (pluginDescriptor != null) {
                    SeparatorWithText separator = new SeparatorWithText();
                    String name = GutterIconsConfigurable.getPluginDisplayName(pluginDescriptor);
                    separator.setCaption(name);
                    panel2.add((Component)separator, "North");
                }
                return panel2;
            }

            @Nullable
            protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox, int index2) {
                if (checkBox == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.findPointRelativeToCheckBoxWithAdjustedRendering(x, y, checkBox, index2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/application/options/editor/GutterIconsConfigurable$1", "findPointRelativeToCheckBox"));
            }
        };
        this.myList.setSelectionMode(2);
        this.myList.setBorder(BorderFactory.createEmptyBorder());
        new ListSpeedSearch(this.myList, AbstractButton::getText);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> Objects.requireNonNull(SpeedSearchSupply.getSupply(this.myList, (boolean)true)).findAndSelectElement(option);
    }

    @TestOnly
    public List<GutterIconDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList<GutterIconDescriptor> checkBoxList = this.myList;
        jBScrollPane.setViewportView((Component)checkBoxList);
        this.myShowGutterIconsJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", GutterIconsConfigurable.class).getString("checkbox.show.gutter.icons"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/application/options/editor/GutterIconsConfigurable", "getPluginDisplayName"));
    }

    public static class ShowSettingsAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettingsAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), GutterIconsConfigurable.class);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowSettingsAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/GutterIconsConfigurable$ShowSettingsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/GutterIconsConfigurable$ShowSettingsAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

