/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNode;
import com.intellij.build.Filterable;
import com.intellij.build.SuccessfulStepsToggleAction;
import com.intellij.build.WarningsToggleAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"SUCCESSFUL_STEPS_FILTER", "Ljava/util/function/Predicate;", "Lcom/intellij/build/ExecutionNode;", "WARNINGS_FILTER", "createFilteringActionsGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "filterable", "Lcom/intellij/build/Filterable;", "install", "", "intellij.platform.lang.impl"})
@JvmName(name="BuildTreeFilters")
public final class BuildTreeFilters {
    @NotNull
    private static final Predicate<ExecutionNode> SUCCESSFUL_STEPS_FILTER = BuildTreeFilters::SUCCESSFUL_STEPS_FILTER$lambda$0;
    @NotNull
    private static final Predicate<ExecutionNode> WARNINGS_FILTER = BuildTreeFilters::WARNINGS_FILTER$lambda$1;

    @ApiStatus.Experimental
    @NotNull
    public static final DefaultActionGroup createFilteringActionsGroup(@NotNull Filterable<ExecutionNode> filterable) {
        Intrinsics.checkNotNullParameter(filterable, (String)"filterable");
        DefaultActionGroup actionGroup2 = new DefaultActionGroup(LangBundle.message("action.filters.text", new Object[0]), true);
        actionGroup2.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        actionGroup2.add((AnAction)new WarningsToggleAction(filterable));
        actionGroup2.add((AnAction)new SuccessfulStepsToggleAction(filterable));
        return actionGroup2;
    }

    @ApiStatus.Experimental
    public static final void install(@NotNull Filterable<ExecutionNode> filterable) {
        Intrinsics.checkNotNullParameter(filterable, (String)"filterable");
        boolean filteringEnabled = filterable.isFilteringEnabled();
        if (!filteringEnabled) {
            return;
        }
        SuccessfulStepsToggleAction.Companion.install(filterable);
        WarningsToggleAction.Companion.install(filterable);
    }

    private static final boolean SUCCESSFUL_STEPS_FILTER$lambda$0(ExecutionNode node2) {
        Intrinsics.checkNotNullParameter((Object)((Object)node2), (String)"node");
        return !node2.isFailed() && !node2.hasWarnings();
    }

    private static final boolean WARNINGS_FILTER$lambda$1(ExecutionNode node2) {
        Intrinsics.checkNotNullParameter((Object)((Object)node2), (String)"node");
        return node2.hasWarnings() || node2.hasInfos();
    }

    public static final /* synthetic */ Predicate access$getSUCCESSFUL_STEPS_FILTER$p() {
        return SUCCESSFUL_STEPS_FILTER;
    }

    public static final /* synthetic */ Predicate access$getWARNINGS_FILTER$p() {
        return WARNINGS_FILTER;
    }
}

