/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.Filterable;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider,
Filterable<ExecutionNode>,
OccurenceNavigator,
ObservableConsoleView {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    @ApiStatus.Experimental
    public static final DataKey<List<AnAction>> RESTART_ACTIONS = DataKey.create((String)"restart actions");
    private static final OccurenceNavigator EMPTY_PROBLEMS_NAVIGATOR = new OccurenceNavigator(){

        public boolean hasNextOccurence() {
            return false;
        }

        public boolean hasPreviousOccurence() {
            return false;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return null;
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string2 = IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
            if (string2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string2 = IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
            if (string2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/build/BuildView$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewManager myViewManager;
    private final AtomicBoolean isBuildStartEventProcessed;
    private final List<BuildEvent> myAfterStartEvents;
    @NotNull
    private final DefaultBuildDescriptor myBuildDescriptor;
    @Nullable
    private volatile ExecutionConsole myExecutionConsole;
    private volatile BuildViewSettingsProvider myViewSettingsProvider;

    public BuildView(@NotNull Project project2, @NotNull BuildDescriptor buildDescriptor, @NonNls @Nullable String selectionStateKey, @NotNull ViewManager viewManager) {
        if (project2 == null) {
            BuildView.$$$reportNull$$$0(0);
        }
        if (buildDescriptor == null) {
            BuildView.$$$reportNull$$$0(1);
        }
        if (viewManager == null) {
            BuildView.$$$reportNull$$$0(2);
        }
        this(project2, null, buildDescriptor, selectionStateKey, viewManager);
    }

    public BuildView(@NotNull Project project2, @Nullable ExecutionConsole executionConsole, @NotNull BuildDescriptor buildDescriptor, @NonNls @Nullable String selectionStateKey, @NotNull ViewManager viewManager) {
        if (project2 == null) {
            BuildView.$$$reportNull$$$0(3);
        }
        if (buildDescriptor == null) {
            BuildView.$$$reportNull$$$0(4);
        }
        if (viewManager == null) {
            BuildView.$$$reportNull$$$0(5);
        }
        super(selectionStateKey);
        this.isBuildStartEventProcessed = new AtomicBoolean();
        this.myAfterStartEvents = ContainerUtil.createConcurrentList();
        this.myProject = project2;
        this.myViewManager = viewManager;
        this.myExecutionConsole = executionConsole;
        this.myBuildDescriptor = buildDescriptor instanceof DefaultBuildDescriptor ? (DefaultBuildDescriptor)buildDescriptor : new DefaultBuildDescriptor(buildDescriptor);
        Disposer.register(project2, this);
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(6);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(7);
        }
        if (event instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                this.onStartBuild(buildId, (StartBuildEvent)event);
                for (BuildEvent buildEvent : this.myAfterStartEvents) {
                    this.processEvent(buildId, buildEvent);
                }
                this.myAfterStartEvents.clear();
                this.isBuildStartEventProcessed.set(true);
            });
            return;
        }
        if (!this.isBuildStartEventProcessed.get()) {
            this.myAfterStartEvents.add(event);
        } else {
            this.processEvent(buildId, event);
        }
    }

    private void processEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(8);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(9);
        }
        if (event instanceof OutputBuildEvent && (event.getParentId() == null || event.getParentId() == this.myBuildDescriptor.getId())) {
            ExecutionConsole consoleView = this.getConsoleView();
            if (consoleView instanceof BuildProgressListener) {
                ((BuildProgressListener)consoleView).onEvent(buildId, event);
            }
        } else {
            BuildTreeConsoleView eventView = this.getEventView();
            if (eventView != null) {
                eventView.onEvent(buildId, event);
            }
        }
    }

    private void onStartBuild(@NotNull Object buildId, @NotNull StartBuildEvent startBuildEvent) {
        Application application;
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(10);
        }
        if (startBuildEvent == null) {
            BuildView.$$$reportNull$$$0(11);
        }
        if ((application = ApplicationManager.getApplication()).isHeadlessEnvironment() && !application.isUnitTestMode()) {
            return;
        }
        if (startBuildEvent instanceof StartBuildEventImpl) {
            this.myViewSettingsProvider = ((StartBuildEventImpl)startBuildEvent).getBuildViewSettingsProvider();
        }
        if (this.myViewSettingsProvider == null) {
            this.myViewSettingsProvider = () -> false;
        }
        if (this.myExecutionConsole == null) {
            Supplier<? extends RunContentDescriptor> descriptorSupplier = this.myBuildDescriptor.getContentDescriptorSupplier();
            RunContentDescriptor runContentDescriptor = descriptorSupplier != null ? descriptorSupplier.get() : null;
            BuildTextConsoleView buildTextConsoleView = this.myExecutionConsole = runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != null && runContentDescriptor.getExecutionConsole() != this ? runContentDescriptor.getExecutionConsole() : new BuildTextConsoleView(this.myProject, false, this.myBuildDescriptor.getExecutionFilters());
            if (runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != this) {
                Disposer.register(this, (Disposable)runContentDescriptor);
            }
        }
        boolean buildTree = true;
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole != null) {
            executionConsole.getComponent();
            if (this.myViewSettingsProvider.isExecutionViewHidden()) {
                this.addViewAndShowIfNeeded(executionConsole, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
                buildTree = false;
            } else if (this.isShowInDashboard()) {
                ExecutionConsole consoleView = executionConsole instanceof ConsoleView ? BuildView.wrapWithToolbar((ConsoleView)executionConsole) : executionConsole;
                this.addViewAndShowIfNeeded(consoleView, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
                if (executionConsole instanceof ConsoleViewImpl) {
                    ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)executionConsole;
                    consoleViewImpl.getEditor().setBorder(IdeBorderFactory.createBorder((int)4));
                }
                buildTree = false;
            }
        }
        BuildTreeConsoleView eventView = null;
        if (buildTree && (eventView = this.getEventView()) == null) {
            String eventViewName = BuildTreeConsoleView.class.getName();
            eventView = new BuildTreeConsoleView(this.myProject, this.myBuildDescriptor, this.myExecutionConsole);
            this.addView(eventView, eventViewName);
            this.showView(eventViewName);
        }
        BuildProcessHandler processHandler = this.myBuildDescriptor.getProcessHandler();
        if (this.myExecutionConsole instanceof ConsoleView) {
            ConsoleView consoleView = (ConsoleView)this.myExecutionConsole;
            if (consoleView != null && !(consoleView instanceof BuildTextConsoleView)) {
                this.myBuildDescriptor.getExecutionFilters().forEach(arg_0 -> ((ConsoleView)consoleView).addMessageFilter(arg_0));
            }
            if (processHandler != null) {
                assert (consoleView != null);
                consoleView.attachToProcess((ProcessHandler)processHandler);
                Consumer<? super ConsoleView> attachedConsoleConsumer = this.myBuildDescriptor.getAttachedConsoleConsumer();
                if (attachedConsoleConsumer != null) {
                    attachedConsoleConsumer.consume((ConsoleView)consoleView);
                }
            }
        }
        if (processHandler != null && !processHandler.isStartNotified()) {
            processHandler.startNotify();
        }
        if (eventView != null) {
            eventView.onEvent(buildId, startBuildEvent);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public ExecutionConsole getConsoleView() {
        return this.myExecutionConsole;
    }

    @Nullable
    @ApiStatus.Internal
    BuildTreeConsoleView getEventView() {
        return this.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent2) {
        ExecutionConsole console;
        if (listener2 == null) {
            BuildView.$$$reportNull$$$0(12);
        }
        if (parent2 == null) {
            BuildView.$$$reportNull$$$0(13);
        }
        if ((console = this.getConsoleView()) instanceof ObservableConsoleView) {
            ((ObservableConsoleView)console).addChangeListener(listener2, parent2);
        }
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildView.$$$reportNull$$$0(14);
        }
        if (contentType == null) {
            BuildView.$$$reportNull$$$0(15);
        }
        this.delegateToConsoleView(view -> view.print(text2, contentType));
    }

    private void delegateToConsoleView(Consumer<? super ConsoleView> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            viewConsumer.consume((ConsoleView)((ConsoleView)console));
        }
    }

    @Nullable
    private <R> R getConsoleViewValue(Function<? super ConsoleView, ? extends R> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            return viewConsumer.apply((ConsoleView)((ConsoleView)console));
        }
        return null;
    }

    public void clear() {
        this.delegateToConsoleView(ConsoleView::clear);
    }

    public void scrollTo(int offset2) {
        this.delegateToConsoleView(view -> view.scrollTo(offset2));
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            BuildView.$$$reportNull$$$0(16);
        }
        this.delegateToConsoleView(view -> view.attachToProcess(processHandler));
    }

    public boolean isOutputPaused() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::isOutputPaused);
        return result2 != null && result2 != false;
    }

    public void setOutputPaused(boolean value) {
        this.delegateToConsoleView(view -> view.setOutputPaused(value));
    }

    public boolean hasDeferredOutput() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::hasDeferredOutput);
        return result2 != null && result2 != false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            BuildView.$$$reportNull$$$0(17);
        }
        this.delegateToConsoleView(view -> view.performWhenNoDeferredOutput(runnable));
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildView.$$$reportNull$$$0(18);
        }
        this.delegateToConsoleView(view -> view.setHelpId(helpId));
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(19);
        }
        this.delegateToConsoleView(view -> view.addMessageFilter(filter2));
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            BuildView.$$$reportNull$$$0(20);
        }
        this.delegateToConsoleView(view -> view.printHyperlink(hyperlinkText, info2));
    }

    public int getContentSize() {
        Integer result2 = this.getConsoleViewValue(ConsoleView::getContentSize);
        return result2 == null ? 0 : result2;
    }

    public boolean canPause() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::canPause);
        return result2 != null && result2 != false;
    }

    @Override
    public AnAction @NotNull [] createConsoleActions() {
        ExecutionConsole consoleView;
        if (!this.myViewManager.isBuildContentView()) {
            if (AnAction.EMPTY_ARRAY == null) {
                BuildView.$$$reportNull$$$0(21);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        StopProcessAction stopAction = null;
        if (this.myBuildDescriptor.getProcessHandler() != null) {
            stopAction = new StopProcessAction(IdeBundle.messagePointer((String)"action.DumbAware.BuildView.text.stop", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.DumbAware.CopyrightProfilesPanel.description.stop", (Object[])new Object[0]), (ProcessHandler)this.myBuildDescriptor.getProcessHandler());
            ActionUtil.copyFrom((AnAction)stopAction, (String)"Stop");
            stopAction.registerCustomShortcutSet(stopAction.getShortcutSet(), (JComponent)this);
        }
        if ((consoleView = this.getConsoleView()) instanceof ConsoleView) {
            consoleView.getComponent();
            if (stopAction == null) {
                AnAction[] consoleActions = ((ConsoleView)consoleView).createConsoleActions();
                stopAction = ContainerUtil.find(consoleActions, StopAction.class::isInstance);
            }
        }
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        for (AnAction anAction : this.myBuildDescriptor.getRestartActions()) {
            rerunActionGroup.add(anAction);
        }
        if (stopAction != null) {
            rerunActionGroup.add((AnAction)stopAction);
        }
        actionGroup2.add((AnAction)rerunActionGroup);
        DefaultActionGroup otherActionGroup = new DefaultActionGroup();
        List<AnAction> otherActions = this.myBuildDescriptor.getActions();
        if (!otherActions.isEmpty()) {
            otherActionGroup.addSeparator();
            for (AnAction anAction : otherActions) {
                otherActionGroup.add(anAction);
            }
            otherActionGroup.addSeparator();
        }
        AnAction[] anActionArray = new AnAction[]{actionGroup2, otherActionGroup};
        if (anActionArray == null) {
            BuildView.$$$reportNull$$$0(22);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.delegateToConsoleView(ConsoleView::allowHeavyFilters);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildView.$$$reportNull$$$0(23);
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this.getConsoleView();
        }
        Object data2 = super.getData(dataId);
        if (data2 != null) {
            return data2;
        }
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            ExecutionEnvironment environment = this.myBuildDescriptor.getExecutionEnvironment();
            return environment == null ? null : environment.getRunProfile();
        }
        if (ExecutionDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myBuildDescriptor.getExecutionEnvironment();
        }
        if (RESTART_ACTIONS.is(dataId)) {
            return this.myBuildDescriptor.getRestartActions();
        }
        return null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.getEventView() != null;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        BuildTreeConsoleView eventView = this.getEventView();
        Predicate<ExecutionNode> predicate2 = eventView == null ? executionNode -> true : eventView.getFilter();
        if (predicate2 == null) {
            BuildView.$$$reportNull$$$0(24);
        }
        return predicate2;
    }

    @Override
    public void addFilter(@NotNull Predicate<? super ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(25);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.addFilter(filter2);
        }
    }

    @Override
    public void removeFilter(@NotNull Predicate<? super ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(26);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.removeFilter(filter2);
        }
    }

    @Override
    public boolean contains(@NotNull Predicate<? super ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(27);
        }
        return (eventView = this.getEventView()) != null && eventView.contains(filter2);
    }

    @NotNull
    private OccurenceNavigator getOccurenceNavigator() {
        BuildTreeConsoleView eventView = this.getEventView();
        if (eventView != null) {
            BuildTreeConsoleView buildTreeConsoleView = eventView;
            if (buildTreeConsoleView == null) {
                BuildView.$$$reportNull$$$0(28);
            }
            return buildTreeConsoleView;
        }
        ExecutionConsole executionConsole = this.getConsoleView();
        if (executionConsole instanceof OccurenceNavigator) {
            OccurenceNavigator occurenceNavigator = (OccurenceNavigator)executionConsole;
            if (occurenceNavigator == null) {
                BuildView.$$$reportNull$$$0(29);
            }
            return occurenceNavigator;
        }
        OccurenceNavigator occurenceNavigator = EMPTY_PROBLEMS_NAVIGATOR;
        if (occurenceNavigator == null) {
            BuildView.$$$reportNull$$$0(30);
        }
        return occurenceNavigator;
    }

    public boolean hasNextOccurence() {
        return this.getOccurenceNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string2 = this.getOccurenceNavigator().getNextOccurenceActionName();
        if (string2 == null) {
            BuildView.$$$reportNull$$$0(31);
        }
        return string2;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string2 = this.getOccurenceNavigator().getPreviousOccurenceActionName();
        if (string2 == null) {
            BuildView.$$$reportNull$$$0(32);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isShowInDashboard() {
        ExecutionEnvironment environment = this.myBuildDescriptor.getExecutionEnvironment();
        RunProfile runProfile = environment != null ? environment.getRunProfile() : null;
        if (!(runProfile instanceof RunConfiguration)) return false;
        RunConfiguration configuration = (RunConfiguration)runProfile;
        if (!RunDashboardManager.getInstance((Project)this.myProject).isShowInDashboard(configuration)) return false;
        if (!(ExecutionManagerImpl.getDelegatedRunProfile((RunProfile)configuration) instanceof RunConfiguration)) return false;
        return true;
    }

    @NotNull
    private static ExecutionConsole wrapWithToolbar(final @NotNull ConsoleView executionConsole) {
        if (executionConsole == null) {
            BuildView.$$$reportNull$$$0(33);
        }
        return new ConsoleViewWrapperBase(executionConsole){
            private final JPanel myPanel;
            {
                super(delegate2);
                this.myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                JComponent baseComponent = this.getDelegate().getComponent();
                this.myPanel.add((Component)baseComponent, "Center");
                DefaultActionGroup actionGroup2 = new DefaultActionGroup(executionConsole.createConsoleActions());
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuildConsole", (ActionGroup)actionGroup2, false);
                toolbar.setTargetComponent(baseComponent);
                this.myPanel.add((Component)toolbar.getComponent(), "East");
            }

            @Override
            @NotNull
            public JComponent getComponent() {
                JPanel jPanel = this.myPanel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/BuildView$2", "getComponent"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 24, 28, 29, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewManager";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBuildEvent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildView";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurenceNavigator";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onStartBuild";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithToolbar";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 21, 22, 24, 28, 29, 30, 31, 32 -> new IllegalStateException(string2);
        };
    }
}

