/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.HighlightingDuplicate;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.build.BuildProgressObservable;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/build/BuildViewProblemsService;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildIdToFileProblems", "", "", "", "Lcom/intellij/build/BuildViewProblemsService$FileBuildProblem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "workingDirToBuildId", "", "dispose", "", "listenToBuildView", "buildProgressObservable", "Lcom/intellij/build/BuildProgressObservable;", "BuildProblemsProvider", "FileBuildProblem", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBuildViewProblemsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildViewProblemsService.kt\ncom/intellij/build/BuildViewProblemsService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n29#2,3:94\n361#3,7:97\n1855#4,2:104\n*S KotlinDebug\n*F\n+ 1 BuildViewProblemsService.kt\ncom/intellij/build/BuildViewProblemsService\n*L\n27#1:94,3\n35#1:97,7\n47#1:104,2\n*E\n"})
public final class BuildViewProblemsService
implements ProblemsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, Object> workingDirToBuildId;
    @NotNull
    private final Map<Object, Set<FileBuildProblem>> buildIdToFileProblems;

    public BuildViewProblemsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.workingDirToBuildId = new LinkedHashMap();
        this.buildIdToFileProblems = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public void dispose() {
        this.buildIdToFileProblems.clear();
        this.workingDirToBuildId.clear();
    }

    public final void listenToBuildView(@NotNull BuildProgressObservable buildProgressObservable) {
        Intrinsics.checkNotNullParameter((Object)buildProgressObservable, (String)"buildProgressObservable");
        ComponentManager $this$service$iv = this.getProject();
        boolean $i$f$service = false;
        Class<ProblemsCollector> serviceClass$iv = ProblemsCollector.class;
        ProblemsCollector problemsCollector = $this$service$iv.getService(serviceClass$iv);
        if (problemsCollector == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ProblemsCollector collector2 = problemsCollector;
        buildProgressObservable.addListener((arg_0, arg_1) -> BuildViewProblemsService.listenToBuildView$lambda$3(this, collector2, arg_0, arg_1), this);
    }

    /*
     * WARNING - void declaration
     */
    private static final void listenToBuildView$lambda$3(BuildViewProblemsService this$0, ProblemsCollector $collector, Object buildId, BuildEvent event) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$collector, (String)"$collector");
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event instanceof FileMessageEvent && ((FileMessageEvent)event).getKind() == MessageEvent.Kind.ERROR) {
                Set problems;
                Object object;
                void $this$getOrPut$iv;
                VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByNioPath(((FileMessageEvent)event).getFilePosition().getFile().toPath());
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile2;
                FileBuildProblem problem = new FileBuildProblem((FileMessageEvent)event, virtualFile3, this$0);
                Map<Object, Set<FileBuildProblem>> map2 = this$0.buildIdToFileProblems;
                Object key$iv = buildId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                if ((problems = (Set)object).add(problem)) {
                    $collector.problemAppeared(problem);
                } else {
                    $collector.problemUpdated(problem);
                }
            }
            if (!(event instanceof StartBuildEvent)) break block9;
            Map<String, Object> map3 = this$0.workingDirToBuildId;
            String string2 = ((StartBuildEvent)event).getBuildDescriptor().getWorkingDir();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.buildDescriptor.workingDir");
            Object object = map3.put(string2, buildId);
            if (object != null) {
                Object oldBuildId = object;
                boolean bl = false;
                Set<FileBuildProblem> set2 = this$0.buildIdToFileProblems.get(oldBuildId);
                if (set2 != null) {
                    Iterable $this$forEach$iv = set2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FileBuildProblem it = (FileBuildProblem)element$iv;
                        boolean bl2 = false;
                        $collector.problemDisappeared(it);
                    }
                }
                this$0.buildIdToFileProblems.remove(oldBuildId);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u000bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/build/BuildViewProblemsService$FileBuildProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "Lcom/intellij/analysis/problemsView/HighlightingDuplicate;", "event", "Lcom/intellij/build/events/FileMessageEvent;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "problemsProvider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "(Lcom/intellij/build/events/FileMessageEvent;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/analysis/problemsView/ProblemsProvider;)V", "column", "", "getColumn", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "getEvent", "()Lcom/intellij/build/events/FileMessageEvent;", "file", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "line", "getLine", "getProblemsProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "provider", "getProvider", "text", "getText", "getVirtualFile", "equals", "", "other", "", "hashCode", "intellij.platform.lang.impl"})
    public static final class FileBuildProblem
    implements FileProblem,
    HighlightingDuplicate {
        @NotNull
        private final FileMessageEvent event;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final ProblemsProvider problemsProvider;

        public FileBuildProblem(@NotNull FileMessageEvent event, @NotNull VirtualFile virtualFile2, @NotNull ProblemsProvider problemsProvider) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)problemsProvider, (String)"problemsProvider");
            this.event = event;
            this.virtualFile = virtualFile2;
            this.problemsProvider = problemsProvider;
        }

        @NotNull
        public final FileMessageEvent getEvent() {
            return this.event;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final ProblemsProvider getProblemsProvider() {
            return this.problemsProvider;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.event.getDescription();
        }

        @Override
        @NotNull
        public VirtualFile getFile() {
            return this.virtualFile;
        }

        @Override
        public int getLine() {
            return this.event.getFilePosition().getStartLine();
        }

        @Override
        public int getColumn() {
            return this.event.getFilePosition().getStartColumn();
        }

        @Override
        @NotNull
        public ProblemsProvider getProvider() {
            return this.problemsProvider;
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.event.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.message");
            return string2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.build.BuildViewProblemsService.FileBuildProblem");
            FileBuildProblem cfr_ignored_0 = (FileBuildProblem)other;
            if (!Intrinsics.areEqual((Object)this.event, (Object)((FileBuildProblem)other).event)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)((FileBuildProblem)other).virtualFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.problemsProvider, (Object)((FileBuildProblem)other).problemsProvider);
        }

        public int hashCode() {
            int result2 = this.event.hashCode();
            result2 = 31 * result2 + this.virtualFile.hashCode();
            result2 = 31 * result2 + this.problemsProvider.hashCode();
            return result2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/build/BuildViewProblemsService$BuildProblemsProvider;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    public static final class BuildProblemsProvider
    implements ProblemsProvider {
        @NotNull
        private final Project project;

        public BuildProblemsProvider(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }
    }
}

