/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBuildDescriptor
implements BuildDescriptor {
    private final Object myId;
    private final Object myGroupId;
    private final @BuildEventsNls.Title String myTitle;
    private final String myWorkingDir;
    private final long myStartTime;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myActivateToolWindowWhenFailed;
    @NotNull
    private ThreeState myNavigateToError;
    private boolean myAutoFocusContent;
    @NotNull
    private final List<AnAction> myActions;
    @NotNull
    private final List<AnAction> myRestartActions;
    @NotNull
    private final List<Filter> myExecutionFilters;
    @NotNull
    private final List<Function<? super ExecutionNode, ? extends AnAction>> myContextActions;
    @Nullable
    private BuildProcessHandler myProcessHandler;
    private Consumer<? super ConsoleView> myAttachedConsoleConsumer;
    @Nullable
    private ExecutionEnvironment myExecutionEnvironment;
    private Supplier<? extends RunContentDescriptor> myContentDescriptorSupplier;

    public DefaultBuildDescriptor(@NotNull Object id, @NotNull @BuildEventsNls.Title String title, @NotNull String workingDir, long startTime) {
        if (id == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(0);
        }
        if (title == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(2);
        }
        this(id, null, title, workingDir, startTime);
    }

    public DefaultBuildDescriptor(@NotNull Object id, @Nullable Object groupId, @NotNull @BuildEventsNls.Title String title, @NotNull String workingDir, long startTime) {
        if (id == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(3);
        }
        if (title == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(4);
        }
        if (workingDir == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(5);
        }
        this.myActivateToolWindowWhenAdded = false;
        this.myActivateToolWindowWhenFailed = true;
        this.myNavigateToError = ThreeState.UNSURE;
        this.myAutoFocusContent = false;
        this.myActions = new SmartList<AnAction>();
        this.myRestartActions = new SmartList<AnAction>();
        this.myExecutionFilters = new SmartList<Filter>();
        this.myContextActions = new SmartList<Function<? super ExecutionNode, ? extends AnAction>>();
        this.myId = id;
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myWorkingDir = workingDir;
        this.myStartTime = startTime;
    }

    public DefaultBuildDescriptor(@NotNull BuildDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(6);
        }
        this(descriptor2.getId(), descriptor2.getGroupId(), descriptor2.getTitle(), descriptor2.getWorkingDir(), descriptor2.getStartTime());
        if (descriptor2 instanceof DefaultBuildDescriptor) {
            DefaultBuildDescriptor defaultBuildDescriptor = (DefaultBuildDescriptor)descriptor2;
            this.myActivateToolWindowWhenAdded = defaultBuildDescriptor.myActivateToolWindowWhenAdded;
            this.myActivateToolWindowWhenFailed = defaultBuildDescriptor.myActivateToolWindowWhenFailed;
            this.myAutoFocusContent = defaultBuildDescriptor.myAutoFocusContent;
            defaultBuildDescriptor.myRestartActions.forEach(this::withRestartAction);
            defaultBuildDescriptor.myActions.forEach(this::withAction);
            defaultBuildDescriptor.myExecutionFilters.forEach(this::withExecutionFilter);
            defaultBuildDescriptor.myContextActions.forEach(this::withContextAction);
            this.myContentDescriptorSupplier = defaultBuildDescriptor.myContentDescriptorSupplier;
            this.myExecutionEnvironment = defaultBuildDescriptor.myExecutionEnvironment;
            this.myProcessHandler = defaultBuildDescriptor.myProcessHandler;
            this.myAttachedConsoleConsumer = defaultBuildDescriptor.myAttachedConsoleConsumer;
        }
    }

    @Override
    @NotNull
    public Object getId() {
        Object object = this.myId;
        if (object == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(7);
        }
        return object;
    }

    @Override
    public Object getGroupId() {
        return this.myGroupId;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string2 = this.myTitle;
        if (string2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getWorkingDir() {
        String string2 = this.myWorkingDir;
        if (string2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    public long getStartTime() {
        return this.myStartTime;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getActions() {
        List<AnAction> list2 = Collections.unmodifiableList(this.myActions);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getRestartActions() {
        List<AnAction> list2 = Collections.unmodifiableList(this.myRestartActions);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getContextActions(@NotNull ExecutionNode node2) {
        if (node2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(12);
        }
        List<AnAction> list2 = ContainerUtil.map(this.myContextActions, function -> (AnAction)function.apply(node2));
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<Filter> getExecutionFilters() {
        List<Filter> list2 = Collections.unmodifiableList(this.myExecutionFilters);
        if (list2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isActivateToolWindowWhenFailed() {
        return this.myActivateToolWindowWhenFailed;
    }

    public void setActivateToolWindowWhenFailed(boolean activateToolWindowWhenFailed) {
        this.myActivateToolWindowWhenFailed = activateToolWindowWhenFailed;
    }

    @NotNull
    public ThreeState isNavigateToError() {
        ThreeState threeState = this.myNavigateToError;
        if (threeState == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(15);
        }
        return threeState;
    }

    public void setNavigateToError(@NotNull ThreeState navigateToError) {
        if (navigateToError == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(16);
        }
        this.myNavigateToError = navigateToError;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public BuildProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    @Nullable
    public Supplier<? extends RunContentDescriptor> getContentDescriptorSupplier() {
        return this.myContentDescriptorSupplier;
    }

    public Consumer<? super ConsoleView> getAttachedConsoleConsumer() {
        return this.myAttachedConsoleConsumer;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withAction(@NotNull AnAction action2) {
        if (action2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(17);
        }
        this.myActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withActions(AnAction ... actions) {
        if (actions == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(18);
        }
        this.myActions.addAll(Arrays.asList(actions));
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartAction(@NotNull AnAction action2) {
        if (action2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(19);
        }
        this.myRestartActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartActions(AnAction ... actions) {
        if (actions == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(20);
        }
        this.myRestartActions.addAll(Arrays.asList(actions));
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextAction(Function<? super ExecutionNode, ? extends AnAction> contextAction) {
        this.myContextActions.add(contextAction);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextActions(AnAction ... actions) {
        if (actions == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(21);
        }
        for (AnAction action2 : actions) {
            this.myContextActions.add(node2 -> action2);
        }
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withExecutionFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            DefaultBuildDescriptor.$$$reportNull$$$0(22);
        }
        this.myExecutionFilters.add(filter2);
        return this;
    }

    public DefaultBuildDescriptor withContentDescriptor(Supplier<? extends RunContentDescriptor> contentDescriptorSupplier) {
        this.myContentDescriptorSupplier = contentDescriptorSupplier;
        return this;
    }

    public DefaultBuildDescriptor withProcessHandler(@Nullable BuildProcessHandler processHandler, @Nullable Consumer<? super ConsoleView> attachedConsoleConsumer) {
        this.myProcessHandler = processHandler;
        this.myAttachedConsoleConsumer = attachedConsoleConsumer;
        return this;
    }

    public DefaultBuildDescriptor withExecutionEnvironment(@Nullable ExecutionEnvironment env) {
        this.myExecutionEnvironment = env;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/DefaultBuildDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateToError";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/DefaultBuildDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionFilters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "isNavigateToError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateToError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withActions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withRestartAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withRestartActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withContextActions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionFilter";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9, 10, 11, 13, 14, 15 -> new IllegalStateException(string2);
        };
    }
}

