/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.BuildEventPresentationData;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends PresentableNodeDescriptor<ExecutionNode> {
    private static final Icon NODE_ICON_OK = AllIcons.RunConfigurations.TestPassed;
    private static final Icon NODE_ICON_ERROR = AllIcons.RunConfigurations.TestError;
    private static final Icon NODE_ICON_WARNING = AllIcons.General.Warning;
    private static final Icon NODE_ICON_INFO = AllIcons.General.Information;
    private static final Icon NODE_ICON_SKIPPED = AllIcons.RunConfigurations.TestIgnored;
    private static final Icon NODE_ICON_STATISTICS = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_SIMPLE = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_DEFAULT = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_RUNNING = new AnimatedIcon.Default();
    private final List<ExecutionNode> myChildrenList;
    private List<ExecutionNode> myVisibleChildrenList;
    private final AtomicInteger myErrors;
    private final AtomicInteger myWarnings;
    private final AtomicInteger myInfos;
    private final ExecutionNode myParentNode;
    private volatile long startTime;
    private volatile long endTime;
    @Nullable
    private @BuildEventsNls.Title String myTitle;
    @Nullable
    private @BuildEventsNls.Hint String myHint;
    @NotNull
    private final HintData myHintData;
    @Nullable
    private volatile EventResult myResult;
    private final boolean myAutoExpandNode;
    private final Supplier<Boolean> myIsCorrectThread;
    @Nullable
    private volatile Navigatable myNavigatable;
    @Nullable
    private volatile NullableLazyValue<Icon> myPreferredIconValue;
    private Predicate<? super ExecutionNode> myFilter;
    private boolean myAlwaysLeaf;
    private boolean myAlwaysVisible;

    public ExecutionNode(Project aProject, ExecutionNode parentNode, boolean isAutoExpandNode, @NotNull Supplier<Boolean> isCorrectThread) {
        if (isCorrectThread == null) {
            ExecutionNode.$$$reportNull$$$0(0);
        }
        super(aProject, (NodeDescriptor)parentNode);
        this.myChildrenList = new ArrayList<ExecutionNode>();
        this.myVisibleChildrenList = null;
        this.myErrors = new AtomicInteger();
        this.myWarnings = new AtomicInteger();
        this.myInfos = new AtomicInteger();
        this.myName = "";
        this.myParentNode = parentNode;
        this.myAutoExpandNode = isAutoExpandNode;
        this.myIsCorrectThread = isCorrectThread;
        this.myHintData = new HintData();
    }

    private boolean nodeIsVisible(ExecutionNode node2) {
        return node2.myAlwaysVisible || this.myFilter == null || this.myFilter.test(node2);
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ExecutionNode.$$$reportNull$$$0(1);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        this.setIcon(this.getCurrentIcon());
        presentation2.setPresentableText(this.myName);
        presentation2.setIcon(this.getIcon());
        if (StringUtil.isNotEmpty(this.myTitle)) {
            presentation2.addText(this.myTitle + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        Object hint = this.myHintData.getCurrentHint(this);
        boolean isNotEmptyName = StringUtil.isNotEmpty(this.myName);
        if (isNotEmptyName && this.myTitle != null || hint != null) {
            presentation2.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (StringUtil.isNotEmpty((String)hint)) {
            if (isNotEmptyName) {
                hint = " " + (String)hint;
            }
            presentation2.addText((String)hint, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @ApiStatus.Internal
    void applyFrom(@NotNull BuildEventPresentationData buildEventPresentationData) {
        if (buildEventPresentationData == null) {
            ExecutionNode.$$$reportNull$$$0(2);
        }
        this.myAlwaysVisible = true;
        this.setIconProvider(() -> buildEventPresentationData.getNodeIcon());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myName = name;
    }

    @Nullable
    public String getTitle() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myTitle;
    }

    public void setTitle(@BuildEventsNls.Title @Nullable String title) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myTitle = title;
    }

    public void setHint(@BuildEventsNls.Hint @Nullable String hint) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myHint = hint;
    }

    public void add(@NotNull ExecutionNode node2) {
        if (node2 == null) {
            ExecutionNode.$$$reportNull$$$0(3);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myChildrenList.add(node2);
        node2.setFilter(this.myFilter);
        if (this.myVisibleChildrenList != null && this.nodeIsVisible(node2)) {
            this.myVisibleChildrenList.add(node2);
        }
    }

    void removeChildren() {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myChildrenList.clear();
        if (this.myVisibleChildrenList != null) {
            this.myVisibleChildrenList.clear();
        }
        this.myErrors.set(0);
        this.myWarnings.set(0);
        this.myInfos.set(0);
        this.myResult = null;
    }

    @Nullable
    @Nls
    public String getDuration() {
        if (this.startTime == this.endTime) {
            return null;
        }
        if (this.isRunning()) {
            long duration;
            long l = duration = this.startTime == 0L ? 0L : System.currentTimeMillis() - this.startTime;
            if (duration > 1000L) {
                duration -= duration % 1000L;
            }
            return NlsMessages.formatDurationApproximate((long)duration);
        }
        return ExecutionNode.isSkipped(this.myResult) ? null : NlsMessages.formatDuration((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.startTime = startTime;
    }

    public long getEndTime() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.endTime;
    }

    public ExecutionNode setEndTime(long endTime) {
        return this.setEndTime(endTime, true);
    }

    @Nullable
    @ApiStatus.Internal
    ExecutionNode setEndTime(long endTime, boolean reapplyParentFilterIfRequired) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.endTime = endTime;
        return reapplyParentFilterIfRequired ? this.reapplyParentFilterIfRequired(null) : null;
    }

    private ExecutionNode reapplyParentFilterIfRequired(@Nullable ExecutionNode result2) {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (this.myParentNode != null) {
            List<ExecutionNode> parentVisibleChildrenList = this.myParentNode.myVisibleChildrenList;
            if (parentVisibleChildrenList != null) {
                Predicate<? super ExecutionNode> filter2 = this.myParentNode.myFilter;
                if (this.myAlwaysVisible || filter2 != null) {
                    boolean shouldBePresent;
                    boolean wasPresent = parentVisibleChildrenList.contains((Object)this);
                    boolean bl = shouldBePresent = this.myAlwaysVisible || filter2.test(this);
                    if (shouldBePresent != wasPresent) {
                        if (shouldBePresent) {
                            this.myParentNode.maybeReapplyFilter();
                        } else {
                            parentVisibleChildrenList.remove((Object)this);
                        }
                        result2 = this.myParentNode;
                    }
                }
            }
            return this.myParentNode.reapplyParentFilterIfRequired(result2);
        }
        return result2;
    }

    @NotNull
    public List<ExecutionNode> getChildList() {
        assert (this.myIsCorrectThread.get().booleanValue());
        List<ExecutionNode> visibleList = this.myVisibleChildrenList;
        List<ExecutionNode> list2 = Objects.requireNonNullElse(visibleList, this.myChildrenList);
        if (list2 == null) {
            ExecutionNode.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    public ExecutionNode getParent() {
        return this.myParentNode;
    }

    public ExecutionNode getElement() {
        return this;
    }

    public Predicate<? super ExecutionNode> getFilter() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myFilter;
    }

    public void setFilter(@Nullable Predicate<? super ExecutionNode> filter2) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myFilter = filter2;
        for (ExecutionNode node2 : this.myChildrenList) {
            node2.setFilter(this.myFilter);
        }
        if (filter2 == null) {
            this.myVisibleChildrenList = null;
        } else {
            if (this.myVisibleChildrenList == null) {
                this.myVisibleChildrenList = Collections.synchronizedList(new ArrayList());
            }
            this.maybeReapplyFilter();
        }
    }

    private void maybeReapplyFilter() {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (this.myVisibleChildrenList != null) {
            this.myVisibleChildrenList.clear();
            this.myChildrenList.stream().filter(it -> this.nodeIsVisible((ExecutionNode)((Object)it))).forEachOrdered(this.myVisibleChildrenList::add);
        }
    }

    public boolean isRunning() {
        return this.endTime <= 0L && !ExecutionNode.isSkipped(this.myResult) && !ExecutionNode.isFailed(this.myResult);
    }

    public boolean hasWarnings() {
        return this.myWarnings.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.WARNING;
    }

    public boolean hasInfos() {
        return this.myInfos.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.INFO;
    }

    public boolean isFailed() {
        return ExecutionNode.isFailed(this.myResult) || this.myErrors.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.ERROR;
    }

    @Nullable
    public EventResult getResult() {
        return this.myResult;
    }

    public ExecutionNode setResult(@Nullable EventResult result2) {
        return this.setResult(result2, true);
    }

    @ApiStatus.Internal
    ExecutionNode setResult(@Nullable EventResult result2, boolean reapplyParentFilterIfRequired) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myResult = result2;
        return reapplyParentFilterIfRequired ? this.reapplyParentFilterIfRequired(null) : null;
    }

    public boolean isAutoExpandNode() {
        return this.myAutoExpandNode;
    }

    @ApiStatus.Experimental
    public boolean isAlwaysLeaf() {
        return this.myAlwaysLeaf;
    }

    @ApiStatus.Experimental
    public void setAlwaysLeaf(boolean alwaysLeaf) {
        this.myAlwaysLeaf = alwaysLeaf;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myNavigatable = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.myNavigatable != null) {
            List<Navigatable> list2 = Collections.singletonList(this.myNavigatable);
            if (list2 == null) {
                ExecutionNode.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (this.myResult == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.$$$reportNull$$$0(6);
            }
            return list3;
        }
        if (this.myResult instanceof FailureResult) {
            SmartList<Navigatable> result2 = new SmartList<Navigatable>();
            for (Failure failure : ((FailureResult)this.myResult).getFailures()) {
                ContainerUtil.addIfNotNull(result2, failure.getNavigatable());
            }
            SmartList<Navigatable> smartList = result2;
            if (smartList == null) {
                ExecutionNode.$$$reportNull$$$0(7);
            }
            return smartList;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.$$$reportNull$$$0(8);
        }
        return list4;
    }

    public void setIconProvider(final @NotNull Supplier<? extends Icon> iconProvider) {
        if (iconProvider == null) {
            ExecutionNode.$$$reportNull$$$0(9);
        }
        this.myPreferredIconValue = new NullableLazyValue<Icon>(){

            @Override
            @Nullable
            protected Icon compute() {
                return (Icon)iconProvider.get();
            }
        };
    }

    @Nullable
    public ExecutionNode reportChildMessageKind(MessageEvent.Kind kind) {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (kind == MessageEvent.Kind.ERROR) {
            this.myErrors.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.myWarnings.incrementAndGet();
        } else if (kind == MessageEvent.Kind.INFO) {
            this.myInfos.incrementAndGet();
        }
        return this.reapplyParentFilterIfRequired(null);
    }

    @Nullable
    @ApiStatus.Experimental
    ExecutionNode findFirstChild(@NotNull Predicate<? super ExecutionNode> filter2) {
        if (filter2 == null) {
            ExecutionNode.$$$reportNull$$$0(10);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myChildrenList.stream().filter(filter2).findFirst().orElse(null);
    }

    private Icon getCurrentIcon() {
        if (this.myPreferredIconValue != null) {
            return this.myPreferredIconValue.getValue();
        }
        if (this.myResult instanceof MessageEventResult) {
            return ExecutionNode.getIcon(((MessageEventResult)this.myResult).getKind());
        }
        return this.isRunning() ? NODE_ICON_RUNNING : (ExecutionNode.isFailed(this.myResult) ? NODE_ICON_ERROR : (ExecutionNode.isSkipped(this.myResult) ? NODE_ICON_SKIPPED : (this.myErrors.get() > 0 ? NODE_ICON_ERROR : (this.myWarnings.get() > 0 ? NODE_ICON_WARNING : NODE_ICON_OK))));
    }

    public static boolean isFailed(@Nullable EventResult result2) {
        return result2 instanceof FailureResult;
    }

    public static boolean isSkipped(@Nullable EventResult result2) {
        return result2 instanceof SkippedResult;
    }

    public static Icon getEventResultIcon(@Nullable EventResult result2) {
        if (result2 == null) {
            return NODE_ICON_RUNNING;
        }
        if (result2 instanceof MessageEventResult) {
            return ExecutionNode.getIcon(((MessageEventResult)result2).getKind());
        }
        if (ExecutionNode.isFailed(result2)) {
            return NODE_ICON_ERROR;
        }
        if (ExecutionNode.isSkipped(result2)) {
            return NODE_ICON_SKIPPED;
        }
        return NODE_ICON_OK;
    }

    private static Icon getIcon(MessageEvent.Kind kind) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case MessageEvent.Kind.ERROR -> NODE_ICON_ERROR;
            case MessageEvent.Kind.WARNING -> NODE_ICON_WARNING;
            case MessageEvent.Kind.INFO -> NODE_ICON_INFO;
            case MessageEvent.Kind.STATISTICS -> NODE_ICON_STATISTICS;
            case MessageEvent.Kind.SIMPLE -> NODE_ICON_SIMPLE;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCorrectThread";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEventPresentationData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/ExecutionNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/ExecutionNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIconProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFirstChild";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string2);
        };
    }

    private static class HintData {
        private int myErrors;
        private int myWarnings;
        private boolean isRunning;
        @Nullable
        private @BuildEventsNls.Hint String myHint;
        @Nullable
        private @BuildEventsNls.Hint String myCurrentHint;

        private HintData() {
        }

        private @BuildEventsNls.Hint String getCurrentHint(@NotNull ExecutionNode node2) {
            if (node2 == null) {
                HintData.$$$reportNull$$$0(0);
            }
            if (!this.idUpToDate(node2)) {
                this.myHint = node2.myHint;
                this.myErrors = node2.myErrors.get();
                this.myWarnings = node2.myWarnings.get();
                this.isRunning = node2.isRunning();
                this.myCurrentHint = this.calculateCurrentHint(node2);
            }
            return this.myCurrentHint;
        }

        private boolean idUpToDate(@NotNull ExecutionNode node2) {
            if (node2 == null) {
                HintData.$$$reportNull$$$0(1);
            }
            if (!Objects.equals(this.myHint, node2.myHint)) {
                return false;
            }
            if (this.myErrors != node2.myErrors.get()) {
                return false;
            }
            if (this.myWarnings != node2.myWarnings.get()) {
                return false;
            }
            return this.isRunning == node2.isRunning();
        }

        private @BuildEventsNls.Hint String calculateCurrentHint(@NotNull ExecutionNode node2) {
            if (node2 == null) {
                HintData.$$$reportNull$$$0(2);
            }
            assert (node2.myIsCorrectThread.get().booleanValue());
            if (this.myWarnings > 0 || this.myErrors > 0) {
                String errorHint = this.myErrors > 0 ? LangBundle.message("build.event.message.errors", this.myErrors) : "";
                String warningHint = this.myWarnings > 0 ? LangBundle.message("build.event.message.warnings", this.myWarnings) : "";
                String issuesHint = !errorHint.isEmpty() && !warningHint.isEmpty() ? errorHint + ", " + warningHint : errorHint + warningHint;
                ExecutionNode parent2 = node2.getParent();
                if (parent2 == null || parent2.getParent() == null) {
                    if (node2.isRunning()) {
                        return StringUtil.notNullize(this.myHint) + "  " + issuesHint;
                    }
                    return LangBundle.message("build.event.message.with", StringUtil.notNullize(this.myHint), issuesHint);
                }
                return StringUtil.notNullize(this.myHint) + " " + issuesHint;
            }
            return this.myHint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/intellij/build/ExecutionNode$HintData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentHint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "idUpToDate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateCurrentHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

