/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<OpenFileDescriptor> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(@NotNull Project project2, @NotNull FilePosition filePosition) {
        if (project2 == null) {
            FileNavigatable.$$$reportNull$$$0(0);
        }
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<OpenFileDescriptor>(){

            @Override
            @Nullable
            protected OpenFileDescriptor compute() {
                return FileNavigatable.this.createDescriptor();
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigate();
        }
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        OpenFileDescriptor descriptor2 = this.getFileDescriptor();
        if (descriptor2 != null) {
            return descriptor2.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    public OpenFileDescriptor getFileDescriptor() {
        return this.myValue.getValue();
    }

    @NotNull
    public FilePosition getFilePosition() {
        FilePosition filePosition = this.myFilePosition;
        if (filePosition == null) {
            FileNavigatable.$$$reportNull$$$0(2);
        }
        return filePosition;
    }

    @Nullable
    private OpenFileDescriptor createDescriptor() {
        OpenFileDescriptor descriptor2 = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile(this.myFilePosition.getFile(), false);
        if (file2 != null) {
            descriptor2 = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePosition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/FileNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/FileNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

