/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNode;
import com.intellij.build.Filterable;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B=\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/build/FilterToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "text", "", "stateKey", "filterable", "Lcom/intellij/build/Filterable;", "Lcom/intellij/build/ExecutionNode;", "filter", "Ljava/util/function/Predicate;", "defaultState", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/build/Filterable;Ljava/util/function/Predicate;Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public class FilterToggleAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String stateKey;
    @NotNull
    private final Filterable<ExecutionNode> filterable;
    @NotNull
    private final Predicate<ExecutionNode> filter;
    private final boolean defaultState;

    public FilterToggleAction(@NlsContexts.Command @NotNull String text2, @Nullable String stateKey, @NotNull Filterable<ExecutionNode> filterable, @NotNull Predicate<ExecutionNode> filter2, boolean defaultState) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(filterable, (String)"filterable");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        super(text2);
        this.stateKey = stateKey;
        this.filterable = filterable;
        this.filter = filter2;
        this.defaultState = defaultState;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        boolean filteringEnabled = this.filterable.isFilteringEnabled();
        presentation3.setEnabledAndVisible(filteringEnabled);
        if (filteringEnabled && this.stateKey != null && PropertiesComponent.getInstance().getBoolean(this.stateKey, this.defaultState) && !this.filterable.contains(this.filter)) {
            this.setSelected(e, true);
        }
        return this.filterable.contains(this.filter);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (state) {
            this.filterable.addFilter(this.filter);
        } else {
            this.filterable.removeFilter(this.filter);
        }
        if (this.stateKey != null) {
            PropertiesComponent.getInstance().setValue(this.stateKey, state, this.defaultState);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/build/FilterToggleAction$Companion;", "", "()V", "install", "", "filterable", "Lcom/intellij/build/Filterable;", "Lcom/intellij/build/ExecutionNode;", "filter", "Ljava/util/function/Predicate;", "stateKey", "", "defaultState", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Filterable<ExecutionNode> filterable, @NotNull Predicate<ExecutionNode> filter2, @NotNull String stateKey, boolean defaultState) {
            Intrinsics.checkNotNullParameter(filterable, (String)"filterable");
            Intrinsics.checkNotNullParameter(filter2, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)stateKey, (String)"stateKey");
            if (PropertiesComponent.getInstance().getBoolean(stateKey, defaultState) && !filterable.contains(filter2)) {
                filterable.addFilter(filter2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

