/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/build/issue/quickfix/OpenFileQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "path", "Ljava/nio/file/Path;", "search", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class OpenFileQuickFix
implements BuildIssueQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @Nullable
    private final String search;

    public OpenFileQuickFix(@NotNull Path path2, @Nullable String search2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
        this.search = search2;
    }

    @Override
    @NotNull
    public String getId() {
        return ((Object)this.path).toString();
    }

    @Override
    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project2, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        CompletableFuture future = new CompletableFuture();
        ApplicationManager.getApplication().invokeLater(() -> OpenFileQuickFix.runQuickFix$lambda$0(project2, this, future));
        return future;
    }

    private static final void runQuickFix$lambda$0(Project $project, OpenFileQuickFix this$0, CompletableFuture $future) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        try {
            Companion.showFile($project, this$0.path, this$0.search);
            $future.complete(null);
        }
        catch (Exception e) {
            $future.completeExceptionally(e);
        }
    }

    @JvmStatic
    public static final void showFile(@NotNull Project project2, @NotNull Path path2, @Nullable String search2) {
        Companion.showFile(project2, path2, search2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/build/issue/quickfix/OpenFileQuickFix$Companion;", "", "()V", "showFile", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "search", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nOpenFileQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFileQuickFix.kt\ncom/intellij/build/issue/quickfix/OpenFileQuickFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void showFile(@NotNull Project project2, @NotNull Path path2, @Nullable String search2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            ApplicationManager.getApplication().invokeLater(() -> Companion.showFile$lambda$1(path2, project2, search2));
        }

        private static final void showFile$lambda$1(Path $path, Project $project, String $search) {
            FindModel findModel;
            Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile($path.toFile(), false);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile file2 = virtualFile2;
            Editor editor2 = FileEditorManager.getInstance($project).openTextEditor(new OpenFileDescriptor($project, file2), false);
            if ($search == null || editor2 == null) {
                return;
            }
            FindModel $this$showFile_u24lambda_u241_u24lambda_u240 = findModel = new FindModel();
            boolean bl = false;
            FindModel.initStringToFind((FindModel)$this$showFile_u24lambda_u241_u24lambda_u240, (String)$search);
            FindModel findModel2 = findModel;
            FindResult findResult = FindManager.getInstance((Project)$project).findString(editor2.getDocument().getCharsSequence(), 0, findModel2, file2);
            Intrinsics.checkNotNullExpressionValue((Object)findResult, (String)"getInstance(project).fin\u2026ence, 0, findModel, file)");
            FindResult findResult2 = findResult;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)$project);
            HighlightUsagesHandler.highlightRanges(highlightManager, editor2, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, (List<? extends TextRange>)CollectionsKt.listOf((Object)findResult2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

