/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.build.output.LineProcessor;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\b\u000e*\u0001\u0012\b\u0016\u0018\u0000 72\u00020\u00012\u00020\u00022\u00060\u0003j\u0002`\u0004:\u000267BA\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*H\u0016J \u0010&\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eH\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010/\u001a\u00020\u0019H\u0007J\u0014\u00100\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u00101\u001a\u00020%H\u0002J\b\u00102\u001a\u00020\u0006H\u0016J\b\u00103\u001a\u00020\u0019H\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u000eH\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0016H\u0016R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/build/output/BuildOutputInstantReaderImpl;", "Lcom/intellij/build/output/BuildOutputInstantReader;", "Ljava/io/Closeable;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "buildId", "", "parentEventId", "buildProgressListener", "Lcom/intellij/build/BuildProgressListener;", "parsers", "", "Lcom/intellij/build/output/BuildOutputParser;", "pushBackBufferSize", "", "channelBufferCapacity", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/build/BuildProgressListener;Ljava/util/List;II)V", "appendedLineProcessor", "com/intellij/build/output/BuildOutputInstantReaderImpl$appendedLineProcessor$1", "Lcom/intellij/build/output/BuildOutputInstantReaderImpl$appendedLineProcessor$1;", "channel", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "readFinishedFuture", "Ljava/util/concurrent/CompletableFuture;", "", "readLinesBuffer", "Ljava/util/LinkedList;", "readLinesBufferPosition", "readerRunnable", "Ljava/lang/Runnable;", "Lorg/jetbrains/annotations/NotNull;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/build/output/BuildOutputInstantReaderImpl$Companion$State;", "kotlin.jvm.PlatformType", "useActiveReading", "", "append", "c", "", "csq", "", "start", "end", "close", "closeAndGetFuture", "disableActiveReading", "doReadLine", "waitIfNotClosed", "getParentEventId", "pushBack", "numberOfLines", "readLine", "BuildOutputInstantReaderWrapper", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBuildOutputInstantReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputInstantReaderImpl.kt\ncom/intellij/build/output/BuildOutputInstantReaderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,226:1\n1#2:227\n10#3:228\n*S KotlinDebug\n*F\n+ 1 BuildOutputInstantReaderImpl.kt\ncom/intellij/build/output/BuildOutputInstantReaderImpl\n*L\n196#1:228\n*E\n"})
public class BuildOutputInstantReaderImpl
implements BuildOutputInstantReader,
Closeable,
Appendable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object buildId;
    @NotNull
    private final Object parentEventId;
    private final int pushBackBufferSize;
    @NotNull
    private final LinkedBlockingQueue<String> channel;
    @NotNull
    private final LinkedList<String> readLinesBuffer;
    private int readLinesBufferPosition;
    @NotNull
    private final AtomicReference<Companion.State> state;
    private volatile boolean useActiveReading;
    @NotNull
    private CompletableFuture<Unit> readFinishedFuture;
    @NotNull
    private final Runnable readerRunnable;
    @NotNull
    private final appendedLineProcessor.1 appendedLineProcessor;
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    public BuildOutputInstantReaderImpl(@NotNull Object buildId, @NotNull Object parentEventId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<? extends BuildOutputParser> parsers, int pushBackBufferSize, int channelBufferCapacity) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
        Intrinsics.checkNotNullParameter(parsers, (String)"parsers");
        this.buildId = buildId;
        this.parentEventId = parentEventId;
        this.pushBackBufferSize = pushBackBufferSize;
        this.channel = new LinkedBlockingQueue(channelBufferCapacity);
        this.readLinesBuffer = new LinkedList();
        this.readLinesBufferPosition = -1;
        this.state = new AtomicReference<Companion.State>(Companion.State.Idle);
        this.useActiveReading = true;
        this.readFinishedFuture = new CompletableFuture();
        Object[] objectArray = new Object[]{System.identityHashCode(this.parentEventId)};
        Runnable runnable = ConcurrencyUtil.underThreadNameRunnable(LangBundle.message("thread.name.reader.thread.for.buildoutputinstantreaderimpl.0", objectArray), () -> BuildOutputInstantReaderImpl.readerRunnable$lambda$2(this, parsers, buildProgressListener));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"underThreadNameRunnable(\u2026e(Unit)\n      }\n    }\n  }");
        this.readerRunnable = runnable;
        this.appendedLineProcessor = new LineProcessor(this){
            final /* synthetic */ BuildOutputInstantReaderImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void process(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (!(BuildOutputInstantReaderImpl.access$getState$p(this.this$0).get() != Companion.State.Closed)) {
                    boolean bl = false;
                    Object[] objectArray = new Object[]{line};
                    String string2 = LangBundle.message("error.can.t.append.to.closed.stream", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"error.can.t.app\u2026.to.closed.stream\", line)");
                    String string3 = string2;
                    throw new IllegalArgumentException(string3.toString());
                }
                try {
                    while (BuildOutputInstantReaderImpl.access$getState$p(this.this$0).get() != Companion.State.Closed) {
                        if (BuildOutputInstantReaderImpl.access$getState$p(this.this$0).compareAndSet(Companion.State.Idle, Companion.State.Running)) {
                            ProcessIOExecutorService.INSTANCE.submit(BuildOutputInstantReaderImpl.access$getReaderRunnable$p(this.this$0));
                        }
                        if (!BuildOutputInstantReaderImpl.access$getChannel$p(this.this$0).offer(line, 100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public /* synthetic */ BuildOutputInstantReaderImpl(Object object, Object object2, BuildProgressListener buildProgressListener, List list2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 50;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 64;
        }
        this(object, object2, buildProgressListener, list2, n, n2);
    }

    @Override
    @NotNull
    public Object getParentEventId() {
        return this.parentEventId;
    }

    @Override
    @NotNull
    public BuildOutputInstantReaderImpl append(@NotNull CharSequence csq) {
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        this.appendedLineProcessor.append(csq);
        return this;
    }

    @Override
    @NotNull
    public BuildOutputInstantReaderImpl append(@NotNull CharSequence csq, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        this.appendedLineProcessor.append(csq, start, end);
        return this;
    }

    @Override
    @NotNull
    public BuildOutputInstantReaderImpl append(char c2) {
        this.appendedLineProcessor.append(c2);
        return this;
    }

    @Override
    public void close() {
        this.closeAndGetFuture();
    }

    @NotNull
    public CompletableFuture<Unit> closeAndGetFuture() {
        if (this.state.get() == Companion.State.Closed) {
            return this.readFinishedFuture;
        }
        if (this.state.compareAndSet(Companion.State.Idle, Companion.State.Closed)) {
            this.readFinishedFuture.complete(Unit.INSTANCE);
        } else {
            this.state.set(Companion.State.Closed);
        }
        return this.readFinishedFuture;
    }

    @Override
    @Nullable
    public String readLine() {
        return BuildOutputInstantReaderImpl.doReadLine$default(this, false, 1, null);
    }

    private final String doReadLine(boolean waitIfNotClosed) {
        if (this.readLinesBufferPosition >= 0) {
            String string2;
            String it = string2 = this.readLinesBuffer.get(this.readLinesBufferPosition);
            boolean bl = false;
            int n = this.readLinesBufferPosition;
            this.readLinesBufferPosition = n + -1;
            return string2;
        }
        String line = null;
        while ((line = this.channel.poll(100L, TimeUnit.MILLISECONDS)) == null && this.state.get() != Companion.State.Closed) {
            if (waitIfNotClosed) continue;
            return null;
        }
        if (line == null) {
            return null;
        }
        this.readLinesBuffer.addFirst(line);
        if (this.readLinesBuffer.size() > this.pushBackBufferSize) {
            this.readLinesBuffer.removeLast();
        }
        return line;
    }

    static /* synthetic */ String doReadLine$default(BuildOutputInstantReaderImpl buildOutputInstantReaderImpl, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doReadLine");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return buildOutputInstantReaderImpl.doReadLine(bl);
    }

    @Override
    public void pushBack() {
        this.pushBack(1);
    }

    @Override
    public void pushBack(int numberOfLines) {
        this.readLinesBufferPosition += numberOfLines;
        if (this.readLinesBufferPosition >= this.pushBackBufferSize) {
            this.readLinesBufferPosition = this.pushBackBufferSize - 1;
        }
    }

    @ApiStatus.Experimental
    public final void disableActiveReading() {
        this.useActiveReading = false;
    }

    @JvmOverloads
    public BuildOutputInstantReaderImpl(@NotNull Object buildId, @NotNull Object parentEventId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<? extends BuildOutputParser> parsers, int pushBackBufferSize) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
        Intrinsics.checkNotNullParameter(parsers, (String)"parsers");
        this(buildId, parentEventId, buildProgressListener, parsers, pushBackBufferSize, 0, 32, null);
    }

    @JvmOverloads
    public BuildOutputInstantReaderImpl(@NotNull Object buildId, @NotNull Object parentEventId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<? extends BuildOutputParser> parsers) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
        Intrinsics.checkNotNullParameter(parsers, (String)"parsers");
        this(buildId, parentEventId, buildProgressListener, parsers, 0, 0, 48, null);
    }

    private static final void readerRunnable$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void readerRunnable$lambda$2(BuildOutputInstantReaderImpl this$0, List $parsers, BuildProgressListener $buildProgressListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$parsers, (String)"$parsers");
        Intrinsics.checkNotNullParameter((Object)$buildProgressListener, (String)"$buildProgressListener");
        if (!(!this$0.readFinishedFuture.isDone())) {
            boolean $i$a$-require-BuildOutputInstantReaderImpl$readerRunnable$1$22 = false;
            String string2 = LangBundle.message("error.can.t.read.from.closed.stream", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"error.can.t.read.from.closed.stream\")");
            String $i$a$-require-BuildOutputInstantReaderImpl$readerRunnable$1$22 = string2;
            throw new IllegalArgumentException($i$a$-require-BuildOutputInstantReaderImpl$readerRunnable$1$22.toString());
        }
        Ref.ObjectRef lastMessage = new Ref.ObjectRef();
        Function1 messageConsumer2 = (Function1)new Function1<BuildEvent, Unit>((Ref.ObjectRef<BuildEvent>)lastMessage, $buildProgressListener, this$0){
            final /* synthetic */ Ref.ObjectRef<BuildEvent> $lastMessage;
            final /* synthetic */ BuildProgressListener $buildProgressListener;
            final /* synthetic */ BuildOutputInstantReaderImpl this$0;
            {
                this.$lastMessage = $lastMessage;
                this.$buildProgressListener = $buildProgressListener;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BuildEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!Intrinsics.areEqual((Object)event, (Object)this.$lastMessage.element)) {
                    this.$buildProgressListener.onEvent(BuildOutputInstantReaderImpl.access$getBuildId$p(this.this$0), event);
                }
                this.$lastMessage.element = event;
            }
        };
        try {
            block7: while (this$0.doReadLine(this$0.useActiveReading) != null) {
                String line;
                if (StringsKt.isBlank((CharSequence)line)) continue;
                Iterator iterator2 = $parsers.iterator();
                while (true) {
                    BuildOutputInstantReaderWrapper readerWrapper;
                    block17: {
                        if (!iterator2.hasNext()) continue block7;
                        BuildOutputParser parser = (BuildOutputParser)iterator2.next();
                        readerWrapper = new BuildOutputInstantReaderWrapper(this$0);
                        try {
                            if (!parser.parse(line, readerWrapper, arg_0 -> BuildOutputInstantReaderImpl.readerRunnable$lambda$2$lambda$1(messageConsumer2, arg_0))) break block17;
                            continue block7;
                        }
                        catch (Exception e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.warn("Build output parser error", e);
                            } else {
                                LOG.warn("Build output parser error: " + e.getMessage());
                            }
                        }
                    }
                    readerWrapper.pushBackReadLines();
                }
                break;
            }
        }
        catch (Throwable ex) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Build output reading error", ex);
            } else {
                LOG.warn("Build output reading error: " + ex.getMessage());
            }
        }
        finally {
            if (!this$0.state.compareAndSet(Companion.State.Running, Companion.State.Idle)) {
                this$0.readFinishedFuture.complete(Unit.INSTANCE);
            }
        }
    }

    public static final /* synthetic */ Object access$getBuildId$p(BuildOutputInstantReaderImpl $this) {
        return $this.buildId;
    }

    public static final /* synthetic */ AtomicReference access$getState$p(BuildOutputInstantReaderImpl $this) {
        return $this.state;
    }

    public static final /* synthetic */ Runnable access$getReaderRunnable$p(BuildOutputInstantReaderImpl $this) {
        return $this.readerRunnable;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getChannel$p(BuildOutputInstantReaderImpl $this) {
        return $this.channel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuildOutputInstantReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/build/output/BuildOutputInstantReaderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "State", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/build/output/BuildOutputInstantReaderImpl$Companion$State;", "", "(Ljava/lang/String;I)V", "Idle", "Running", "Closed", "intellij.platform.lang.impl"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State Idle = new State();
            public static final /* enum */ State Running = new State();
            public static final /* enum */ State Closed = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.Idle, State.Running, State.Closed};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0006\u0010\u000b\u001a\u00020\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/build/output/BuildOutputInstantReaderImpl$BuildOutputInstantReaderWrapper;", "Lcom/intellij/build/output/BuildOutputInstantReader;", "reader", "(Lcom/intellij/build/output/BuildOutputInstantReader;)V", "linesRead", "", "getParentEventId", "", "pushBack", "", "numberOfLines", "pushBackReadLines", "readLine", "", "intellij.platform.lang.impl"})
    private static final class BuildOutputInstantReaderWrapper
    implements BuildOutputInstantReader {
        @NotNull
        private final BuildOutputInstantReader reader;
        private int linesRead;

        public BuildOutputInstantReaderWrapper(@NotNull BuildOutputInstantReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        @NotNull
        public Object getParentEventId() {
            Object object = this.reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
            return object;
        }

        @Override
        @Nullable
        public String readLine() {
            String line = this.reader.readLine();
            if (line != null) {
                int n = this.linesRead;
                this.linesRead = n + 1;
            }
            return line;
        }

        @Override
        public void pushBack() {
            this.pushBack(1);
        }

        @Override
        public void pushBack(int numberOfLines) {
            int numberToPushBack = numberOfLines > this.linesRead ? this.linesRead : numberOfLines;
            this.linesRead -= numberToPushBack;
            this.reader.pushBack(numberToPushBack);
        }

        public final void pushBackReadLines() {
            if (this.linesRead != 0) {
                this.reader.pushBack(this.linesRead);
                this.linesRead = 0;
            }
        }
    }
}

