/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputCollector;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements BuildOutputParser {
    private static final @NotNull Supplier<@BuildEventsNls.Title String> COMPILER_MESSAGES_GROUP = LangBundle.messagePointer("build.event.title.compiler", new Object[0]);
    private static final char COLON = ':';
    @NonNls
    private static final String WARNING_PREFIX = "warning:";
    @NonNls
    private static final String NOTE_PREFIX = "note:";
    @NonNls
    private static final String ERROR_PREFIX = "error:";
    private final String[] myFileExtensions;

    public JavacOutputParser() {
        this("java");
    }

    public JavacOutputParser(String ... fileExtensions) {
        if (fileExtensions == null) {
            JavacOutputParser.$$$reportNull$$$0(0);
        }
        this.myFileExtensions = fileExtensions;
    }

    @Override
    public boolean parse(@NlsSafe @NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer2) {
        int colonIndex1;
        if (line == null) {
            JavacOutputParser.$$$reportNull$$$0(1);
        }
        if (reader == null) {
            JavacOutputParser.$$$reportNull$$$0(2);
        }
        if (messageConsumer2 == null) {
            JavacOutputParser.$$$reportNull$$$0(3);
        }
        if ((colonIndex1 = line.indexOf(58)) == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            File file2;
            String message;
            int javaFileExtensionIndex;
            @NlsSafe String part1 = line.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                String text2 = line.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP.get(), text2, line));
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                String text3 = line.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.WARNING, COMPILER_MESSAGES_GROUP.get(), text3, line));
                return true;
            }
            if (part1.equalsIgnoreCase("javac")) {
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP.get(), line, line));
                return true;
            }
            if (part1.equalsIgnoreCase("Note") && (javaFileExtensionIndex = (message = line.substring(colonIndex1 + 1).trim()).indexOf(".java")) > 0 && (file2 = new File(message.substring(0, javaFileExtensionIndex + ".java".length()))).isFile()) {
                message = message.substring(javaFileExtensionIndex + ".java".length() + 1);
                String detailedMessage = JavacOutputParser.amendNextInfoLinesIfNeeded(file2.getPath() + ":\n" + message, reader);
                messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.INFO, COMPILER_MESSAGES_GROUP.get(), message, detailedMessage, new FilePosition(file2, 0, 0)));
                return true;
            }
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file3 = new File(part1);
                if (!file3.isFile()) {
                    return false;
                }
                try {
                    int column;
                    int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    String text4 = line.substring(colonIndex2 + 1).trim();
                    MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
                    if (StringUtil.startsWithIgnoreCase(text4, WARNING_PREFIX)) {
                        text4 = text4.substring(WARNING_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.WARNING;
                    } else if (StringUtil.startsWithIgnoreCase(text4, NOTE_PREFIX)) {
                        text4 = text4.substring(NOTE_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.INFO;
                    } else if (StringUtil.startsWithIgnoreCase(text4, ERROR_PREFIX)) {
                        text4 = text4.substring(ERROR_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.ERROR;
                    }
                    if (!this.isRelatedFile(file3)) {
                        return false;
                    }
                    BuildOutputCollector outputCollector = new BuildOutputCollector(reader);
                    ArrayList<String> messageList = new ArrayList<String>();
                    messageList.add(text4);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = outputCollector.readLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            column = nextLine.indexOf(94);
                            String messageEnd = outputCollector.readLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messageList.add(messageEnd.trim());
                                messageEnd = outputCollector.readLine();
                            }
                            if (messageEnd == null) break;
                            outputCollector.pushBack();
                            break;
                        }
                        if (prevLine != null) {
                            messageList.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (column >= 0) {
                        String message2 = StringUtil.join(JavacOutputParser.convertMessages(messageList), "\n");
                        String detailedMessage = line + "\n" + outputCollector.getOutput();
                        messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), kind, COMPILER_MESSAGES_GROUP.get(), message2, detailedMessage, new FilePosition(file3, lineNumber - 1, column)));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP.get(), LangBundle.message("build.event.message.out.memory", new Object[0]), line));
            return true;
        }
        return false;
    }

    private boolean isRelatedFile(File file2) {
        String filePath = file2.getPath();
        return ContainerUtil.exists(this.myFileExtensions, extension2 -> FileUtilRt.extensionEquals(filePath, extension2));
    }

    @NlsSafe
    private static String amendNextInfoLinesIfNeeded(String str, BuildOutputInstantReader reader) {
        StringBuilder builder2 = new StringBuilder(str);
        String nextLine = reader.readLine();
        while (nextLine != null) {
            int index2;
            if (nextLine.startsWith("Note: ") && (index2 = nextLine.indexOf(".java")) < 0) {
                builder2.append("\n").append(nextLine.substring("Note: ".length()));
                nextLine = reader.readLine();
                continue;
            }
            reader.pushBack();
            break;
        }
        return builder2.toString();
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(4);
        }
        if (messages.size() <= 1) {
            List<String> list2 = messages;
            if (list2 == null) {
                JavacOutputParser.$$$reportNull$$$0(5);
            }
            return list2;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        List<String> list3 = messages;
        if (list3 == null) {
            JavacOutputParser.$$$reportNull$$$0(6);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/output/JavacOutputParser";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertMessages";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }
}

