/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0013H\u0002J2\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001cH\u0002JJ\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u000b\u0010\u001b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001cH\u0002J\u0015\u0010$\u001a\u00020\u00182\u000b\u0010%\u001a\u00070\u0004\u00a2\u0006\u0002\b&H\u0003J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020,0\u0013H\u0016J\u0014\u0010-\u001a\u00020\u0004*\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010.\u001a\u00020\"*\u00020\u0004H\u0002J\u0014\u0010.\u001a\u00020\"*\u00020\u00042\u0006\u0010/\u001a\u00020\"H\u0002J\f\u00100\u001a\u00020\u000f*\u00020\u0004H\u0002J\f\u00101\u001a\u00020\u000f*\u00020\u0004H\u0002J\u0014\u00102\u001a\u00020\u0004*\u00020\u00042\u0006\u00103\u001a\u00020\"H\u0003J\u0014\u00104\u001a\u00020\u0004*\u00020\u00042\u0006\u00103\u001a\u00020\"H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/build/output/KotlincOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "COLON", "", "JAVAC_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "()Ljava/lang/String;", "KOTLIN_POSITION_PATTERN", "LINE_COLON_COLUMN_POSITION_PATTERN", "URI_POSITION_PATTERN", "addMessage", "", "message", "Lcom/intellij/build/events/MessageEvent;", "consumer", "Ljava/util/function/Consumer;", "createMessage", "parentId", "", "messageKind", "Lcom/intellij/build/events/MessageEvent$Kind;", "text", "Lcom/intellij/build/events/BuildEventsNls$Message;", "detail", "Lcom/intellij/build/events/BuildEventsNls$Description;", "createMessageWithLocation", "Lcom/intellij/build/events/impl/FileMessageEventImpl;", "file", "Ljava/io/File;", "lineNumber", "", "columnIndex", "getMessageKind", "kind", "Lorg/jetbrains/annotations/NonNls;", "isKaptErrorWhileAnnotationProcessing", "parse", "line", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "Lcom/intellij/build/events/BuildEvent;", "amendNextLinesIfNeeded", "colon", "skip", "isNextMessage", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nKotlincOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlincOutputParser.kt\ncom/intellij/build/output/KotlincOutputParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1#2:232\n*E\n"})
public final class KotlincOutputParser
implements BuildOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String COLON;
    private final Pattern KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    private final Pattern URI_POSITION_PATTERN = Pattern.compile("^([0-9]*):([0-9]*)");
    private final Pattern JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
    private final Pattern LINE_COLON_COLUMN_POSITION_PATTERN = Pattern.compile("([0-9]*):([0-9]*)");
    @NotNull
    private static final Regex WINDOWS_PATH = new Regex("^\\s*.:(/|\\\\)");
    @NotNull
    private static final Regex WINDOWS_URI = new Regex("^\\s*file:/+.:(/|\\\\)");
    @NotNull
    private static final Regex UNIX_URI = new Regex("^\\s*file:/");

    public KotlincOutputParser() {
        this.COLON = ":";
    }

    @Override
    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> consumer2) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        int colonIndex1 = this.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = this.substringBeforeAndTrim(line, colonIndex1);
        if (!this.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = this.substringAfterAndTrim(line, colonIndex1);
        String string2 = Companion.extractPath(lineWoSeverity);
        if (string2 == null) {
            return false;
        }
        String path2 = string2;
        if (StringsKt.startsWith$default((String)path2, (String)"file:", (boolean)false, (int)2, null)) {
            File file3;
            try {
                Path path3 = Paths.get(new URI(path2));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(this)");
                file3 = path3.toFile();
            }
            catch (Exception exception) {
                file3 = new File(path2);
            }
            file2 = file3;
        } else {
            file2 = new File(path2);
        }
        File file4 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"file");
        String string3 = FilesKt.getExtension((File)file4).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
        String fileExtension = string3;
        if (!file4.isFile() || !Intrinsics.areEqual((Object)fileExtension, (Object)"kt") && !Intrinsics.areEqual((Object)fileExtension, (Object)"kts") && !Intrinsics.areEqual((Object)fileExtension, (Object)"java")) {
            String combinedMessage = this.amendNextLinesIfNeeded(lineWoSeverity, reader);
            Object object = reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
            return this.addMessage(this.createMessage(object, this.getMessageKind(severity), lineWoSeverity, combinedMessage), consumer2);
        }
        String lineWoPath = this.substringAfterAndTrim(lineWoSeverity, path2.length());
        int lineWoPositionIndex = -1;
        Matcher matcher = null;
        if (StringsKt.startsWith$default((CharSequence)lineWoPath, (char)'(', (boolean)false, (int)2, null)) {
            int colonIndex3 = this.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                lineWoPositionIndex = colonIndex3;
            }
            if (lineWoPositionIndex >= 0) {
                position = this.substringBeforeAndTrim(lineWoPath, lineWoPositionIndex);
                it = var16_20 = this.KOTLIN_POSITION_PATTERN.matcher((CharSequence)position);
                boolean bl = false;
                Matcher matcher2 = it.matches() ? var16_20 : null;
                if (matcher2 == null) {
                    matcher2 = this.JAVAC_POSITION_PATTERN.matcher((CharSequence)position);
                }
                matcher = matcher2;
            }
        } else {
            Pattern pattern = this.URI_POSITION_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"URI_POSITION_PATTERN");
            Pattern colonIndex3 = pattern;
            if (Regex.find$default((Regex)new Regex(colonIndex3), (CharSequence)lineWoPath, (int)0, (int)2, null) != null) {
                Pattern pattern2 = this.URI_POSITION_PATTERN;
                Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"URI_POSITION_PATTERN");
                position = pattern2;
                MatchResult matchResult = Regex.find$default((Regex)new Regex((Pattern)position), (CharSequence)lineWoPath, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchResult parts = matchResult;
                System.out.println(parts);
                position = (String)CollectionsKt.first((List)parts.getGroupValues());
                lineWoPositionIndex = ((String)position).length();
                matcher = this.URI_POSITION_PATTERN.matcher((CharSequence)position);
            } else {
                int colonIndex4 = this.colon(lineWoPath, 1);
                lineWoPositionIndex = colonIndex4 >= 0 ? colonIndex4 : this.colon(lineWoPath);
                if (lineWoPositionIndex >= 0) {
                    position = this.substringBeforeAndTrim(lineWoPath, colonIndex4);
                    it = var16_20 = this.LINE_COLON_COLUMN_POSITION_PATTERN.matcher((CharSequence)position);
                    boolean bl = false;
                    Matcher matcher3 = it.matches() ? var16_20 : null;
                    if (matcher3 == null) {
                        matcher3 = matcher = this.JAVAC_POSITION_PATTERN.matcher((CharSequence)position);
                    }
                }
            }
        }
        if (lineWoPositionIndex >= 0) {
            String relatedNextLines = this.amendNextLinesIfNeeded("", reader);
            String message = this.substringAfterAndTrim(lineWoPath, lineWoPositionIndex) + relatedNextLines;
            String details2 = line + relatedNextLines;
            if (matcher != null && matcher.matches()) {
                String symbolNumber;
                String lineNumber = matcher.group(1);
                String string4 = symbolNumber = matcher.groupCount() >= 2 ? matcher.group(2) : "1";
                if (lineNumber != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)symbolNumber, (String)"symbolNumber");
                    int symbolNumberText = Integer.parseInt(symbolNumber);
                    Object object = reader.getParentEventId();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
                    return this.addMessage(this.createMessageWithLocation(object, this.getMessageKind(severity), message, file4, Integer.parseInt(lineNumber), symbolNumberText, details2), consumer2);
                }
            }
            Object object = reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
            return this.addMessage(this.createMessage(object, this.getMessageKind(severity), message, details2), consumer2);
        }
        String combinedMessage = this.amendNextLinesIfNeeded(lineWoSeverity, reader);
        Object object = reader.getParentEventId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
        return this.addMessage(this.createMessage(object, this.getMessageKind(severity), lineWoSeverity, combinedMessage), consumer2);
    }

    private final String amendNextLinesIfNeeded(String $this$amendNextLinesIfNeeded, BuildOutputInstantReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder2 = new StringBuilder($this$amendNextLinesIfNeeded);
        while (nextLine != null) {
            if (this.isNextMessage(nextLine)) {
                reader.pushBack();
                break;
            }
            builder2.append("\n").append(nextLine);
            nextLine = reader.readLine();
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNextMessage(String $this$isNextMessage) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$this$isNextMessage, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string2 = $this$isNextMessage.substring(0, colonIndex1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (this.startsWithSeverityPrefix(string2)) return true;
        }
        if (StringUtil.startsWith($this$isNextMessage, "Note: ")) return true;
        if (StringUtil.startsWith($this$isNextMessage, "> Task :")) return true;
        if (StringUtil.containsIgnoreCase($this$isNextMessage, "FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase($this$isNextMessage, "FAILED")) return false;
        return true;
    }

    private final boolean startsWithSeverityPrefix(String $this$startsWithSeverityPrefix) {
        return this.getMessageKind($this$startsWithSeverityPrefix) != MessageEvent.Kind.SIMPLE;
    }

    @NonNls
    private final MessageEvent.Kind getMessageKind(String kind) {
        return switch (kind) {
            case "e" -> MessageEvent.Kind.ERROR;
            case "w" -> MessageEvent.Kind.WARNING;
            case "i" -> MessageEvent.Kind.INFO;
            case "v" -> MessageEvent.Kind.SIMPLE;
            default -> MessageEvent.Kind.SIMPLE;
        };
    }

    @Contract(pure=true)
    private final String substringAfterAndTrim(String $this$substringAfterAndTrim, int index2) {
        String string2 = $this$substringAfterAndTrim.substring(index2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    @Contract(pure=true)
    private final String substringBeforeAndTrim(String $this$substringBeforeAndTrim, int index2) {
        String string2 = $this$substringBeforeAndTrim.substring(0, index2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final int colon(String $this$colon) {
        return StringsKt.indexOf$default((CharSequence)$this$colon, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
    }

    private final int colon(String $this$colon, int skip) {
        int index2 = 0;
        index2 = -1;
        int n = skip + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if ((index2 = StringsKt.indexOf$default((CharSequence)$this$colon, (String)this.COLON, (int)(index2 + 1), (boolean)false, (int)4, null)) >= 0) continue;
            return index2;
        }
        return index2;
    }

    private final String getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT() {
        return "org.jetbrains.kotlin.kapt3.diagnostic.KaptError: " + LangBundle.message("kapterror.error.while.annotation.processing", new Object[0]);
    }

    private final boolean isKaptErrorWhileAnnotationProcessing(MessageEvent message) {
        if (message.getKind() != MessageEvent.Kind.ERROR) {
            return false;
        }
        String string2 = message.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.message");
        String messageText = string2;
        String string3 = IllegalStateException.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)messageText, (String)string3, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)this.getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT(), (boolean)false, (int)2, null);
    }

    private final boolean addMessage(MessageEvent message, Consumer<? super MessageEvent> consumer2) {
        if (this.isKaptErrorWhileAnnotationProcessing(message)) {
            return true;
        }
        consumer2.accept(message);
        return true;
    }

    private final MessageEvent createMessage(Object parentId, MessageEvent.Kind messageKind, String text2, String detail) {
        return new MessageEventImpl(parentId, messageKind, KotlincOutputParser.Companion.getCOMPILER_MESSAGES_GROUP(), ((Object)StringsKt.trim((CharSequence)text2)).toString(), detail);
    }

    private final FileMessageEventImpl createMessageWithLocation(Object parentId, MessageEvent.Kind messageKind, String text2, File file2, int lineNumber, int columnIndex, String detail) {
        return new FileMessageEventImpl(parentId, messageKind, KotlincOutputParser.Companion.getCOMPILER_MESSAGES_GROUP(), ((Object)StringsKt.trim((CharSequence)text2)).toString(), detail, new FilePosition(file2, lineNumber - 1, columnIndex - 1));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/build/output/KotlincOutputParser$Companion;", "", "()V", "COMPILER_MESSAGES_GROUP", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "getCOMPILER_MESSAGES_GROUP", "()Ljava/lang/String;", "UNIX_URI", "Lkotlin/text/Regex;", "WINDOWS_PATH", "WINDOWS_URI", "extractPath", "line", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @BuildEventsNls.Title
        private final String getCOMPILER_MESSAGES_GROUP() {
            String string2 = LangBundle.message("build.event.title.kotlin.compiler", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"build.event.title.kotlin.compiler\")");
            return string2;
        }

        @Nullable
        public final String extractPath(@NotNull String line) {
            Integer n;
            block3: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)":", (boolean)false, (int)2, null)) {
                    return null;
                }
                Object[] objectArray = new Regex[]{WINDOWS_PATH, WINDOWS_URI, UNIX_URI};
                for (Regex it : (Iterable)CollectionsKt.listOf((Object[])objectArray)) {
                    boolean bl = false;
                    MatchResult matchResult = Regex.find$default((Regex)it, (CharSequence)line, (int)0, (int)2, null);
                    Integer n2 = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = (MatchGroup)CollectionsKt.last((Iterable)((Iterable)matchResult))) != null && (matchResult = matchResult.getRange()) != null ? matchResult.getEndInclusive() : null;
                    if (n2 == null) continue;
                    n = n2;
                    break block3;
                }
                n = null;
            }
            int systemPrefixLen = n != null ? n : 0;
            int colonIndex = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)systemPrefixLen, (boolean)false, (int)4, null);
            if (colonIndex < 0) {
                return null;
            }
            String string2 = line.substring(0, colonIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

