/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FileSeparatorProvider {
    FileSeparatorProvider() {
    }

    @NotNull
    static List<LineMarkerInfo<?>> getFileSeparators(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileSeparatorProvider.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FileSeparatorProvider.$$$reportNull$$$0(1);
        }
        ArrayList result2 = new ArrayList();
        for (LineMarkerInfo<?> lineMarkerInfo : LineMarkersPass.queryLineMarkers(file2, document)) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result2.add(lineMarkerInfo);
        }
        result2.sort(Comparator.comparingInt(i2 -> FileSeparatorProvider.getDisplayLine(i2, document)));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            FileSeparatorProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static int getDisplayLine(@NotNull LineMarkerInfo<?> lineMarkerInfo, @NotNull Document document) {
        if (lineMarkerInfo == null) {
            FileSeparatorProvider.$$$reportNull$$$0(3);
        }
        if (document == null) {
            FileSeparatorProvider.$$$reportNull$$$0(4);
        }
        int offset2 = lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? lineMarkerInfo.startOffset : lineMarkerInfo.endOffset;
        return document.getLineNumber(MathUtil.clamp(offset2, 0, document.getTextLength())) + (lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? 0 : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeEditor/printing/FileSeparatorProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeEditor/printing/FileSeparatorProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileSeparators";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayLine";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

