/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.ui.JBColor;
import com.intellij.util.MathUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ColorGenerator {
    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull List<? extends Color> anchorColors, int colorsBetweenAnchors) {
        if (anchorColors == null) {
            ColorGenerator.$$$reportNull$$$0(0);
        }
        assert (colorsBetweenAnchors >= 0);
        if (anchorColors.isEmpty()) {
            List<Color> list2 = Collections.singletonList(JBColor.GRAY);
            if (list2 == null) {
                ColorGenerator.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (anchorColors.size() == 1) {
            List<Color> list3 = Collections.singletonList(anchorColors.get(0));
            if (list3 == null) {
                ColorGenerator.$$$reportNull$$$0(2);
            }
            return list3;
        }
        int segmentCount = anchorColors.size() - 1;
        ArrayList<Color> result2 = new ArrayList<Color>(anchorColors.size() + segmentCount * colorsBetweenAnchors);
        result2.add(anchorColors.get(0));
        for (int i2 = 0; i2 < segmentCount; ++i2) {
            Color color1 = anchorColors.get(i2);
            Color color2 = anchorColors.get(i2 + 1);
            List<Color> linearColors = ColorGenerator.generateLinearColorSequence(color1, color2, colorsBetweenAnchors);
            result2.addAll(linearColors.subList(1, linearColors.size()));
        }
        ArrayList<Color> arrayList = result2;
        if (arrayList == null) {
            ColorGenerator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    static List<Color> generateLinearColorSequence(@NotNull Color color1, @NotNull Color color2, int colorsBetweenAnchors) {
        if (color1 == null) {
            ColorGenerator.$$$reportNull$$$0(4);
        }
        if (color2 == null) {
            ColorGenerator.$$$reportNull$$$0(5);
        }
        assert (colorsBetweenAnchors >= 0);
        ArrayList<Color> result2 = new ArrayList<Color>(colorsBetweenAnchors + 2);
        result2.add(color1);
        for (int i2 = 1; i2 <= colorsBetweenAnchors; ++i2) {
            float ratio = (float)i2 / (float)(colorsBetweenAnchors + 1);
            result2.add(new Color(ColorGenerator.ratio(color1.getRed(), color2.getRed(), ratio), ColorGenerator.ratio(color1.getGreen(), color2.getGreen(), ratio), ColorGenerator.ratio(color1.getBlue(), color2.getBlue(), ratio)));
        }
        result2.add(color2);
        ArrayList<Color> arrayList = result2;
        if (arrayList == null) {
            ColorGenerator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static int ratio(int val1, int val2, float ratio) {
        int value = (int)((float)val1 + (float)(val2 - val1) * ratio);
        return MathUtil.clamp(value, 0, 255);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorColors";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/ColorGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/ColorGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLinearColorSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateLinearColorSequence";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 6 -> new IllegalStateException(string2);
        };
    }
}

