/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AutoPopupControllerImpl
extends AutoPopupController {
    private final Project myProject;
    private final Alarm myAlarm;

    public AutoPopupControllerImpl(@NotNull Project project2) {
        if (project2 == null) {
            AutoPopupControllerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myAlarm = new Alarm((Disposable)this.myProject);
        this.setupListeners();
    }

    private void setupListeners() {
        ApplicationManager.getApplication().getMessageBus().connect(this.myProject).subscribe(AnActionListener.TOPIC, new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                AutoPopupControllerImpl.this.cancelAllRequests();
            }

            public void beforeEditorTyping(char c2, @NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                AutoPopupControllerImpl.this.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/AutoPopupControllerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        IdeEventQueue.getInstance().addActivityListener(this::cancelAllRequests, (Disposable)this.myProject);
    }

    @Override
    public void autoPopupMemberLookup(Editor editor2, @Nullable Condition<? super PsiFile> condition) {
        this.autoPopupMemberLookup(editor2, CompletionType.BASIC, condition);
    }

    @Override
    public void autoPopupMemberLookup(Editor editor2, CompletionType completionType, @Nullable Condition<? super PsiFile> condition) {
        this.scheduleAutoPopup(editor2, completionType, condition);
    }

    @Override
    public void scheduleAutoPopup(@NotNull Editor editor2, @NotNull CompletionType completionType, @Nullable Condition<? super PsiFile> condition) {
        if (editor2 == null) {
            AutoPopupControllerImpl.$$$reportNull$$$0(1);
        }
        if (completionType == null) {
            AutoPopupControllerImpl.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            return;
        }
        boolean alwaysAutoPopup = Boolean.TRUE.equals(editor2.getUserData(ALWAYS_AUTO_POPUP));
        if (!CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && !alwaysAutoPopup) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        if (!CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class, CompletionPhase.NoCompletion.getClass(), CompletionPhase.EmptyAutoPopup.class)) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (currentCompletion != null) {
            currentCompletion.closeAndFinish(true);
        }
        CompletionPhase.CommittingDocuments.scheduleAsyncCompletion(editor2, completionType, condition, this.myProject, null);
    }

    @Override
    public void scheduleAutoPopup(Editor editor2) {
        this.scheduleAutoPopup(editor2, CompletionType.BASIC, null);
    }

    @Override
    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    @Override
    public void autoPopupParameterInfo(@NotNull Editor editor2, @Nullable PsiElement highlightedMethod) {
        if (editor2 == null) {
            AutoPopupControllerImpl.$$$reportNull$$$0(3);
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_PARAMETER_INFO) {
            AtomicInteger offset2 = new AtomicInteger(-1);
            ReadAction.nonBlocking(() -> {
                offset2.set(editor2.getCaretModel().getOffset());
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
                PsiFile file2 = documentManager.getPsiFile(editor2.getDocument());
                if (file2 == null) {
                    return;
                }
                if (!documentManager.isUncommited(editor2.getDocument()) && (file2 = documentManager.getPsiFile(InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor2, file2).getDocument())) == null) {
                    return;
                }
                Runnable request2 = () -> {
                    if (!this.myProject.isDisposed() && !editor2.isDisposed() && UIUtil.isShowing(editor2.getContentComponent())) {
                        int lbraceOffset = offset2.get() - 1;
                        try {
                            PsiFile file1 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(editor2.getDocument());
                            if (file1 != null) {
                                ShowParameterInfoHandler.invoke(this.myProject, editor2, file1, lbraceOffset, highlightedMethod, false, true, null);
                            }
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            // empty catch block
                        }
                    }
                };
                this.myAlarm.addRequest(() -> documentManager.performLaterWhenAllCommitted(request2), settings.PARAMETER_INFO_DELAY);
            }).expireWith((Disposable)this.myAlarm).coalesceBy(this, editor2).expireWhen(() -> {
                int initialOffset = offset2.get();
                return editor2.isDisposed() || initialOffset != -1 && editor2.getCaretModel().getOffset() != initialOffset;
            }).submit(AppExecutorUtil.getAppExecutorService());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TestOnly
    public void waitForDelayedActions(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void unit;
        if (timeUnit == null) {
            AutoPopupControllerImpl.$$$reportNull$$$0(4);
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            UIUtil.dispatchAllInvocationEvents();
            if (this.myAlarm.isEmpty()) {
                return;
            }
            LockSupport.parkNanos(10000000L);
        }
        throw new TimeoutException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/AutoPopupControllerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleAutoPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "autoPopupParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDelayedActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

