/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.TargetElementUtilExtender;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.BitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;

    public static TargetElementUtil getInstance() {
        return ApplicationManager.getApplication().getService(TargetElementUtil.class);
    }

    public int getAllAccepted() {
        int result2 = 11;
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAllAdditionalFlags();
        }
        return result2;
    }

    public int getDefinitionSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalDefinitionSearchFlags();
        }
        return result2;
    }

    public int getReferenceSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalReferenceSearchFlags();
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor2) {
        int offset2;
        PsiReference result2;
        if (editor2 == null) {
            TargetElementUtil.$$$reportNull$$$0(0);
        }
        if ((result2 = TargetElementUtil.findReference(editor2, offset2 = editor2.getCaretModel().getOffset())) == null) {
            int expectedCaretOffset;
            int n = expectedCaretOffset = editor2 instanceof EditorEx ? ((EditorEx)editor2).getExpectedCaretOffset() : offset2;
            if (expectedCaretOffset != offset2) {
                result2 = TargetElementUtil.findReference(editor2, expectedCaretOffset);
            }
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor2, int offset2) {
        if (editor2 == null) {
            TargetElementUtil.$$$reportNull$$$0(1);
        }
        return TargetElementUtilBase.findReference(editor2, offset2);
    }

    public static int adjustOffset(@Nullable PsiFile file2, Document document, int offset2) {
        return TargetElementUtilBase.adjustOffset(file2, document, offset2);
    }

    public static boolean inVirtualSpace(@NotNull Editor editor2, int offset2) {
        if (editor2 == null) {
            TargetElementUtil.$$$reportNull$$$0(2);
        }
        return offset2 == editor2.getCaretModel().getOffset() && EditorCoreUtil.inVirtualSpace((Editor)editor2, (LogicalPosition)editor2.getCaretModel().getLogicalPosition());
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor2, int flags) {
        int expectedCaretOffset;
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement result2 = TargetElementUtil.getInstance().findTargetElement(editor2, flags, offset2);
        if (result2 != null) {
            return result2;
        }
        int n = expectedCaretOffset = editor2 instanceof EditorEx ? ((EditorEx)editor2).getExpectedCaretOffset() : offset2;
        if (expectedCaretOffset != offset2) {
            return TargetElementUtil.getInstance().findTargetElement(editor2, flags, expectedCaretOffset);
        }
        return null;
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor2, int flags, int offset2) {
        PsiElement element;
        Project project2;
        if (editor2 == null) {
            TargetElementUtil.$$$reportNull$$$0(3);
        }
        if ((project2 = editor2.getProject()) == null) {
            return null;
        }
        if (BitUtil.isSet(flags, 8) && (element = TargetElementUtil.getTargetElementFromLookup(project2)) != null) {
            return element;
        }
        return TargetElementUtilBase.findTargetElement(editor2, flags, offset2);
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getTargetElementFromLookup(Project project2) {
        LookupElement item;
        PsiElement psi;
        LookupEx activeLookup = LookupManager.getInstance(project2).getActiveLookup();
        if (activeLookup != null && (psi = TargetElementUtil.targetElementFromLookupElement(item = activeLookup.getCurrentItem())) != null) {
            return psi;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement targetElementFromLookupElement(@Nullable LookupElement item) {
        PsiElement psi;
        if (item != null && item.isValid() && (psi = CompletionUtil.getTargetElement(item)) != null && psi.isValid()) {
            return psi;
        }
        return null;
    }

    @Nullable
    public PsiElement adjustElement(Editor editor2, int flags, @Nullable PsiElement element, @Nullable PsiElement contextElement) {
        TargetElementEvaluatorEx2 evaluator;
        PsiElement langElement = element == null ? contextElement : element;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = langElement != null ? TargetElementUtilBase.getElementEvaluatorsEx2(langElement.getLanguage()) : null;
        if (evaluator != null) {
            element = evaluator.adjustElement(editor2, flags, element, contextElement);
        }
        return element;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        PsiElement element;
        TargetElementEvaluatorEx2 evaluator;
        if (ref == null) {
            TargetElementUtil.$$$reportNull$$$0(4);
        }
        return (evaluator = TargetElementUtilBase.getElementEvaluatorsEx2((element = ref.getElement()).getLanguage())) != null ? evaluator.adjustReference(ref) : null;
    }

    @Nullable
    public PsiElement getNamedElement(@Nullable PsiElement element, int offsetInElement) {
        return TargetElementUtilBase.getNamedElement(element, offsetInElement);
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getNamedElement(@Nullable PsiElement element) {
        return TargetElementUtilBase.getNamedElement(element);
    }

    @NotNull
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference2) {
        Collection<PsiElement> candidates;
        PsiElement refElement;
        TargetElementEvaluatorEx2 evaluator;
        if (reference2 == null) {
            TargetElementUtil.$$$reportNull$$$0(5);
        }
        if ((evaluator = TargetElementUtilBase.getElementEvaluatorsEx2((refElement = reference2.getElement()).getLanguage())) != null && (candidates = evaluator.getTargetCandidates(reference2)) != null) {
            Collection<PsiElement> collection = candidates;
            if (collection == null) {
                TargetElementUtil.$$$reportNull$$$0(6);
            }
            return collection;
        }
        if (reference2 instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference2).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = r.getElement();
                if (!this.isNavigatableSource(element)) continue;
                navigatableResults.add(element);
            }
            ArrayList<PsiElement> arrayList = navigatableResults;
            if (arrayList == null) {
                TargetElementUtil.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        PsiElement resolved = reference2.resolve();
        if (resolved instanceof NavigationItem) {
            Set<PsiElement> set2 = Collections.singleton(resolved);
            if (set2 == null) {
                TargetElementUtil.$$$reportNull$$$0(8);
            }
            return set2;
        }
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            TargetElementUtil.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Contract(value="null -> false")
    public boolean isNavigatableSource(@Nullable PsiElement element) {
        return EditSourceUtil.canNavigate(element) || element instanceof Navigatable && ((Navigatable)((Object)element)).canNavigateToSource();
    }

    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element != null ? TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage()) : null;
        if (evaluator != null && (result2 = evaluator.getGotoDeclarationTarget(element, navElement)) != null) {
            return result2;
        }
        return navElement;
    }

    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        TargetElementEvaluator evaluator;
        if (element == null) {
            TargetElementUtil.$$$reportNull$$$0(10);
        }
        return (evaluator = TargetElementUtilBase.TARGET_ELEMENT_EVALUATOR.forLanguage(element.getLanguage())) == null || evaluator.includeSelfInGotoImplementation(element);
    }

    public boolean acceptImplementationForReference(@Nullable PsiReference reference2, @Nullable PsiElement element) {
        TargetElementEvaluatorEx2 evaluator = element != null ? TargetElementUtilBase.getElementEvaluatorsEx2(ReadAction.compute(element::getLanguage)) : null;
        return evaluator == null || evaluator.acceptImplementationForReference(reference2, element);
    }

    @NotNull
    public SearchScope getSearchScope(Editor editor2, @NotNull PsiElement element) {
        TargetElementEvaluatorEx2 evaluator;
        SearchScope result2;
        if (element == null) {
            TargetElementUtil.$$$reportNull$$$0(11);
        }
        SearchScope searchScope2 = result2 = (evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage())) != null ? evaluator.getSearchScope(editor2, element) : null;
        if (result2 != null) {
            SearchScope searchScope3 = result2;
            if (searchScope3 == null) {
                TargetElementUtil.$$$reportNull$$$0(12);
            }
            return searchScope3;
        }
        PsiFile file2 = element.getContainingFile();
        SearchScope searchScope4 = PsiSearchHelper.getInstance((Project)element.getProject()).getUseScope(file2 != null ? file2 : element);
        if (searchScope4 == null) {
            TargetElementUtil.$$$reportNull$$$0(13);
        }
        return searchScope4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetCandidates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCandidates";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeSelfInGotoImplementation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 9, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

