/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    static final LanguageExtension<TargetElementEvaluator> TARGET_ELEMENT_EVALUATOR = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static int adjustOffset(@Nullable PsiFile file2, @NotNull Document document, int offset2) {
        char charAt;
        if (document == null) {
            TargetElementUtilBase.$$$reportNull$$$0(0);
        }
        CharSequence text2 = document.getCharsSequence();
        int correctedOffset = offset2;
        int textLength = text2.length();
        if (offset2 >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtilBase.isIdentifierPart(file2, text2, offset2)) {
            --correctedOffset;
        }
        if (correctedOffset >= 0 && ((charAt = text2.charAt(correctedOffset)) == '\'' || charAt == '\"' || charAt == ')' || charAt == ']' || TargetElementUtilBase.isIdentifierPart(file2, text2, correctedOffset))) {
            return correctedOffset;
        }
        return offset2;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file2, @NotNull CharSequence text2, int offset2) {
        TargetElementEvaluatorEx evaluator;
        if (text2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(1);
        }
        if (file2 != null && (evaluator = TargetElementUtilBase.getElementEvaluatorsEx(file2.getLanguage())) != null && evaluator.isIdentifierPart(file2, text2, offset2)) {
            return true;
        }
        return Character.isJavaIdentifierPart(text2.charAt(offset2));
    }

    @Nullable
    private static TargetElementEvaluatorEx getElementEvaluatorsEx(@NotNull Language language) {
        TargetElementEvaluator result2;
        if (language == null) {
            TargetElementUtilBase.$$$reportNull$$$0(2);
        }
        return (result2 = TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx ? (TargetElementEvaluatorEx)result2 : null;
    }

    @Nullable
    static TargetElementEvaluatorEx2 getElementEvaluatorsEx2(@NotNull Language language) {
        TargetElementEvaluator result2;
        if (language == null) {
            TargetElementUtilBase.$$$reportNull$$$0(3);
        }
        return (result2 = TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx2 ? (TargetElementEvaluatorEx2)result2 : null;
    }

    @ApiStatus.Internal
    static PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement result2;
        if (element == null) {
            return null;
        }
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator != null && (result2 = evaluator.getNamedElement(element)) != null) {
            return result2;
        }
        PsiNamedElement parent2 = PsiTreeUtil.getParentOfType(element, PsiNamedElement.class, false);
        if (parent2 != null && !(parent2 instanceof PsiFile) && parent2.getTextOffset() == element.getTextRange().getStartOffset() && (evaluator == null || evaluator.isAcceptableNamedParent(parent2))) {
            return parent2;
        }
        return null;
    }

    public static PsiElement getNamedElement(@Nullable PsiElement element, int offsetInElement) {
        if (element == null) {
            return null;
        }
        PsiUtilCore.ensureValid(element);
        ArrayList targets2 = new ArrayList();
        Consumer<PomTarget> consumer2 = target2 -> {
            if (target2 instanceof PsiDeclaredTarget) {
                PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target2;
                PsiElement navigationElement = declaredTarget.getNavigationElement();
                TextRange range = declaredTarget.getNameIdentifierRange();
                if (range != null && !range.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                    return;
                }
            }
            targets2.add(target2);
        };
        int offset2 = offsetInElement;
        for (PsiElement parent2 = element; parent2 != null && !(parent2 instanceof PsiFileSystemItem); parent2 = parent2.getParent()) {
            for (PomDeclarationSearcher searcher2 : PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher2.findDeclarationsAt(parent2, offset2, consumer2);
                if (targets2.isEmpty()) continue;
                PomTarget target3 = (PomTarget)targets2.get(0);
                return target3 == null ? null : PomService.convertToPsi(element.getProject(), target3);
            }
            offset2 += parent2.getStartOffsetInParent();
        }
        return TargetElementUtilBase.getNamedElement(element);
    }

    @Nullable
    private static PsiElement doGetReferenceOrReferencedElement(@NotNull Editor editor2, int flags, int offset2) {
        PsiReference ref;
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(4);
        }
        if ((ref = TargetElementUtilBase.findReference(editor2, offset2)) == null) {
            return null;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return null;
        }
        return TargetElementUtilBase.getReferencedElement(ref, flags);
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiReference ref, int flags) {
        PsiElement element;
        Language language;
        TargetElementEvaluator evaluator;
        if (ref == null) {
            TargetElementUtilBase.$$$reportNull$$$0(5);
        }
        if ((evaluator = TARGET_ELEMENT_EVALUATOR.forLanguage(language = ref.getElement().getLanguage())) != null && (element = evaluator.getElementByReference(ref, flags)) != null) {
            return element;
        }
        return ref.resolve();
    }

    @Nullable
    public static PsiReference findReferenceWithoutExpectedCaret(@NotNull Editor editor2) {
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(6);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        return TargetElementUtilBase.findReference(editor2, offset2);
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor2, int offset2) {
        Project project2;
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(7);
        }
        if ((project2 = editor2.getProject()) == null) {
            return null;
        }
        Document document = editor2.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        PsiReference ref = file2.findReferenceAt(TargetElementUtilBase.adjustOffset(file2, document, offset2));
        if (ref == null) {
            return null;
        }
        int elementOffset = ref.getElement().getTextRange().getStartOffset();
        for (TextRange range : ReferenceRange.getRanges(ref)) {
            if (!range.shiftRight(elementOffset).containsOffset(offset2)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferenceOrReferencedElement(@NotNull PsiFile file2, @NotNull Editor editor2, int flags, int offset2) {
        if (file2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(9);
        }
        PsiElement result2 = TargetElementUtilBase.doGetReferenceOrReferencedElement(editor2, flags, offset2);
        PsiElement languageElement = file2.findElementAt(offset2);
        Language language = languageElement != null ? languageElement.getLanguage() : file2.getLanguage();
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(language);
        if (evaluator != null) {
            result2 = evaluator.adjustReferenceOrReferencedElement(file2, editor2, offset2, flags, result2);
        }
        return result2;
    }

    @Nullable
    private static PsiElement doFindTargetElement(@NotNull Editor editor2, int flags, int offset2) {
        PsiElement referencedElement;
        Project project2;
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(10);
        }
        if ((project2 = editor2.getProject()) == null) {
            return null;
        }
        Document document = editor2.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        int adjusted = TargetElementUtilBase.adjustOffset(file2, document, offset2);
        PsiElement element = file2.findElementAt(adjusted);
        if (BitUtil.isSet(flags, 1) && (referencedElement = TargetElementUtilBase.getReferencedElement(file2, offset2, flags, editor2, element)) != null) {
            return referencedElement;
        }
        if (element == null) {
            return null;
        }
        if (BitUtil.isSet(flags, 2)) {
            if (element instanceof PsiNamedElement) {
                return element;
            }
            return TargetElementUtilBase.getNamedElement(element, adjusted - element.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiFile file2, int offset2, int flags, @NotNull Editor editor2, @Nullable PsiElement leafElement) {
        PsiElement referenceOrReferencedElement;
        if (file2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(12);
        }
        if (TargetElementUtilBase.isAcceptableReferencedElement(leafElement, referenceOrReferencedElement = TargetElementUtilBase.getReferenceOrReferencedElement(file2, editor2, flags, offset2))) {
            return referenceOrReferencedElement;
        }
        return null;
    }

    private static boolean isAcceptableReferencedElement(@Nullable PsiElement element, @Nullable PsiElement referenceOrReferencedElement) {
        TargetElementEvaluatorEx2 evaluator;
        if (referenceOrReferencedElement == null || !referenceOrReferencedElement.isValid()) {
            return false;
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element == null ? null : TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator != null) {
            ThreeState answer = evaluator.isAcceptableReferencedElement(element, referenceOrReferencedElement);
            if (answer == ThreeState.YES) {
                return true;
            }
            if (answer == ThreeState.NO) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor2, int flags) {
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(13);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        return TargetElementUtilBase.findTargetElement(editor2, flags, offset2);
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor2, int flags, int offset2) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator;
        if (editor2 == null) {
            TargetElementUtilBase.$$$reportNull$$$0(14);
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = (result2 = TargetElementUtilBase.doFindTargetElement(editor2, flags, offset2)) != null ? TargetElementUtilBase.getElementEvaluatorsEx2(result2.getLanguage()) : null;
        if (evaluator != null) {
            result2 = evaluator.adjustTargetElement(editor2, offset2, flags, result2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/TargetElementUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifierPart";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementEvaluatorsEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementEvaluatorsEx2";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetReferenceOrReferencedElement";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencedElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceWithoutExpectedCaret";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findReference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceOrReferencedElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindTargetElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

