/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightAction
extends AnAction
implements PerformWithDocumentsCommitted {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CodeInsightAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            CodeInsightAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) != null) {
            Editor editor2 = this.getEditor(e.getDataContext(), project2, false);
            this.actionPerformedImpl(project2, editor2);
        }
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext2, @NotNull Project project2, boolean forUpdate) {
        if (dataContext2 == null) {
            CodeInsightAction.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            CodeInsightAction.$$$reportNull$$$0(3);
        }
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
    }

    public void actionPerformedImpl(@NotNull Project project2, Editor editor2) {
        if (project2 == null) {
            CodeInsightAction.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project2);
        if (psiFile == null) {
            return;
        }
        CodeInsightActionHandler handler2 = this.getHandler();
        PsiElement elementToMakeWritable = handler2.getElementToMakeWritable(psiFile);
        if (!(elementToMakeWritable == null || EditorModificationUtil.checkModificationAllowed((Editor)editor2) && FileModificationService.getInstance().preparePsiElementsForWrite(elementToMakeWritable))) {
            return;
        }
        if (elementToMakeWritable instanceof PsiCompiledElement) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> {
                if (!UIUtil.isShowing(editor2.getContentComponent())) {
                    return;
                }
                handler2.invoke(project2, editor2, psiFile);
            };
            if (handler2.startInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(action2);
            } else {
                action2.run();
            }
        }, this.getCommandName(), (Object)DocCommandGroupId.noneGroupId(editor2.getDocument()), editor2.getDocument());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CodeInsightAction.$$$reportNull$$$0(5);
        }
        Presentation presentation2 = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        DataContext dataContext2 = e.getDataContext();
        Editor editor2 = this.getEditor(dataContext2, project2, true);
        if (editor2 == null) {
            presentation2.setVisible(!ActionPlaces.isPopupPlace((String)e.getPlace()));
            presentation2.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor(editor2, project2);
        if (file2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        this.update(presentation2, project2, editor2, file2, dataContext2, e.getPlace());
    }

    protected void update(@NotNull Presentation presentation2, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (presentation2 == null) {
            CodeInsightAction.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            CodeInsightAction.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            CodeInsightAction.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            CodeInsightAction.$$$reportNull$$$0(9);
        }
        presentation2.setEnabled(this.isValidForFile(project2, editor2, file2));
    }

    protected void update(@NotNull Presentation presentation2, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext dataContext2, @Nullable String actionPlace) {
        if (presentation2 == null) {
            CodeInsightAction.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            CodeInsightAction.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            CodeInsightAction.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            CodeInsightAction.$$$reportNull$$$0(13);
        }
        if (dataContext2 == null) {
            CodeInsightAction.$$$reportNull$$$0(14);
        }
        this.update(presentation2, project2, editor2, file2);
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            CodeInsightAction.$$$reportNull$$$0(15);
        }
        if (editor2 == null) {
            CodeInsightAction.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            CodeInsightAction.$$$reportNull$$$0(17);
        }
        return true;
    }

    @NotNull
    protected abstract CodeInsightActionHandler getHandler();

    @NlsContexts.Command
    protected String getCommandName() {
        String text2 = this.getTemplatePresentation().getText();
        return text2 == null ? "" : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/CodeInsightAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/CodeInsightAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string2);
        };
    }
}

