/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FileRecursiveIterator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;

    FileRecursiveIterator(@NotNull Project project2, @NotNull List<? extends PsiFile> roots2) {
        if (project2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(0);
        }
        if (roots2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(1);
        }
        this(project2, (Collection<? extends VirtualFile>)ContainerUtil.map(roots2, psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Module module2) {
        if (module2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(2);
        }
        this(module2.getProject(), (Collection<? extends VirtualFile>)ContainerUtil.map(FileRecursiveIterator.collectModuleDirectories(module2), psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Project project2) {
        if (project2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(3);
        }
        this(project2, (Collection<? extends VirtualFile>)ContainerUtil.map(FileRecursiveIterator.collectProjectDirectories(project2), psiDir -> psiDir.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull PsiDirectory directory) {
        if (directory == null) {
            FileRecursiveIterator.$$$reportNull$$$0(4);
        }
        this(directory.getProject(), (Collection<? extends VirtualFile>)Collections.singletonList(directory.getVirtualFile()));
    }

    FileRecursiveIterator(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> roots2) {
        if (project2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(5);
        }
        if (roots2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(6);
        }
        this.myProject = project2;
        this.myRoots = roots2;
    }

    @NotNull
    static List<PsiDirectory> collectProjectDirectories(@NotNull Project project2) {
        if (project2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(7);
        }
        Module[] modules2 = ModuleManager.getInstance(project2).getModules();
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>(modules2.length * 3);
        for (Module module2 : modules2) {
            directories.addAll(FileRecursiveIterator.collectModuleDirectories(module2));
        }
        ArrayList<PsiDirectory> arrayList = directories;
        if (arrayList == null) {
            FileRecursiveIterator.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    boolean processAll(@NotNull Processor<? super PsiFile> processor) {
        if (processor == null) {
            FileRecursiveIterator.$$$reportNull$$$0(9);
        }
        VirtualFileSet visited = VfsUtilCore.createCompactVirtualFileSet();
        for (VirtualFile virtualFile2 : this.myRoots) {
            if (ProjectRootManager.getInstance(this.myProject).getFileIndex().iterateContentUnderDirectory(virtualFile2, fileOrDir -> {
                if (fileOrDir.isDirectory() || !visited.add(fileOrDir)) {
                    return true;
                }
                PsiFile psiFile = ReadAction.compute(() -> this.myProject.isDisposed() ? null : PsiManager.getInstance(this.myProject).findFile(fileOrDir));
                return psiFile == null || processor.process(psiFile);
            })) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static List<PsiDirectory> collectModuleDirectories(Module module2) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance(module2).getContentRoots();
        List list2 = ReadAction.compute(() -> ContainerUtil.mapNotNull(contentRoots, root -> PsiManager.getInstance(module2.getProject()).findDirectory((VirtualFile)root)));
        if (list2 == null) {
            FileRecursiveIterator.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FileRecursiveIterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FileRecursiveIterator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProjectDirectories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectModuleDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectProjectDirectories";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 10 -> new IllegalStateException(string2);
        };
    }
}

