/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutCodeDialog
extends DialogWrapper {
    private final PsiFile myFile;
    private final boolean myTextSelected;
    private final String myHelpId;
    private final LastRunReformatCodeOptionsProvider myLastRunOptions;
    private final LayoutCodeOptions myRunOptions;
    private JPanel myButtonsPanel;
    private JCheckBox myOptimizeImportsCb;
    private JCheckBox myRearrangeCodeCb;
    private JCheckBox myApplyCodeCleanup;
    private JRadioButton myOnlyVCSChangedTextRb;
    private JRadioButton mySelectedTextRadioButton;
    private JRadioButton myWholeFileRadioButton;
    private JBCheckBox myDoNotKeepLineBreaks;

    public LayoutCodeDialog(@NotNull Project project2, @NotNull PsiFile file2, boolean textSelected, String helpId) {
        if (project2 == null) {
            LayoutCodeDialog.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LayoutCodeDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.myFile = file2;
        this.myTextSelected = textSelected;
        this.myHelpId = helpId;
        this.$$$setupUI$$$();
        this.myLastRunOptions = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        this.myRunOptions = this.createOptionsBundledOnDialog();
        this.setOKButtonText(CodeInsightBundle.message("reformat.code.accept.button.text", new Object[0]));
        this.setTitle(CodeInsightBundle.message("dialog.title.reformat.file.0", file2.getName()));
        this.init();
    }

    protected void init() {
        super.init();
        this.setUpActions();
        this.setUpTextRangeMode();
    }

    private void setUpTextRangeMode() {
        this.mySelectedTextRadioButton.setEnabled(this.myTextSelected);
        if (!this.myTextSelected) {
            this.mySelectedTextRadioButton.setToolTipText(CodeInsightBundle.message("tooltip.no.text.selected.in.editor", new Object[0]));
        }
        boolean fileHasChanges = VcsFacade.getInstance().hasChanges(this.myFile);
        if (this.myFile.getVirtualFile() instanceof LightVirtualFile) {
            this.myOnlyVCSChangedTextRb.setVisible(false);
        } else {
            String hint;
            this.myOnlyVCSChangedTextRb.setEnabled(fileHasChanges);
            if (!fileHasChanges && (hint = this.getChangesNotAvailableHint()) != null) {
                this.myOnlyVCSChangedTextRb.setToolTipText(hint);
            }
        }
        this.myWholeFileRadioButton.setEnabled(true);
        if (this.myTextSelected) {
            this.mySelectedTextRadioButton.setSelected(true);
        } else {
            boolean lastRunProcessedChangedText;
            boolean bl = lastRunProcessedChangedText = this.myLastRunOptions.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
            if (lastRunProcessedChangedText && fileHasChanges) {
                this.myOnlyVCSChangedTextRb.setSelected(true);
            } else {
                this.myWholeFileRadioButton.setSelected(true);
            }
        }
    }

    private void setUpActions() {
        boolean canOptimizeImports = !LanguageImportStatements.INSTANCE.forFile(this.myFile).isEmpty();
        this.myOptimizeImportsCb.setVisible(canOptimizeImports);
        if (canOptimizeImports) {
            this.myOptimizeImportsCb.setSelected(this.myLastRunOptions.getLastOptimizeImports());
        }
        boolean canRearrangeCode = Rearranger.EXTENSION.forLanguage(this.myFile.getLanguage()) != null;
        this.myRearrangeCodeCb.setVisible(canRearrangeCode);
        if (canRearrangeCode) {
            this.myRearrangeCodeCb.setSelected(this.myLastRunOptions.isRearrangeCode(this.myFile.getLanguage()));
        }
        this.myApplyCodeCleanup.setSelected(this.myLastRunOptions.getLastCodeCleanup());
        boolean keepLineBreaks = CodeStyle.getLanguageSettings((PsiFile)this.myFile).KEEP_LINE_BREAKS;
        this.myDoNotKeepLineBreaks.setVisible(keepLineBreaks);
        if (keepLineBreaks) {
            this.myDoNotKeepLineBreaks.setSelected(this.myLastRunOptions.isDoNotKeepLineBreaks());
        }
    }

    @Nullable
    @NlsContexts.Tooltip
    private String getChangesNotAvailableHint() {
        if (!VcsFacade.getInstance().isFileUnderVcs(this.myFile).booleanValue()) {
            return CodeInsightBundle.message("tooltip.file.not.under.vcs.root", new Object[0]);
        }
        if (!VcsFacade.getInstance().hasChanges(this.myFile)) {
            return CodeInsightBundle.message("tooltip.file.was.not.changed.since.last.revision", new Object[0]);
        }
        return null;
    }

    private void saveCurrentConfiguration() {
        if (this.myOptimizeImportsCb.isEnabled()) {
            this.myLastRunOptions.saveOptimizeImportsState(this.myRunOptions.isOptimizeImports());
        }
        if (this.myRearrangeCodeCb.isEnabled()) {
            this.myLastRunOptions.saveRearrangeState(this.myFile.getLanguage(), this.myRunOptions.isRearrangeCode());
        }
        if (this.myApplyCodeCleanup.isEnabled()) {
            this.myLastRunOptions.saveCodeCleanupState(this.myApplyCodeCleanup.isSelected());
        }
        if (!this.mySelectedTextRadioButton.isSelected() && this.myOnlyVCSChangedTextRb.isEnabled()) {
            this.myLastRunOptions.saveProcessVcsChangedTextState(this.myOnlyVCSChangedTextRb.isSelected());
        }
        if (this.myDoNotKeepLineBreaks.isVisible()) {
            this.myLastRunOptions.setDoNotKeepLineBreaks(this.myDoNotKeepLineBreaks.isSelected());
        }
    }

    private LayoutCodeOptions createOptionsBundledOnDialog() {
        return new LayoutCodeOptions(){

            @Override
            public TextRangeType getTextRangeType() {
                if (LayoutCodeDialog.this.myOnlyVCSChangedTextRb.isSelected()) {
                    return TextRangeType.VCS_CHANGED_TEXT;
                }
                if (LayoutCodeDialog.this.mySelectedTextRadioButton.isSelected()) {
                    return TextRangeType.SELECTED_TEXT;
                }
                return TextRangeType.WHOLE_FILE;
            }

            @Override
            public boolean isRearrangeCode() {
                return LayoutCodeDialog.this.myRearrangeCodeCb.isEnabled() && LayoutCodeDialog.this.myRearrangeCodeCb.isSelected();
            }

            @Override
            public boolean isOptimizeImports() {
                return LayoutCodeDialog.this.myOptimizeImportsCb.isEnabled() && LayoutCodeDialog.this.myOptimizeImportsCb.isSelected();
            }

            @Override
            public boolean isCodeCleanup() {
                return LayoutCodeDialog.this.myApplyCodeCleanup.isEnabled() && LayoutCodeDialog.this.myApplyCodeCleanup.isSelected();
            }

            @Override
            public boolean doNotKeepLineBreaks() {
                return LayoutCodeDialog.this.myDoNotKeepLineBreaks.isEnabled() && LayoutCodeDialog.this.myDoNotKeepLineBreaks.isSelected();
            }
        };
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myButtonsPanel;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doOKAction() {
        this.saveCurrentConfiguration();
        super.doOKAction();
    }

    public LayoutCodeOptions getRunOptions() {
        return this.myRunOptions;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myButtonsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(400, 222));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("reformat.scope.panel"), (int)0, (int)0, null, null));
        this.myOnlyVCSChangedTextRb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("radio.button.reformat.only.vcs.changed.text"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySelectedTextRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("radio.button.reformat.selected.text"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWholeFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("radio.button.reformat.whole.file"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("reformat.options.panel"), (int)0, (int)0, null, null));
        this.myOptimizeImportsCb = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("checkbox.optimize.imports"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRearrangeCodeCb = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("checkbox.rearrange.code"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myApplyCodeCleanup = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("checkbox.code.cleanup"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDoNotKeepLineBreaks = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle("messages/CodeInsightBundle", LayoutCodeDialog.class).getString("do.not.keep.line.breaks"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myButtonsPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/actions/LayoutCodeDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

