/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public abstract class MultiCaretCodeInsightAction
extends AnAction
implements PerformWithDocumentsCommitted {
    private static final Logger LOG = Logger.getInstance(MultiCaretCodeInsightAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Action " + this + " invoked on a disposed editor in " + e.getDataContext());
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)hostEditor)) {
            return;
        }
        PsiFile hostFile = PsiDocumentManager.getInstance(project2).getPsiFile(hostEditor.getDocument());
        if (hostFile != null && !FileModificationService.getInstance().prepareFileForWrite(hostFile)) {
            return;
        }
        this.actionPerformedImpl(project2, hostEditor);
    }

    public void actionPerformedImpl(Project project2, Editor hostEditor) {
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            MultiCaretCodeInsightActionHandler handler2 = this.getHandler();
            try {
                MultiCaretCodeInsightAction.iterateOverCarets(project2, hostEditor, handler2);
            }
            finally {
                handler2.postInvoke();
            }
        }), this.getCommandName(), DocCommandGroupId.noneGroupId(hostEditor.getDocument()));
        hostEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Disposed editor in " + e.getDataContext() + " for " + this);
            presentation2.setEnabled(false);
            return;
        }
        final Ref<Boolean> enabled = new Ref<Boolean>(Boolean.FALSE);
        MultiCaretCodeInsightAction.iterateOverCarets(project2, hostEditor, new MultiCaretCodeInsightActionHandler(){

            @Override
            public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull Caret caret, @NotNull PsiFile file2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (caret == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (MultiCaretCodeInsightAction.this.isValidFor(project2, editor2, caret, file2)) {
                    enabled.set(Boolean.TRUE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "caret";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        presentation2.setEnabled(enabled.get().booleanValue());
    }

    private static void iterateOverCarets(@NotNull Project project2, @NotNull Editor hostEditor, @NotNull MultiCaretCodeInsightActionHandler handler2) {
        if (project2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(3);
        }
        if (hostEditor == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(4);
        }
        if (handler2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(5);
        }
        PsiFile hostFile = PsiDocumentManager.getInstance(project2).getPsiFile(hostEditor.getDocument());
        hostEditor.getCaretModel().runForEachCaret(caret -> {
            PsiFile file2;
            Caret injectedCaret;
            Editor editor2 = hostEditor;
            if (hostFile != null && (injectedCaret = InjectedLanguageUtil.getCaretForInjectedLanguageNoCommit(caret, hostFile)) != null) {
                caret = injectedCaret;
                editor2 = caret.getEditor();
            }
            if ((file2 = PsiUtilBase.getPsiFileInEditor(caret, project2)) != null) {
                handler2.invoke(project2, editor2, caret, file2);
            }
        });
    }

    protected boolean isValidFor(@NotNull Project project2, @NotNull Editor editor2, @NotNull Caret caret, @NotNull PsiFile file2) {
        if (project2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(7);
        }
        if (caret == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(9);
        }
        return true;
    }

    @NotNull
    protected abstract MultiCaretCodeInsightActionHandler getHandler();

    @NlsContexts.Command
    protected String getCommandName() {
        String text2 = this.getTemplatePresentation().getText();
        return text2 == null ? "" : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverCarets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidFor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string2);
        };
    }
}

